/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.portletwindow;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelURL;
import com.sun.portal.container.WindowState;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PortletWindowChannelURL
implements ChannelURL {
    private String _desktopURL;
    private Map _params = new HashMap();
    private String _action;
    private ChannelMode _newChannelMode;
    private WindowState _newWindowState;
    private boolean _secure = false;
    public static final String KEYWORD_PREFIX = "window.";
    public static final String NEW_CHANNEL_MODE = "newChannelMode";
    public static final String NEW_WINDOW_STATE = "newWindowState";
    public static final String PORTLET_ACTION = "portletAction";

    public PortletWindowChannelURL(String desktopURL) {
        this._desktopURL = desktopURL;
    }

    public void setChannelMode(ChannelMode newChannelMode) {
        this._newChannelMode = newChannelMode;
    }

    public void setWindowState(WindowState newWindowState) {
        this._newWindowState = newWindowState;
    }

    public void setURLType(String type) {
        this._action = type;
    }

    public void setParameter(String name, String value) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, value);
    }

    public void setParameter(String name, String[] values) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, values);
    }

    public void setParameters(Map parametersMap) {
        this._params = parametersMap;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public WindowState getWindowState() {
        return this._newWindowState;
    }

    public ChannelMode getChannelMode() {
        return this._newChannelMode;
    }

    public String getURLType() {
        return this._action;
    }

    public Map getParameters() {
        return this._params;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._desktopURL);
        buf.append("&");
        buf.append(KEYWORD_PREFIX);
        buf.append(PORTLET_ACTION).append("=").append(this._action);
        if (this._newWindowState != null) {
            buf.append("&");
            buf.append(KEYWORD_PREFIX);
            buf.append(NEW_WINDOW_STATE).append("=").append(this._newWindowState);
        }
        if (this._newChannelMode != null) {
            buf.append("&");
            buf.append(KEYWORD_PREFIX);
            buf.append(NEW_CHANNEL_MODE).append("=").append(this._newChannelMode);
        }
        if (this._params != null) {
            Iterator i = this._params.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object val = this._params.get(key);
                if (this.isEncodingNeeded(key)) {
                    key = URLEncoder.encode(key);
                }
                if (val instanceof String) {
                    if (this.isEncodingNeeded((String)val)) {
                        val = URLEncoder.encode((String)val);
                    }
                    buf.append("&").append(key);
                    buf.append("=").append((String)val);
                    continue;
                }
                if (!(val instanceof String[])) continue;
                String[] vals = (String[])val;
                for (int j = 0; j < vals.length; ++j) {
                    if (this.isEncodingNeeded(vals[j])) {
                        vals[j] = URLEncoder.encode(vals[j]);
                    }
                    buf.append("&").append(key);
                    buf.append("=").append(vals[j]);
                }
            }
        }
        return buf.toString();
    }

    private boolean isEncodingNeeded(String value) {
        boolean needsEncoding = false;
        int length = value.length();
        for (int i = 0; !needsEncoding && i < length; ++i) {
            char c = value.charAt(i);
            needsEncoding = !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '-' || c == '*' || c == '_');
        }
        return needsEncoding;
    }
}

