/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.template;

import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.ParsedTagElement;

public class TagSwapperHelper {
    private static final String TAG = "tag:";
    private static final int TAG_LENGTH = "tag:".length();
    private static final String URL = "url:";
    private static final int URL_LENGTH = "url:".length();
    private static final String SURL = "surl:";
    private static final int SURL_LENGTH = "surl:".length();
    private static final String DTURL = "dturl";
    private static final int DTURL_LENGTH = "dturl".length();
    private static final String DTAG = "dtag:";
    private static final int DTAG_LENGTH = "dtag:".length();

    private static boolean tagEquals(StringBuffer b, String tag, int start, int length) {
        for (int i = 0; i < length; ++i) {
            if (tag.charAt(i) == b.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    public static void parseTemplate(StringBuffer in, ParsedTagArray result) {
        if (in != null) {
            int len = in.length();
            if (len == 0) {
                return;
            }
            int tokenType = 0;
            StringBuffer token = new StringBuffer(len);
            ParsedTagElement tagElement = null;
            block4: for (int i = 0; i < len; ++i) {
                char ch = in.charAt(i);
                switch (ch) {
                    case '[': {
                        if (i + DTAG_LENGTH < len && TagSwapperHelper.tagEquals(in, DTAG, i + 1, DTAG_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            }
                            tokenType = 5;
                            token = new StringBuffer(len);
                            i += DTAG_LENGTH;
                            continue block4;
                        }
                        if (i + TAG_LENGTH < len && TagSwapperHelper.tagEquals(in, TAG, i + 1, TAG_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            } else if (token.length() > 0 && tokenType == 5) {
                                tagElement = new ParsedTagElement(1, token.toString());
                            }
                            tokenType = 1;
                            token = new StringBuffer(len);
                            i += TAG_LENGTH;
                            continue block4;
                        }
                        if (i + URL_LENGTH < len && TagSwapperHelper.tagEquals(in, URL, i + 1, URL_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            } else if (token.length() > 0 && tokenType == 5) {
                                tagElement = new ParsedTagElement(1, token.toString());
                            }
                            tokenType = 2;
                            token = new StringBuffer(len);
                            i += URL_LENGTH;
                            continue block4;
                        }
                        if (i + SURL_LENGTH < len && TagSwapperHelper.tagEquals(in, SURL, i + 1, SURL_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            } else if (token.length() > 0 && tokenType == 5) {
                                tagElement = new ParsedTagElement(1, token.toString());
                            }
                            tokenType = 3;
                            token = new StringBuffer(len);
                            i += SURL_LENGTH;
                            continue block4;
                        }
                        if (i + DTURL_LENGTH < len && TagSwapperHelper.tagEquals(in, DTURL, i + 1, DTURL_LENGTH)) {
                            if (token.length() > 0 && tokenType == 0) {
                                result.appendParsedElement(0, token.toString());
                            } else if (token.length() > 0 && tokenType == 5) {
                                tagElement = new ParsedTagElement(1, token.toString());
                            }
                            tokenType = 4;
                            token = new StringBuffer(len);
                            i += DTURL_LENGTH;
                            continue block4;
                        }
                        token.append(ch);
                        continue block4;
                    }
                    case ']': {
                        ParsedTagElement pElement;
                        if (tokenType == 1) {
                            if (token.length() > 0 && tokenType == 1) {
                                if (tagElement != null) {
                                    pElement = new ParsedTagElement(1, token.toString());
                                    tagElement.setDefault(pElement);
                                    result.appendParsedElement(tagElement);
                                    tagElement = null;
                                } else {
                                    result.appendParsedElement(1, token.toString());
                                }
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            continue block4;
                        }
                        if (tokenType == 2) {
                            if (token.length() > 0 && tokenType == 2) {
                                if (tagElement != null) {
                                    pElement = new ParsedTagElement(2, token.toString());
                                    tagElement.setDefault(pElement);
                                    result.appendParsedElement(tagElement);
                                    tagElement = null;
                                } else {
                                    result.appendParsedElement(2, token.toString());
                                }
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            continue block4;
                        }
                        if (tokenType == 3) {
                            if (token.length() > 0 && tokenType == 3) {
                                if (tagElement != null) {
                                    pElement = new ParsedTagElement(3, token.toString());
                                    tagElement.setDefault(pElement);
                                    result.appendParsedElement(tagElement);
                                    tagElement = null;
                                } else {
                                    result.appendParsedElement(3, token.toString());
                                }
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            continue block4;
                        }
                        if (tokenType == 4) {
                            if (tagElement != null) {
                                pElement = new ParsedTagElement(4, token.toString());
                                tagElement.setDefault(pElement);
                                result.appendParsedElement(tagElement);
                                tagElement = null;
                            } else {
                                result.appendParsedElement(4, null);
                            }
                            tokenType = 0;
                            token = new StringBuffer(len);
                            continue block4;
                        }
                        token.append(ch);
                        continue block4;
                    }
                    default: {
                        token.append(ch);
                    }
                }
            }
            if (token.length() > 0) {
                result.appendParsedElement(0, token.toString());
            }
        }
    }
}

