/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.sun.liberty.LibertyManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.ServiceContext;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEServiceContext
implements ServiceContext,
DSAMEConstants {
    private static Set prefetchAttrs = new HashSet();
    protected DSAMEConnection dsameConn = null;
    protected static final String defaultLocaleString;
    protected static final String LOCALE_STRING = "localeString";
    protected static String serverProtocol;
    protected static String serverPort;
    protected static String serverHost;
    protected static String serverURL;

    public void init(HttpServletRequest req) {
        this.dsameConn = new DSAMEConnection(req);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.dsameConn = new DSAMEConnection(uid, pw);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
    }

    public String getLocaleString() {
        String localeString = null;
        if (ROC.containsObject(LOCALE_STRING)) {
            localeString = (String)ROC.getObject(LOCALE_STRING);
        } else {
            localeString = this.dsameConn.getAttributeFromROC("preferredlocale");
            if (localeString == null) {
                localeString = Locale.getLocaleStringFromAcceptLangHeader((String)RequestThreadLocalizer.getRequest().getHeader("accept-language"));
            }
            if (localeString == null) {
                localeString = this.dsameConn.getOrgAttributeFromROC("iPlanetAMAuthService", "iplanet-am-auth-locale");
            }
            if (localeString == null) {
                localeString = defaultLocaleString;
            }
            ROC.setObject(LOCALE_STRING, localeString);
        }
        return localeString;
    }

    public String getDesktopType() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopType");
    }

    public String getDefaultChannelName() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopDefaultChannelName");
    }

    public String getEditProviderContainerName() {
        return this.dsameConn.getAttributeFromROC("sunPortalDesktopEditProviderContainerName");
    }

    public String getDPContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpContextClassName");
    }

    public String getDPUserContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDpUserContextClassName");
    }

    public String getContainerProviderContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopContainerProviderContextClassName");
    }

    public String getProviderManagerContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopProviderManagerContextClassName");
    }

    public String getPropertiesContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopPropertiesContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopTemplateContextClassName");
    }

    public String getClientContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientContextClassName");
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public boolean isExecutable() {
        return this.dsameConn.isAllowed("sunPortalDesktopExecutable");
    }

    public String getLogoutURL() {
        Boolean federationEnabled = Boolean.valueOf(this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopEnableFederation"));
        StringBuffer logoutURLBuff = new StringBuffer(serverURL);
        if (federationEnabled.booleanValue()) {
            String providerID = this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopHostedProviderID");
            String metaAlias = null;
            if (providerID != null || providerID.length() != 0) {
                metaAlias = LibertyManager.getMetaAlias((String)providerID);
            }
            if (providerID == null || providerID.length() == 0 || metaAlias == null || metaAlias.length() == 0) {
                return this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-logout-url");
            }
            logoutURLBuff.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor")).append("/").append("liberty-logout").append("?").append(LibertyManager.getMetaAliasKey()).append("=").append(metaAlias);
            return logoutURLBuff.toString();
        }
        String attrLogoutURL = this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-logout-url");
        if (attrLogoutURL != null) {
            if (attrLogoutURL.indexOf("://") != -1) {
                return attrLogoutURL;
            }
            return logoutURLBuff.append(attrLogoutURL).toString();
        }
        return null;
    }

    public String getLoginURL() {
        String attrLoginURL = this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-login-url");
        if (attrLoginURL != null) {
            if (attrLoginURL.indexOf("://") != -1) {
                return attrLoginURL;
            }
            StringBuffer loginURLBuff = new StringBuffer(serverURL);
            return loginURLBuff.append(attrLoginURL).toString();
        }
        return null;
    }

    public String getDebugContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionContextClassName");
    }

    public String getAuthlessSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopAuthlessSessionContextClassName");
    }

    public String getWSRPSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopWSRPSessionContextClassName");
    }

    public String getStringAttribute(String name) {
        return this.dsameConn.getAttributeFromROC(name);
    }

    public void setStringAttribute(String name, String val) {
        this.dsameConn.setAttribute(name, val);
    }

    public Set getRoles() {
        return this.dsameConn.getRoleDNsFromROC();
    }

    static {
        prefetchAttrs.add("sunPortalDesktopDefaultChannelName");
        prefetchAttrs.add("sunPortalDesktopEditProviderContainerName");
        prefetchAttrs.add("sunPortalDesktopType");
        prefetchAttrs.add("preferredlocale");
        prefetchAttrs.add("sunPortalDesktopExecutable");
        prefetchAttrs.add("sunPortalDesktopDpDocumentUser");
        prefetchAttrs.add("sunPortalDesktopDpLastModifiedUser");
        defaultLocaleString = java.util.Locale.getDefault().toString();
        serverProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
        serverPort = SystemProperties.get((String)"com.iplanet.am.server.port");
        serverHost = SystemProperties.get((String)"com.iplanet.am.server.host");
        serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
    }
}

