/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.liberty.LibertyManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.ServiceAppContext;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DSAMEServiceAppContext
implements ServiceAppContext,
DSAMEConstants {
    protected static String serverProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    protected static String serverPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    protected static String serverHost = SystemProperties.get((String)"com.iplanet.am.server.host");
    protected static String serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
    private static final String ROC_AUTHORIZED_AUTHLESS_UIDS = "authorizedAuthlessUIDs";
    private static DSAMEConnection dsameConn = null;

    public synchronized void init() {
        this.initAdminDSAMEConnection();
    }

    protected DSAMEConnection getAdminDSAMEConnection() {
        if (dsameConn == null) {
            throw new ContextError("DSAMEServiceAppContext.getAdminDSAMEConnection(): not initialized");
        }
        return dsameConn;
    }

    private DSAMEConnection initAdminDSAMEConnection() {
        if (dsameConn == null) {
            try {
                SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
                SSOToken sso = ssom.createSSOToken(new Principal(){

                    public String getName() {
                        return AdminUtils.getAdminDN();
                    }
                }, new String(AdminUtils.getAdminPassword()));
                dsameConn = new DSAMEConnection(sso);
            }
            catch (SSOException se) {
                throw new ContextError("DSAMEServiceAppContext.initAdminDSAMEConnection()", se);
            }
        }
        return dsameConn;
    }

    public String getDebugContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionAppContextClassName");
    }

    public String getAuthlessSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopAuthlessSessionAppContextClassName");
    }

    public String getWSRPSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopWSRPSessionAppContextClassName");
    }

    public String getDesktopContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDesktopContextClassName");
    }

    public String getSessionContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionContextClassName");
    }

    public String getServiceContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopServiceContextClassName");
    }

    public String getClientContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopTemplateContextClassName");
    }

    public String getNoSessionURL() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-login-url");
    }

    public String getSessionReturnURLParamName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionReturnURLParamName");
    }

    public Map getAuthorizedAuthlessUIDs() {
        HashMap<String, String> authorized = (HashMap<String, String>)ROC.getObject(ROC_AUTHORIZED_AUTHLESS_UIDS);
        if (authorized == null) {
            Set uidPasswordPairs = this.getAdminDSAMEConnection().getGlobalAttributeMultiValueFromROC("SunPortalDesktopService", "sunPortalDesktopAuthorizedAuthlessUIDs");
            authorized = new HashMap<String, String>();
            Iterator i = uidPasswordPairs.iterator();
            while (i.hasNext()) {
                String pair = (String)i.next();
                int sep = pair.indexOf(124);
                String uid = pair.substring(0, sep);
                String pw = pair.substring(sep + 1);
                authorized.put(uid.toLowerCase(), pw);
            }
            ROC.setObject(ROC_AUTHORIZED_AUTHLESS_UIDS, authorized);
        }
        return authorized;
    }

    public String getDefaultAuthlessUID() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDefaultAuthlessUID");
    }

    public long getReapInterval() {
        long interval = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionReapInterval"));
        return interval;
    }

    public long getInactiveMax() {
        long maxInactive = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopSessionInactiveMaximum"));
        return maxInactive;
    }

    public long getClientSessionReapInterval() {
        long interval = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientSessionReapInterval"));
        return interval;
    }

    public long getClientSessionInactiveMax() {
        long maxInactive = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientSessionInactiveMaximum"));
        return maxInactive;
    }

    public long getClientSessionsMax() {
        long sessionsMax = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopClientSessionsMaximum"));
        return sessionsMax;
    }

    public boolean isAuthlessEnabled() {
        Boolean authlessEnabled = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopEnableAuthlessDesktop"));
        return authlessEnabled;
    }

    protected boolean isAuthlessEnabledForFederatedUsers() {
        Boolean authlessDisabledForFederatedUsers = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopDisableAuthlessForFederatedUsers"));
        return authlessDisabledForFederatedUsers == false;
    }

    public boolean isFederationEnabled() {
        Boolean federationEnabled = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", "sunPortalDesktopEnableFederation"));
        return federationEnabled;
    }

    public String getPreLoginURL(String returnURL, String libertySSOFailedParamName) {
        StringBuffer preLoginURL = new StringBuffer(serverURL);
        String providerID = this.getStringAttribute("sunPortalDesktopHostedProviderID");
        String metaAlias = null;
        if (providerID != null || providerID.length() != 0) {
            metaAlias = LibertyManager.getMetaAlias((String)providerID);
        }
        if (providerID == null || providerID.length() == 0 || metaAlias == null || metaAlias.length() == 0) {
            return null;
        }
        String deployDescriptor = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        preLoginURL.append(deployDescriptor).append("/").append("preLogin").append("?").append(LibertyManager.getMetaAliasKey()).append("=").append(metaAlias);
        if (this.isAuthlessEnabled()) {
            if (this.isAuthlessEnabledForFederatedUsers()) {
                preLoginURL.append("&").append("isPassive").append("=true");
            } else {
                preLoginURL.append("&").append("isPassive").append("=false");
            }
            preLoginURL.append("&").append("gotoOnFedCookieNo").append("=");
            StringBuffer onFedCookieNoURL = new StringBuffer(returnURL);
            if (returnURL.indexOf(63) != -1) {
                onFedCookieNoURL.append("&");
            } else {
                onFedCookieNoURL.append("?");
            }
            onFedCookieNoURL.append(libertySSOFailedParamName).append("=true");
            preLoginURL.append(URLEncoder.encode(onFedCookieNoURL.toString()));
        }
        preLoginURL.append("&goto=").append(URLEncoder.encode(returnURL));
        return preLoginURL.toString();
    }

    public String getStringAttribute(String name) {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC("SunPortalDesktopService", name);
    }

    public void setStringAttribute(String name, String val) {
        this.getAdminDSAMEConnection().setGlobalAttribute("SunPortalDesktopService", name, val);
    }
}

