/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEConnection
implements DSAMEConstants {
    public static final String ROC_NODE_NAMES = "nodeNames";
    public static final String ROC_ROLES = "roles";
    protected static final String GLOBAL_KEY = "_!global!_";
    protected AMUser user = null;
    protected AMStoreConnection connection = null;
    private static SSOTokenManager _tokenMgr = null;
    private static AMStoreConnection adminConnection = null;
    private static PolicyEvaluator policyEvaluator = null;
    private SSOToken ssoToken = null;
    private static DesktopAppContext dac = null;

    public DSAMEConnection(HttpServletRequest req) {
        this(DSAMEConnection.getSSOToken(req));
    }

    public DSAMEConnection(SSOToken token) {
        try {
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEConnection.DSAMEConnection()", se);
        }
        this.init(token);
    }

    public DSAMEConnection(final String uid, String pw) {
        SSOToken token = null;
        try {
            SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
            token = ssom.createSSOToken(new Principal(){

                public String getName() {
                    return uid;
                }
            }, pw);
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEAdminContext.init(): Failed to create SSOToken", se);
        }
        this.init(token);
    }

    protected void init(SSOToken token) {
        this.ssoToken = token;
        try {
            String uid = token.getPrincipal().getName();
            this.user = this.connection.getUser(uid);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEConnection.init()", se);
        }
    }

    private static void log(Object o) {
        try {
            dac = DesktopAppContextThreadLocalizer.get();
        }
        catch (ContextError contextError) {
            // empty catch block
        }
        if (dac != null) {
            dac.debugError(o.toString());
        }
    }

    private static void log(Object o, Throwable e) {
        try {
            dac = DesktopAppContextThreadLocalizer.get();
        }
        catch (ContextError contextError) {
            // empty catch block
        }
        if (dac != null) {
            dac.debugError(o.toString(), e);
        }
    }

    private static void trace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            DSAMEConnection.log("DSAMEConnection.trace", e);
            return;
        }
    }

    private static int mark() {
        int i = 0;
        try {
            i = PerfThreadLocalizer.mark();
        }
        catch (DesktopError desktopError) {
            // empty catch block
        }
        return i;
    }

    private static void add(int i, String key) {
        try {
            PerfThreadLocalizer.add(i, key);
        }
        catch (DesktopError desktopError) {
            // empty catch block
        }
    }

    public Set getRoleDNsFromROC() {
        Set names = null;
        if (ROC.containsObject(ROC_ROLES)) {
            names = (Set)ROC.getObject(ROC_ROLES);
        } else {
            names = this.getRoleDNs();
            ROC.setObject(ROC_ROLES, names);
        }
        return names;
    }

    public Set getNodeNamesFromROC() {
        Set names = null;
        if (ROC.containsObject(ROC_NODE_NAMES)) {
            names = (Set)ROC.getObject(ROC_NODE_NAMES);
        } else {
            names = this.getNodeNames();
            ROC.setObject(ROC_NODE_NAMES, names);
        }
        return names;
    }

    public Set getNodeNames(String dn) {
        HashSet<String> names = new HashSet<String>();
        try {
            int objType = this.getAdminConnection().getAMObjectType(dn);
            switch (objType) {
                case 1: {
                    AMUser user = this.getAdminConnection().getUser(dn);
                    names.addAll(this.getUserNodeNames(user));
                    break;
                }
                case 2: {
                    AMOrganization org = this.getAdminConnection().getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.getNodeNames(): Organization not found.  dn=" + dn);
                    }
                    names.add(GLOBAL_KEY);
                    String rootDN = DSAMEConnection.getRootDN();
                    if (org.getDN().equals(rootDN)) break;
                    names.add(rootDN);
                    String orgDN = org.getParentDN();
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                case 6: {
                    AMRole role = this.getAdminConnection().getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.getNodeNames(): Role not found.  dn=" + dn);
                    }
                    String orgDN = role.getParentDN();
                    String rootDN = DSAMEConnection.getRootDN();
                    names.add(GLOBAL_KEY);
                    names.add(rootDN);
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                case 8: {
                    AMFilteredRole frole = this.getAdminConnection().getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.getNodeNames(): filtered role not found. dn=" + dn);
                    }
                    String orgDN = frole.getParentDN();
                    String rootDN = DSAMEConnection.getRootDN();
                    names.add(GLOBAL_KEY);
                    names.add(rootDN);
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.getNodeNames(): Unsupported AMObject found.  dn=" + dn);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnectoin.getNodeNames(): dn=" + dn, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnectoin.getNodeNames(): dn=" + dn, sso);
        }
        return names;
    }

    public Set getNodeNames() {
        int j = DSAMEConnection.mark();
        Set names = this.getUserNodeNames(this.user);
        DSAMEConnection.add(j, "DSAMEConnection.getNodeNames()");
        return names;
    }

    public Set getRoleDNs() {
        Set roleDNs = null;
        HashSet<String> names = new HashSet<String>();
        try {
            roleDNs = this.user.getRoleDNs();
            Iterator i = roleDNs.iterator();
            while (i.hasNext()) {
                String roleDN = (String)i.next();
                if (roleDN == null || roleDN.length() <= 0) continue;
                names.add(roleDN);
            }
            Set filteredRoleDNs = this.user.getFilteredRoleDNs();
            Iterator i2 = filteredRoleDNs.iterator();
            while (i2.hasNext()) {
                String filteredRoleDN = (String)i2.next();
                if (filteredRoleDN == null || filteredRoleDN.length() <= 0) continue;
                names.add(filteredRoleDN);
            }
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getRoleDNs(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMEConnection.getRoleDNs(): ", ssoe);
        }
        return names;
    }

    private Set getUserNodeNames(AMUser user) {
        HashSet<String> names = new HashSet<String>();
        try {
            Set roleDNs;
            String orgDN = user.getOrganizationDN();
            String rootDN = DSAMEConnection.getRootDN();
            names.add(GLOBAL_KEY);
            names.add(rootDN);
            if (orgDN != null && orgDN.length() > 0) {
                while (!orgDN.equalsIgnoreCase(rootDN)) {
                    AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                    names.add(orgDN);
                    orgDN = org.getParentDN();
                }
            }
            if (this.user == user) {
                roleDNs = this.getRoleDNsFromROC();
                Iterator i = roleDNs.iterator();
                while (i.hasNext()) {
                    String roleDN = (String)i.next();
                    if (roleDN == null || roleDN.length() <= 0) continue;
                    names.add(roleDN);
                }
            } else {
                roleDNs = user.getRoleDNs();
                Iterator i = roleDNs.iterator();
                while (i.hasNext()) {
                    String roleDN = (String)i.next();
                    if (roleDN == null || roleDN.length() <= 0) continue;
                    names.add(roleDN);
                }
                Set filteredRoleDNs = user.getFilteredRoleDNs();
                Iterator i2 = filteredRoleDNs.iterator();
                while (i2.hasNext()) {
                    String froleDN = (String)i2.next();
                    if (froleDN == null || froleDN.length() <= 0) continue;
                    names.add(froleDN);
                }
            }
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getUserNodeNames(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMEConnection.getUserNodeNames(): ", ssoe);
        }
        return names;
    }

    private AMStoreConnection getAdminConnection() {
        if (adminConnection == null) {
            try {
                SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
                SSOToken sso = ssom.createSSOToken(new Principal(){

                    public String getName() {
                        return AdminUtils.getAdminDN();
                    }
                }, new String(AdminUtils.getAdminPassword()));
                adminConnection = new AMStoreConnection(sso);
            }
            catch (SSOException se) {
                throw new ContextError("DSAMEConnection.getAdminConnection(): ", se);
            }
        }
        return adminConnection;
    }

    public String getAttributeByDN(String dn, String key) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.getAttributeByDN(): DN passed in was NULL.");
        }
        String value = null;
        try {
            if (dn.equals(GLOBAL_KEY)) {
                value = this.getGlobalAttribute("SunPortalDesktopService", key);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    int i = DSAMEConnection.mark();
                    AMUser u = this.connection.getUser(dn);
                    DSAMEConnection.add(i, "DSAMEConnection.getAttributeByDN().getUser");
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.getAttributeByDN(): User not found.  dn=" + dn);
                    }
                    Set vals = u.getAttribute(key + "User");
                    if (vals != null && vals.size() > 0) {
                        Iterator iter = vals.iterator();
                        value = (String)iter.next();
                    }
                } else {
                    value = this.getTemplateAttribute(dn, "SunPortalDesktopService", key);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.getAttributeByDN(): dn=" + dn + ": ", dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.getAttributeByDN(): dn=" + dn + ": ", sso);
        }
        return value;
    }

    public void setAttributeByDN(String dn, String key, String val) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): DN passed in was NULL.");
        }
        if (key == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): attrbiute key was NULL.");
        }
        if (val == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): attrbiute value was NULL.");
        }
        try {
            if (dn.equals(GLOBAL_KEY)) {
                this.setGlobalAttribute("SunPortalDesktopService", key, val);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    int i = DSAMEConnection.mark();
                    AMUser u = this.connection.getUser(dn);
                    DSAMEConnection.add(i, "DSAMEConnection.getAttributeByDN().getUser");
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.setAttributeByDN(): User not found: " + dn);
                    }
                    u.setStringAttribute(key + "User", val);
                    u.store();
                } else {
                    this.setTemplateAttribute(dn, "SunPortalDesktopService", key, val);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): dn=" + dn + ", key=" + key, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): dn=" + dn + ", key=" + key, sso);
        }
    }

    public void removeAttributeByDN(String dn, String key) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.getDPAttributeByDN(): DN passed in was NULL.");
        }
        try {
            if (dn.equals(GLOBAL_KEY)) {
                this.removeGlobalAttribute("SunPortalDesktopService", key);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    int i = DSAMEConnection.mark();
                    AMUser u = this.connection.getUser(dn);
                    DSAMEConnection.add(i, "DSAMEConnection.getAttributeByDN().getUser");
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.getDPAttributeByDN(): User not found.  dn=" + dn);
                    }
                    HashSet<String> attrs = new HashSet<String>();
                    attrs.add(key + "User");
                    u.removeAttributes(attrs);
                } else {
                    this.removeTemplateAttribute(dn, "SunPortalDesktopService", key);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.removeAttributeByDN(): dn=" + dn, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.removeAttributeByDN(): dn=" + dn, sso);
        }
    }

    public String getAttribute(String attributeName) {
        String val = null;
        Set vals = this.getAttributeMultiVal(attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public byte[] getAttributeByteArray(String attributeName) {
        int j = DSAMEConnection.mark();
        byte[] val = null;
        byte[][] vals = null;
        try {
            vals = this.user.getAttributeByteArray(attributeName);
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getAttributeByteArray()", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMEConnection.getAttributeByteArray()", ssoe);
        }
        if (vals != null && vals.length > 0) {
            val = vals[0];
        }
        DSAMEConnection.add(j, "DSAMEConnection.getAttributeByteArray()");
        return val;
    }

    public int getIntAttribute(String attributeName) {
        String valStr = this.getAttribute(attributeName);
        int valInt = -1;
        try {
            valInt = Integer.parseInt(valStr);
        }
        catch (NumberFormatException nfe) {
            throw new ContextError("DSAMEConnection.getIntAttribute(): Invalid integer value returned.  attribute=" + attributeName, nfe);
        }
        return valInt;
    }

    public Set getAttributeMultiVal(String attributeName) {
        int j = DSAMEConnection.mark();
        Set vals = null;
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getAttributeMultiVal(): attributeName=" + attributeName, e);
        }
        DSAMEConnection.add(j, "DSAMEConnection.getAttributeMultiVal()");
        return vals;
    }

    public void setAttribute(String attributeName, String val) {
        int j = DSAMEConnection.mark();
        try {
            this.user.setStringAttribute(attributeName, val);
            this.user.store();
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.setAttribute(): attributeName=" + attributeName + " value=" + val + "  Exception:  ", e);
        }
        DSAMEConnection.add(j, "DSAMEConnection.setAttribute()");
    }

    public String getOrganizationAttribute(String serviceName, String attributeName) {
        String val = null;
        String dn = null;
        int j = DSAMEConnection.mark();
        try {
            dn = this.user.getOrganizationDN();
            AMOrganization amo = null;
            int type = this.getAdminConnection().getAMObjectType(dn);
            switch (type) {
                case 2: {
                    amo = this.getAdminConnection().getOrganization(dn);
                    break;
                }
                case 3: {
                    amo = this.getAdminConnection().getOrganizationalUnit(dn);
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.getOrganizationAttribute(): unknown am object type for dn=" + dn + ", serviceName=" + serviceName);
                }
            }
            if (amo == null) {
                throw new ContextError("DSAMEConnection.getOrganizationAttribute(): org / org unit  not found, dn=" + dn + ", serviceName=" + serviceName);
            }
            AMTemplate temp = amo.getTemplate(serviceName, 302);
            long start = System.currentTimeMillis();
            boolean tempExists = temp != null && temp.isExists();
            long now = System.currentTimeMillis();
            if (!tempExists) {
                throw new ContextError("DSAMEConnection.getOrganizationAttribute(): No template found.  dn=" + dn + ", serviceName=" + serviceName);
            }
            Set vals = temp.getAttribute(attributeName);
            if (vals != null && vals.size() > 0) {
                Iterator iter = vals.iterator();
                val = (String)iter.next();
            }
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getOrganizationAttribute(): dn=" + dn + "serviceName=" + serviceName + ", attributeName=" + attributeName, e);
        }
        DSAMEConnection.add(j, "DSAMEConnection.getOrganizationAttribute()");
        return val;
    }

    public String getGlobalAttribute(String serviceName, String attributeName) {
        Set vals = this.getGlobalAttributeMultiValue(serviceName, attributeName);
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    public Set getGlobalAttributeMultiValue(String serviceName, String attributeName) {
        Map attrs = this.getGlobalAttributes(serviceName);
        Set vals = (Set)attrs.get(attributeName);
        return vals;
    }

    public Map getGlobalAttributes(String serviceName) {
        Map attrs = null;
        int j = DSAMEConnection.mark();
        try {
            AMSchema schema = this.connection.getSchema(serviceName, AMSchema.Type.GLOBAL);
            attrs = schema.getReadOnlyAttributeDefaults();
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getGlobalAttributes(): " + serviceName, ame);
        }
        DSAMEConnection.add(j, "DSAMEConnection.getGlobalAttributes()");
        return attrs;
    }

    public void setGlobalAttribute(String serviceName, String attributeName, String val) {
        int j = DSAMEConnection.mark();
        try {
            AMSchema schema = this.connection.getSchema(serviceName, AMSchema.Type.GLOBAL);
            HashSet<String> vals = new HashSet<String>();
            vals.add(val);
            schema.setAttributeDefaults(attributeName, vals);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.setGlobalAttribute(): " + serviceName + "." + attributeName + "=" + val, e);
        }
        DSAMEConnection.add(j, "DSAMEConnection.setGlobalAttribute()");
    }

    public void removeGlobalAttribute(String serviceName, String attributeName) {
        int j = DSAMEConnection.mark();
        HashSet<String> attrs = new HashSet<String>();
        attrs.add(attributeName);
        try {
            AMSchema schema = this.connection.getSchema(serviceName, AMSchema.Type.GLOBAL);
            schema.removeAttributeDefaults(attrs);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.removeGlobalAttribute(): " + serviceName + "." + attributeName, e);
        }
        DSAMEConnection.add(j, "DSAMEConnection.removeGlobalAttribute()");
    }

    public String getPolicyAttribute(String attributeName) {
        int j = DSAMEConnection.mark();
        Set vals = null;
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getPolicyAttribute(): " + attributeName, e);
        }
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        DSAMEConnection.add(j, "DSAMEConnection.getPolicyAttribute()");
        return val;
    }

    private String getTemplateAttribute(String dn, String serviceName, String attributeName) {
        int j = DSAMEConnection.mark();
        String val = null;
        int objType = -1;
        try {
            objType = this.getAdminConnection().getAMObjectType(dn);
            AMTemplate temp = null;
            if (objType == 2) {
                AMOrganization org = this.getAdminConnection().getOrganization(dn);
                if (org == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = org.getTemplate(serviceName, 301);
            } else if (objType == 6) {
                AMRole role = this.getAdminConnection().getRole(dn);
                if (role == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = role.getTemplate(serviceName, 301);
            } else if (objType == 8) {
                AMFilteredRole frole = this.getAdminConnection().getFilteredRole(dn);
                if (frole == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = frole.getTemplate(serviceName, 301);
            } else if (objType == 3) {
                AMOrganizationalUnit ou = this.getAdminConnection().getOrganizationalUnit(dn);
                if (ou == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): ou not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = ou.getTemplate(serviceName, 301);
            } else {
                throw new ContextError("DSAMEConnection.getTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName + ", objectType=" + objType);
            }
            long start = System.currentTimeMillis();
            boolean tempExists = temp != null && temp.isExists();
            long now = System.currentTimeMillis();
            if (!tempExists) {
                return null;
            }
            Set vals = temp.getAttribute(attributeName);
            if (vals != null && vals.size() > 0) {
                Iterator iter = vals.iterator();
                val = (String)iter.next();
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.getTemplateAttribute(): dn=" + dn + ", serviceName=" + serviceName + ", attribute=" + attributeName, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.getTemplateAttribute(): dn=" + dn + ", serviceName=" + serviceName + ", attribute=" + attributeName, sso);
        }
        DSAMEConnection.add(j, "DSAMEConnection.getTemplateAttribute()");
        return val;
    }

    private void setTemplateAttribute(String dn, String serviceName, String attributeName, String val) {
        int j = DSAMEConnection.mark();
        Object value = null;
        try {
            int objType = this.connection.getAMObjectType(dn);
            switch (objType) {
                case 2: {
                    boolean tempExists;
                    AMOrganization org = this.connection.getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = org.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): No template found in the given org.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                case 6: {
                    boolean tempExists;
                    AMRole role = this.connection.getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = role.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): No template defined.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                case 8: {
                    boolean tempExists;
                    AMFilteredRole frole = this.connection.getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = frole.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): No template defined.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.setTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName + "=" + val, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.setTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName + "=" + val, sso);
        }
        DSAMEConnection.add(j, "DSAMEConnection.setTemplateAttribute()");
    }

    private void removeTemplateAttribute(String dn, String serviceName, String attributeName) {
        int j = DSAMEConnection.mark();
        try {
            int objType = this.connection.getAMObjectType(dn);
            HashSet<String> attrs = new HashSet<String>();
            attrs.add(attributeName);
            switch (objType) {
                case 2: {
                    boolean tempExists;
                    AMOrganization org = this.connection.getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = org.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): No template found in the given org.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                case 6: {
                    boolean tempExists;
                    AMRole role = this.connection.getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = role.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): No template defined.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                case 8: {
                    boolean tempExists;
                    AMFilteredRole frole = this.connection.getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = frole.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): No template defined.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.removeTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("DSAMEConnection.removeTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName, sso);
        }
        DSAMEConnection.add(j, "DSAMEConnection.removeTemplateAttribute()");
    }

    protected static SSOToken getSSOToken(HttpServletRequest request) {
        SSOToken token = null;
        try {
            token = DSAMEConnection.getSSOTokenManager().createSSOToken(request);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEConnection.getSSOToken(): Failed to get SSOToken.  ", se);
        }
        return token;
    }

    protected static SSOTokenManager getSSOTokenManager() {
        if (_tokenMgr == null) {
            try {
                _tokenMgr = SSOTokenManager.getInstance();
                if (_tokenMgr == null) {
                    throw new ContextError("DSAMEConnection.getSSOTokenMgr(): Failed to get SSOTokenManager. ");
                }
            }
            catch (SSOException se) {
                throw new ContextError("DSAMEConnection.getSSOTokenMgr(): Failed to get SSOTokenManager.  ", se);
            }
        }
        return _tokenMgr;
    }

    public static String getRootDN() {
        return SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    }

    public void prefetchAttributes(Set names) {
        try {
            this.user.getAttributes(names);
        }
        catch (AMException dpe) {
            throw new ContextError("DAMEConnection.prefetchAttributes(): names=" + names, dpe);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMEConnection.prefetchAttributes(): names=" + names, ssoe);
        }
    }

    public String getAttributeFromROC(String key) {
        String v = null;
        if (ROC.containsObject(key)) {
            v = (String)ROC.getObject(key);
        } else {
            v = this.getAttribute(key);
            ROC.setObject(key, v);
        }
        return v;
    }

    public byte[] getAttributeByteArrayFromROC(String key) {
        byte[] v = null;
        if (ROC.containsObject(key)) {
            v = (byte[])ROC.getObject(key);
        } else {
            v = this.getAttributeByteArray(key);
            ROC.setObject(key, v);
        }
        return v;
    }

    public String getOrgAttributeFromROC(String service, String key) {
        String s = null;
        if (ROC.containsObject(key)) {
            s = (String)ROC.getObject(key);
        } else {
            s = this.getOrganizationAttribute(service, key);
            ROC.setObject(key, s);
        }
        return s;
    }

    protected String getGlobalAttributeFromROC(String service, String key) {
        Set vals = this.getGlobalAttributeMultiValueFromROC(service, key);
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    protected Set getGlobalAttributeMultiValueFromROC(String service, String key) {
        String rocKey = service + "." + key;
        Map attrs = (Map)ROC.getObject(rocKey);
        if (attrs == null) {
            attrs = this.getGlobalAttributes(service);
            ROC.setObject(rocKey, attrs);
        }
        Set vals = (Set)attrs.get(key);
        return vals;
    }

    public String getAttributeByDNFromROC(String dn, String key) {
        String value = null;
        if (dn.equals(GLOBAL_KEY)) {
            value = this.getGlobalAttributeFromROC("SunPortalDesktopService", key);
        } else {
            int objType;
            try {
                objType = this.getAdminConnection().getAMObjectType(dn);
            }
            catch (AMException ame) {
                throw new ContextError("DSAMEConnection.getAttrbiuteByDNFromROC()", ame);
            }
            catch (SSOException ssoe) {
                throw new ContextError("DSAMEConnection.getAttrbiuteByDNFromROC()", ssoe);
            }
            value = objType == 1 ? this.getAttributeFromROC(key + "User") : this.getTemplateAttribute(dn, "SunPortalDesktopService", key);
        }
        return value;
    }

    private static PolicyEvaluator getPolicyEvaluator() {
        if (policyEvaluator == null) {
            try {
                policyEvaluator = new PolicyEvaluator("SunPortalDesktopService");
            }
            catch (SSOException ssoe) {
                throw new ContextError("DAMEConnection.getPolicyEvaluator(): ", ssoe);
            }
            catch (NameNotFoundException nnfe) {
                throw new ContextError("DAMEConnection.getPolicyEvaluator(): Service name not found. ", nnfe);
            }
            catch (PolicyException pe) {
                throw new ContextError("DAMEConnection.getPolicyEvaluator(): ", pe);
            }
        }
        return policyEvaluator;
    }

    public boolean isAllowed(String actionName) {
        boolean allowed = false;
        try {
            allowed = DSAMEConnection.getPolicyEvaluator().isAllowed(this.ssoToken, "", actionName, Collections.EMPTY_MAP);
        }
        catch (SSOException ssoe) {
            throw new ContextError("DAMEConnection.isAllowed(): ", ssoe);
        }
        catch (PolicyException pe) {
            throw new ContextError("DAMEConnection.isAllowed(): ", pe);
        }
        return allowed;
    }
}

