/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import com.aligo.pim.PimSortType;
import com.aligo.pim.exchangewebdav.util.NameSpace;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebDavHelper {
    public static String createPropertyUpdateXml(Vector toSendVector) {
        Vector allNameSpaces = new Vector();
        Document document = DocumentFactory.createDOMDocument();
        Element rootElement = document.createElement("DAV:propertyupdate");
        rootElement.setAttribute(NameSpace.DAV.getXmlnsString(), NameSpace.DAV.getActualNameSpace());
        int i = 0;
        while (i < toSendVector.size()) {
            PropertyHolder propertyHolder = (PropertyHolder)toSendVector.elementAt(i);
            Element setElement = document.createElement(NameSpace.DAV + "set");
            Element propElement = document.createElement(NameSpace.DAV + "prop");
            propElement.appendChild(propertyHolder.getAsElement(document));
            setElement.appendChild(propElement);
            rootElement.appendChild(setElement);
            Vector all = propertyHolder.getAllNameSpaces();
            int j = 0;
            while (j < all.size()) {
                allNameSpaces.add(all.elementAt(j));
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < allNameSpaces.size()) {
            NameSpace nameSpace = (NameSpace)allNameSpaces.elementAt(i2);
            rootElement.setAttribute(nameSpace.getXmlnsString(), nameSpace.getActualNameSpace());
            ++i2;
        }
        return XMLUtilities.toXMLStringNS(rootElement);
    }

    public static String createPropFindXml(Vector toSendVector) {
        Vector allNameSpaces = new Vector();
        Document document = DocumentFactory.createDOMDocument();
        Element rootElement = document.createElement(WebDavField.PROPFIND.toString());
        rootElement.setAttribute(NameSpace.DAV.getXmlnsString(), NameSpace.DAV.getActualNameSpace());
        Element propElement = document.createElement(WebDavField.PROP.toString());
        int i = 0;
        while (i < toSendVector.size()) {
            PropertyHolder propertyHolder = (PropertyHolder)toSendVector.elementAt(i);
            propElement.appendChild(propertyHolder.getAsElement(document));
            Vector all = propertyHolder.getAllNameSpaces();
            int j = 0;
            while (j < all.size()) {
                allNameSpaces.add(all.elementAt(j));
                ++j;
            }
            ++i;
        }
        rootElement.appendChild(propElement);
        int i2 = 0;
        while (i2 < allNameSpaces.size()) {
            NameSpace nameSpace = (NameSpace)allNameSpaces.elementAt(i2);
            rootElement.setAttribute(nameSpace.getXmlnsString(), nameSpace.getActualNameSpace());
            ++i2;
        }
        return XMLUtilities.toXMLStringNS(rootElement);
    }

    public static String createSearchRequestXml(Vector selectVector, String fromString, String whereString, String orderByString, PimSortType pimSortType) {
        Document document = DocumentFactory.createDOMDocument();
        Element rootElement = document.createElement(WebDavField.SEARCHREQUEST.toString());
        rootElement.setAttribute(NameSpace.DAV.getXmlnsString(), NameSpace.DAV.getActualNameSpace());
        Element sqlElement = document.createElement(WebDavField.SQL + "");
        StringBuffer strb = new StringBuffer();
        strb.append(" SELECT  ");
        int i = 0;
        while (i < selectVector.size()) {
            if (i != 0) {
                strb.append(",");
            }
            PropertyHolder propertyHolder = (PropertyHolder)selectVector.elementAt(i);
            strb.append("\"" + propertyHolder.getActualNameSpaceWithProperty() + "\"");
            ++i;
        }
        strb.append(" FROM ");
        strb.append("\"" + fromString + "\"");
        if (whereString != null) {
            strb.append(" WHERE ");
            strb.append("(");
            strb.append(whereString);
            strb.append(")");
        }
        if (orderByString != null && pimSortType != null) {
            String orderString;
            strb.append(" ORDER BY ");
            if (pimSortType.equals(PimSortType.ASCENDING)) {
                orderString = StringUtility.replace(orderByString, "*TEMPL*", "ASC");
                strb.append(orderString);
            } else {
                orderString = StringUtility.replace(orderByString, "*TEMPL*", "DESC");
                strb.append(orderString);
            }
        }
        sqlElement.appendChild(document.createTextNode(strb.toString()));
        rootElement.appendChild(sqlElement);
        return XMLUtilities.toXMLStringNS(rootElement);
    }
}

