/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTimeZoneGMTTypeMapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class WebDavDate {
    private Date m_oDate;
    private String m_szFormattedDate;
    private ExWebDavPimSession m_oPimSession;

    public WebDavDate(Date date) {
        this.m_oDate = date;
    }

    public WebDavDate(Date date, ExWebDavPimSession pimSession) {
        PimTimeZoneType pimTimeZoneType;
        this.m_oPimSession = pimSession;
        if (!pimSession.isTimeZoneSetByUser()) {
            Calendar timeZoneDate = Calendar.getInstance();
            timeZoneDate.setTime(date);
            TimeZone actualTimeZone = timeZoneDate.getTimeZone();
            String displayName = actualTimeZone.getDisplayName(true, 0);
            PimTimeZoneType pimTimeZoneType2 = ExWebDavPimTimeZoneGMTTypeMapper.getType(displayName);
            pimSession.setTimeZoneInternal(pimTimeZoneType2);
        }
        if ((pimTimeZoneType = this.m_oPimSession.getTimeZone()).equals(PimTimeZoneType.MOUNTAIN)) {
            pimTimeZoneType = PimTimeZoneType.ARIZONA;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ExWebDavPimTimeZoneGMTTypeMapper.getType(pimTimeZoneType)));
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(date);
        cal.set(5, local.get(5));
        cal.set(2, local.get(2));
        cal.set(1, local.get(1));
        cal.set(11, local.get(11));
        cal.set(12, local.get(12));
        cal.set(13, local.get(13));
        cal.set(14, local.get(14));
        this.m_oDate = cal.getTime();
    }

    public WebDavDate(String formattedString, boolean isItRecurringFormat, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            this.m_szFormattedDate = formattedString;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_oDate = sdf.parse(this.m_szFormattedDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate(String formattedString, ExWebDavPimSession pimSession, boolean taskTime) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            this.m_szFormattedDate = formattedString;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            if (!taskTime) {
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                sdf.setTimeZone(timeZone);
            }
            this.m_oDate = sdf.parse(this.m_szFormattedDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate(String formattedString, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            this.m_szFormattedDate = formattedString;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_oDate = sdf.parse(this.m_szFormattedDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getDate() {
        return this.m_oDate;
    }

    public String getWebDavDateFormat() {
        if (this.getDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getDate());
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            return this.getCalParam(cal, 1) + "/" + this.getCalParam(cal, 2) + "/" + this.getCalParam(cal, 5) + " " + this.getCalParam(cal, 11) + ":" + this.getCalParam(cal, 12) + ":" + this.getCalParam(cal, 13);
        }
        return "";
    }

    private String getCalParam(Calendar cal, int param) {
        int i = cal.get(param);
        if (param == 2) {
            ++i;
        }
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public int getIntegerMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_oDate);
        return cal.get(2) + 1;
    }

    public int getIntegerDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_oDate);
        return cal.get(5);
    }

    public void resetToNextDay() {
        PimTimeZoneType pimTimeZoneType = this.m_oPimSession.getTimeZone();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ExWebDavPimTimeZoneGMTTypeMapper.getType(pimTimeZoneType)));
        cal.setTime(this.m_oDate);
        cal.set(cal.get(1), cal.get(2), cal.get(5) + 1, 0, 0, 0);
        cal.set(14, 0);
        this.m_oDate = cal.getTime();
    }

    public void resetToThisDay() {
        PimTimeZoneType pimTimeZoneType = this.m_oPimSession.getTimeZone();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ExWebDavPimTimeZoneGMTTypeMapper.getType(pimTimeZoneType)));
        cal.setTime(this.m_oDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.m_oDate = cal.getTime();
    }

    public String getFormattedDateForRecurrence() {
        if (this.m_oDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_szFormattedDate = sdf.format(this.m_oDate);
        }
        return this.m_szFormattedDate;
    }

    public String getFormattedDateWithouTime() {
        if (this.m_oDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_szFormattedDate = sdf.format(this.m_oDate);
        }
        return this.m_szFormattedDate;
    }

    public String getFormattedDate() {
        if (this.m_oDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_szFormattedDate = sdf.format(this.m_oDate);
        }
        return this.m_szFormattedDate;
    }

    public boolean equals(WebDavDate date) {
        int result;
        Date toCompare;
        return this.m_oDate != null && date != null && (toCompare = date.getDate()) != null && (result = toCompare.compareTo(this.m_oDate)) == 0;
    }

    public boolean after(WebDavDate date) {
        Date toCompare;
        if (this.m_oDate != null && date != null && (toCompare = date.getDate()) != null) {
            return this.m_oDate.after(toCompare);
        }
        return false;
    }
}

