/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import com.aligo.pim.exchangewebdav.util.NameSpace;
import com.aligo.pim.exchangewebdav.util.WebDavDataType;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyHolder {
    private WebDavField m_oWebDavField;
    private Object m_oValue;

    public PropertyHolder(WebDavField webDavField, Object oValue) {
        this.m_oWebDavField = webDavField;
        this.m_oValue = oValue;
    }

    public PropertyHolder(WebDavField webDavField) {
        this.m_oWebDavField = webDavField;
    }

    public Vector getAllNameSpaces() {
        Vector allNameSpacesVect = new Vector();
        if (this.m_oValue instanceof PropertyHolder) {
            PropertyHolder propHolder = (PropertyHolder)this.m_oValue;
            Vector subNameSpaceVect = propHolder.getAllNameSpaces();
            int i = 0;
            while (i < subNameSpaceVect.size()) {
                allNameSpacesVect.add(subNameSpaceVect.elementAt(i));
                ++i;
            }
        } else if (this.m_oValue instanceof Vector) {
            Vector propertyVector = (Vector)this.m_oValue;
            int i = 0;
            while (i < propertyVector.size()) {
                PropertyHolder propertyHolder = (PropertyHolder)propertyVector.elementAt(i);
                Vector subNameSpaceVect = propertyHolder.getAllNameSpaces();
                int j = 0;
                while (j < subNameSpaceVect.size()) {
                    allNameSpacesVect.add(subNameSpaceVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        allNameSpacesVect.add(this.getNameSpace());
        if (this.getWebDavDataType() != null) {
            allNameSpacesVect.add(this.getWebDavDataType().getNameSpace());
        }
        return allNameSpacesVect;
    }

    public NameSpace getNameSpace() {
        return this.m_oWebDavField.getNameSpace();
    }

    public String getActualNameSpaceWithProperty() {
        return this.m_oWebDavField.getActualNameSpaceWithProperty();
    }

    public Element getAsElement(Document document) {
        Element rootElement = document.createElement(this.m_oWebDavField + "");
        if (this.m_oValue != null) {
            if (this.m_oValue instanceof PropertyHolder) {
                rootElement.appendChild(((PropertyHolder)this.m_oValue).getAsElement(document));
            } else if (this.m_oValue instanceof Vector) {
                Vector propertyVector = (Vector)this.m_oValue;
                int i = 0;
                while (i < propertyVector.size()) {
                    PropertyHolder propHolder = (PropertyHolder)propertyVector.elementAt(i);
                    rootElement.appendChild(propHolder.getAsElement(document));
                    ++i;
                }
            } else {
                String value = this.m_oValue.toString();
                rootElement.appendChild(document.createTextNode(value));
            }
        }
        if (this.getWebDavDataType() != null) {
            rootElement.setAttribute(this.getWebDavDataType().getNameSpace().getDataTypeString(), this.getWebDavDataType().getPropertyName());
        }
        return rootElement;
    }

    public WebDavDataType getWebDavDataType() {
        return this.m_oWebDavField.getDataType();
    }

    public WebDavField getWebDavField() {
        return this.m_oWebDavField;
    }

    public String toString(Document document) {
        return XMLUtilities.getPCData(this.getAsElement(document));
    }
}

