/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import HTTPClient.HTTPResponse;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavMapiFieldHelper;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExWebDavPimMessageItemsCache {
    private ExWebDavPimSession m_oPimSession;
    private ExWebDavPimRequestResponse m_oCountReqRes;
    private ExWebDavPimRequestResponse m_oAllItemsReqRes;
    private String m_szXmlResponse;
    private Document m_oDocument;
    private boolean m_bCanItBeLoaded;
    private int m_iPageSize = -1;
    private HashMap m_oElementMap;
    private int m_iCurrentLowerLimit = -1;
    private int m_iCurrentUpperLimit = -1;

    public ExWebDavPimMessageItemsCache(ExWebDavPimSession pimSession) {
        this.m_oPimSession = pimSession;
        this.m_oElementMap = new HashMap();
    }

    public void setCountReqRes(ExWebDavPimRequestResponse reqres) {
        this.m_oCountReqRes = reqres;
    }

    public ExWebDavPimSession getPimSession() {
        return this.m_oPimSession;
    }

    public void setAllItemsReqRes(ExWebDavPimRequestResponse reqres) {
        this.m_oAllItemsReqRes = reqres;
        this.m_bCanItBeLoaded = true;
    }

    public int getNumOfElements() throws ExWebDavPimException {
        if (this.m_iPageSize == -1) {
            if (!this.m_bCanItBeLoaded) {
                return -1;
            }
            this.load();
            return XMLUtilities.getNumOfElements(this.m_oDocument, WebDavField.RESPONSE);
        }
        return -1;
    }

    public void setPageSize(int iBatchSize) {
        this.m_iPageSize = iBatchSize;
    }

    public String loadData(int lowerRange, int upperRange) throws ExWebDavPimException {
        try {
            if (this.m_bCanItBeLoaded) {
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestWithRange(this.m_oAllItemsReqRes.getRequestMethod(), this.m_oAllItemsReqRes.getRequestFolder(), this.m_oAllItemsReqRes.getRequestXml(), lowerRange, upperRange);
                String str = response.getHeader("Content-Type");
                String szXmlResponse = null;
                if (str != null && str.indexOf("charset") == -1) {
                    byte[] b = response.getData();
                    szXmlResponse = new String(b, "UTF-8");
                } else {
                    szXmlResponse = response.getText();
                }
                szXmlResponse = this.replaceMapiFields(szXmlResponse);
                return szXmlResponse;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void load() throws ExWebDavPimException {
        try {
            if (this.m_bCanItBeLoaded && (this.m_szXmlResponse == null || this.m_oDocument == null)) {
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest(this.m_oAllItemsReqRes.getRequestMethod(), this.m_oAllItemsReqRes.getRequestFolder(), this.m_oAllItemsReqRes.getRequestXml());
                String str = response.getHeader("Content-Type");
                if (str != null && str.indexOf("charset") == -1) {
                    byte[] b = response.getData();
                    this.m_szXmlResponse = new String(b, "UTF-8");
                } else {
                    this.m_szXmlResponse = response.getText();
                }
                this.m_szXmlResponse = this.replaceMapiFields(this.m_szXmlResponse);
                this.m_oDocument = DocumentFactory.openStringAsDom(this.m_szXmlResponse);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private String replaceMapiFields(String response) {
        response = this.replaceMapiField(WebDavField.MAPI_RESPONSESTATUS, response);
        response = this.replaceMapiField(WebDavField.MAPI_APPOINTMENTSTATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_STATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_PERCENTAGE_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_TEAM_TASK, response);
        response = this.replaceMapiField(WebDavField.TASK_START_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_END_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_DATE_COMPLETED, response);
        response = this.replaceMapiField(WebDavField.TASK_ACTUAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_TOTAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_STATE, response);
        response = this.replaceMapiField(WebDavField.TASK_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_OWNER, response);
        response = this.replaceMapiField(WebDavField.TASK_IS_RECURRING, response);
        return response;
    }

    private String replaceMapiField(WebDavField webDavField, String response) {
        String lookingValue = webDavField.getPropertyName();
        String replaceValue = WebDavMapiFieldHelper.getReplceValue(webDavField);
        if (response.indexOf(lookingValue) != -1) {
            response = StringUtility.replace(response, lookingValue, replaceValue);
        }
        return response;
    }

    public Element getElement(int itemNumber) throws ExWebDavPimException {
        if (this.m_iPageSize == -1) {
            try {
                this.load();
                return XMLUtilities.getValueAsElement(this.m_oDocument, WebDavField.RESPONSE, itemNumber);
            }
            catch (Exception e) {
                throw new ExWebDavPimException(e);
            }
        }
        try {
            int actualItemNumber = itemNumber;
            if (actualItemNumber < 0) {
                return null;
            }
            int upperRange = -1;
            int lowerRange = -1;
            if (actualItemNumber >= this.m_iCurrentLowerLimit && actualItemNumber <= this.m_iCurrentUpperLimit) {
                Element element = (Element)this.m_oElementMap.get(new Integer(actualItemNumber));
                return element;
            }
            if (this.m_iCurrentLowerLimit == -1 && this.m_iCurrentUpperLimit == -1) {
                lowerRange = actualItemNumber;
                upperRange = lowerRange + this.m_iPageSize;
            } else if (actualItemNumber < this.m_iCurrentLowerLimit) {
                upperRange = actualItemNumber;
                lowerRange = upperRange - this.m_iPageSize;
                if (lowerRange < 0) {
                    lowerRange = 0;
                }
            } else if (actualItemNumber > this.m_iCurrentUpperLimit) {
                lowerRange = actualItemNumber;
                upperRange = actualItemNumber + this.m_iPageSize;
            }
            try {
                this.m_oElementMap = new HashMap();
                String szXmlResponse = this.loadData(lowerRange, upperRange);
                if (szXmlResponse.indexOf("<HTML>") != -1 && szXmlResponse.indexOf("<HEAD>") != -1 && szXmlResponse.indexOf("<META") != -1) {
                    return null;
                }
                Document oDocument = DocumentFactory.openStringAsDom(szXmlResponse);
                int numOfElements = XMLUtilities.getNumOfElements(oDocument, WebDavField.RESPONSE);
                int iItemNum = 0;
                while (iItemNum < numOfElements) {
                    Element element = XMLUtilities.getValueAsElement(oDocument, WebDavField.RESPONSE, iItemNum);
                    int actualElementNumber = lowerRange + iItemNum;
                    this.m_oElementMap.put(new Integer(actualElementNumber), element);
                    ++iItemNum;
                }
                this.m_iCurrentLowerLimit = lowerRange;
                this.m_iCurrentUpperLimit = upperRange;
            }
            catch (Exception e) {
                return null;
            }
            return this.getElement(itemNumber);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

