/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.exchangewebdav.ExWebDavPimDummyAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;

public class ExWebDavPimAddressEntryItemFinder {
    public static PimAddressEntryItem searchFromABWithEmailAddress(String emailAddress, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        return ExWebDavPimAddressEntryItemFinder.searchFromGABWithEmailAddress(emailAddress, pimSession);
    }

    public static PimAddressEntryItem searchFromGABWithEmailAddress(String emailAddress, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            if (emailAddress == null) {
                return null;
            }
            PimAddressBook pimAddressBook = pimSession.getGlobalAddressBook(null);
            if (pimAddressBook == null) {
                return new ExWebDavPimDummyAddressEntryItem(null, emailAddress);
            }
            PimAddressEntryItems pimAddressEntryItems = pimAddressBook.getAddressEntryItems();
            PimAddressEntryItemFilter pimAddressEntryItemFilter = pimAddressEntryItems.getAddressEntryItemFilter();
            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.OPEN);
            pimAddressEntryItemFilter.setEmailAddress(emailAddress);
            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.CLOSE);
            PimAddressEntryItem pimFinalAddressEntryItem = null;
            pimFinalAddressEntryItem = pimAddressEntryItems.getFirstAddressEntryItem();
            while (pimFinalAddressEntryItem != null) {
                String retrievedEmail = pimFinalAddressEntryItem.getEmailAddress();
                if (retrievedEmail.equals(emailAddress)) break;
                pimFinalAddressEntryItem = pimAddressEntryItems.getNextAddressEntryItem();
            }
            if (pimFinalAddressEntryItem == null) {
                return new ExWebDavPimDummyAddressEntryItem(null, emailAddress);
            }
            return pimFinalAddressEntryItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static PimAddressEntryItem searchFromABWithName(String szName, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        return ExWebDavPimAddressEntryItemFinder.searchFromGABWithName(szName, pimSession);
    }

    private static PimAddressEntryItem searchFromGABWithName(String szName, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            if (szName == null) {
                return null;
            }
            PimAddressBook pimAddressBook = pimSession.getGlobalAddressBook(null);
            if (pimAddressBook == null) {
                return new ExWebDavPimDummyAddressEntryItem(szName, null);
            }
            PimAddressEntryItems pimAddressEntryItems = pimAddressBook.getAddressEntryItems();
            PimAddressEntryItemFilter pimAddressEntryItemFilter = pimAddressEntryItems.getAddressEntryItemFilter();
            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.OPEN);
            pimAddressEntryItemFilter.setName(szName);
            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.CLOSE);
            PimAddressEntryItem pimFinalAddressEntryItem = null;
            pimFinalAddressEntryItem = pimAddressEntryItems.getFirstAddressEntryItem();
            while (pimFinalAddressEntryItem != null) {
                String retrievedName = pimFinalAddressEntryItem.getName();
                if (retrievedName.equals(szName)) break;
                pimFinalAddressEntryItem = pimAddressEntryItems.getNextAddressEntryItem();
            }
            if (pimFinalAddressEntryItem == null) {
                return new ExWebDavPimDummyAddressEntryItem(szName, null);
            }
            return pimFinalAddressEntryItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

