/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import java.net.URL;

public class ExWebDavHttpConnector {
    private HTTPConnection m_oHttpConnection;
    private ExWebDavPimSession m_oPimSession;
    private int m_iNumOfLoginTriesLimit = 3;
    private int m_iNumOfLoginTries = 0;
    private String EXTENSION_METHOD = "Extension";
    private String EXTENSION_METHOD_WITH_RANGE = "ExtensionRange";
    private String GET_IE = "Get_IE";
    private String GET_NS = "Get_NS";
    private String POST = "Post";
    private String DELETE = "Delete";
    private String HEAD = "Head";
    private String MOVE = "MOVE";
    private String PUT = "PUT";
    private String MIME_REQUEST = "MIME_REQUEST";
    private String m_szUrlForSafeway;
    private String m_szMailbox;
    private String m_szUserName;
    private String m_szPassword;
    private String m_szProxyPort;
    private String m_szProxyHost;

    public void logon() throws ExWebDavPimException {
        this.logon(this.m_oPimSession);
    }

    public synchronized HTTPResponse callServer(ParameterBean parameter) throws ExWebDavPimException {
        HTTPResponse response = null;
        try {
            String methodToInvoke = parameter.getInvokeMethod();
            if (methodToInvoke.equals(this.EXTENSION_METHOD_WITH_RANGE)) {
                try {
                    String szBody = parameter.getBody();
                    String szMethod = parameter.getMethod();
                    String szFilePath = parameter.getFilePath();
                    String szRange = parameter.getRange();
                    NVPair[] headers = new NVPair[]{new NVPair("Depth", "0"), new NVPair("Content-type", "text/xml; charset=utf-8"), new NVPair("Content-length", szBody.length() + ""), new NVPair("Range", szRange)};
                    response = this.getConnection().ExtensionMethod(szMethod, szFilePath, szBody.getBytes(), headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.EXTENSION_METHOD)) {
                try {
                    String szBody = parameter.getBody();
                    String szMethod = parameter.getMethod();
                    String szFilePath = parameter.getFilePath();
                    NVPair[] headers = new NVPair[]{new NVPair("Depth", "0"), new NVPair("Content-type", "text/xml; charset=utf-8"), new NVPair("Content-length", szBody.length() + "")};
                    response = this.getConnection().ExtensionMethod(szMethod, szFilePath, szBody.getBytes(), headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.MOVE)) {
                try {
                    String szBody = parameter.getBody();
                    String szFilePath = parameter.getFilePath();
                    String szDestinationPath = parameter.getDestinationPath();
                    NVPair[] headers = new NVPair[]{new NVPair("Depth", "0"), new NVPair("Destination", szDestinationPath), new NVPair("Overwrite", "F"), new NVPair("Content-length", szBody.length() + "")};
                    response = this.getConnection().ExtensionMethod("MOVE", szFilePath, szBody.getBytes(), headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.PUT)) {
                try {
                    String szBody = parameter.getBody();
                    String szFilePath = parameter.getFilePath();
                    NVPair[] headers = new NVPair[]{new NVPair("Depth", "0"), new NVPair("Content-type", "message/rfc822"), new NVPair("Content-length", szBody.length() + "")};
                    response = this.getConnection().ExtensionMethod("PUT", szFilePath, szBody.getBytes(), headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.GET_IE)) {
                try {
                    String url = parameter.getUrl();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0;)")};
                    response = this.getConnection().Get(url, (NVPair[])null, headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.POST)) {
                try {
                    String szUrl = parameter.getUrl();
                    NVPair[] oNVPairBody = parameter.getNVPairBody();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0;)")};
                    response = this.getConnection().Post(szUrl, oNVPairBody, headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.GET_NS)) {
                try {
                    String url = parameter.getUrl();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.5")};
                    response = this.getConnection().Get(url, (NVPair[])null, headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.DELETE)) {
                try {
                    String szFilePath = parameter.getFilePath();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.5")};
                    response = this.getConnection().Delete(szFilePath, headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.HEAD)) {
                try {
                    String szFilePath = parameter.getFilePath();
                    response = this.getConnection().Head(szFilePath);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            if (methodToInvoke.equals(this.MIME_REQUEST)) {
                try {
                    String url = parameter.getUrl();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.5"), new NVPair("Translate", "f")};
                    response = this.getConnection().Get(url, (NVPair[])null, headers);
                }
                catch (Exception e) {
                    return this.validateResponse(e, response, parameter);
                }
            }
            return this.validateResponse(null, response, parameter);
        }
        catch (Exception ex) {
            throw new ExWebDavPimException(ex);
        }
    }

    public HTTPResponse validateResponse(Exception e, HTTPResponse response, ParameterBean parameters) throws ExWebDavPimException {
        try {
            if (e != null) {
                if (this.m_iNumOfLoginTries < this.m_iNumOfLoginTriesLimit) {
                    ++this.m_iNumOfLoginTries;
                    this.logon();
                    return this.callServer(parameters);
                }
                this.m_iNumOfLoginTries = 0;
                throw new ExWebDavPimException(e);
            }
            if (response == null) {
                if (this.m_iNumOfLoginTries < this.m_iNumOfLoginTriesLimit) {
                    ++this.m_iNumOfLoginTries;
                    this.logon();
                    return this.callServer(parameters);
                }
                if (this.m_iNumOfLoginTries >= this.m_iNumOfLoginTriesLimit) {
                    this.m_iNumOfLoginTries = 0;
                    throw new ExWebDavPimException(0L);
                }
            } else if (response.getStatusCode() == 401) {
                if (this.m_iNumOfLoginTries < this.m_iNumOfLoginTriesLimit) {
                    ++this.m_iNumOfLoginTries;
                    this.logon();
                    return this.callServer(parameters);
                }
                if (this.m_iNumOfLoginTries >= this.m_iNumOfLoginTriesLimit) {
                    this.m_iNumOfLoginTries = 0;
                    throw new ExWebDavPimException(1L);
                }
            }
            return response;
        }
        catch (Exception ex) {
            throw new ExWebDavPimException(ex);
        }
    }

    public void logon(ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            String url = pimSession.getUserInfo().getUrl();
            String mailbox = pimSession.getUserInfo().getMailbox();
            String username = pimSession.getUserInfo().getUserName();
            String password = pimSession.getUserInfo().getPassword();
            String proxyHost = pimSession.getUserInfo().getProxyHost();
            String proxyPort = pimSession.getUserInfo().getProxyPort();
            this.m_oPimSession = pimSession;
            this.logon(url, mailbox, username, password, proxyPort, proxyHost);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(8L);
        }
    }

    public void logon(String url, String mailbox, String username, String password, String proxyPort, String proxyHost) throws Exception {
        String mailboxUrl = url + "/" + mailbox;
        URL finalUrl = new URL(mailboxUrl);
        this.m_oHttpConnection = new HTTPConnection(finalUrl.getProtocol(), finalUrl.getHost(), finalUrl.getPort());
        this.m_oHttpConnection.addBasicAuthorization(this.m_oHttpConnection.getHost(), username, password);
        this.m_oHttpConnection.setAllowUserInteraction(false);
        this.m_oHttpConnection.setTimeout(120000);
        try {
            if (proxyPort != null && proxyHost != null) {
                int port = Integer.parseInt(proxyPort);
                this.m_oHttpConnection.setCurrentProxy(proxyHost, port);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public HTTPConnection getConnection() {
        return this.m_oHttpConnection;
    }

    public HTTPResponse sendRequest(String szMethod, String szFilePath, String szBody) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.EXTENSION_METHOD;
            parameterBean.szMethod = szMethod;
            parameterBean.szFilePath = szFilePath;
            parameterBean.szBody = szBody;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse move(String szFilePath, String szDestinationPath) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.MOVE;
            parameterBean.szFilePath = szFilePath;
            parameterBean.szDestinationPath = szDestinationPath;
            parameterBean.szBody = "";
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse put(String szFilePath, String szBody) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.PUT;
            parameterBean.szFilePath = szFilePath;
            parameterBean.szBody = szBody;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendRequestReturnAsXml(String url) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.GET_IE;
            parameterBean.szUrl = url;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendRequestAsPostReturnAsXml(String href, NVPair[] body) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.POST;
            parameterBean.szUrl = href;
            parameterBean.oNVPairBody = body;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendRequest(String url) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.GET_NS;
            parameterBean.szUrl = url;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendMimeRequest(String url) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.MIME_REQUEST;
            parameterBean.szUrl = url;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendSearch(String szFilePath, String szBody) throws ExWebDavPimException {
        return this.sendRequest("SEARCH", szFilePath, szBody);
    }

    public HTTPResponse sendPropFind(String szFilePath, String szBody) throws ExWebDavPimException {
        return this.sendRequest("PROPFIND", szFilePath, szBody);
    }

    public String getUniqueFileName(String baseFolderName, String fileName) throws ExWebDavPimException {
        try {
            String baseFileName;
            int iAppend = 2;
            String newFileName = baseFileName = StringUtility.replaceSpecialCharacters(fileName, 'n');
            boolean uniqueNameNotYetFound = true;
            while (uniqueNameNotYetFound) {
                String entireFilePath = baseFolderName + "/" + newFileName + ".EML";
                ParameterBean parameterBean = new ParameterBean();
                parameterBean.szInvokeMethod = this.HEAD;
                parameterBean.szFilePath = entireFilePath;
                this.m_iNumOfLoginTries = 0;
                HTTPResponse response = this.callServer(parameterBean);
                if (response.getStatusCode() == 404) {
                    return entireFilePath;
                }
                newFileName = baseFileName + "_" + iAppend;
                ++iAppend;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse delete(String szFilePath) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.DELETE;
            parameterBean.szFilePath = szFilePath;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean doesFileExist(String filePath) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.HEAD;
            parameterBean.szFilePath = filePath;
            this.m_iNumOfLoginTries = 0;
            HTTPResponse response = this.callServer(parameterBean);
            return response.getStatusCode() != 404;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse deleteForSafeway(String szFilePath) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.DELETE;
            parameterBean.szFilePath = szFilePath;
            return this.callServerForSafeway(parameterBean, 0);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendRequestForSafeway(String szMethod, String szFilePath, String szBody) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.EXTENSION_METHOD;
            parameterBean.szMethod = szMethod;
            parameterBean.szFilePath = szFilePath;
            parameterBean.szBody = szBody;
            return this.callServerForSafeway(parameterBean, 0);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public HTTPResponse sendSearchForSafeway(String szFilePath, String szBody) throws ExWebDavPimException {
        return this.sendRequestForSafeway("SEARCH", szFilePath, szBody);
    }

    public HTTPResponse sendPropFindForSafeway(String szFilePath, String szBody) throws ExWebDavPimException {
        return this.sendRequestForSafeway("PROPFIND", szFilePath, szBody);
    }

    public HTTPResponse callServerForSafeway(ParameterBean parameter, int iCurrentNumOfTries) throws ExWebDavPimException {
        HTTPResponse response = null;
        try {
            String methodToInvoke = parameter.getInvokeMethod();
            if (methodToInvoke.equals(this.EXTENSION_METHOD)) {
                try {
                    String szBody = parameter.getBody();
                    String szMethod = parameter.getMethod();
                    String szFilePath = parameter.getFilePath();
                    NVPair[] headers = new NVPair[]{new NVPair("Depth", "0"), new NVPair("Content-type", "text/xml; charset=utf-8"), new NVPair("Content-length", szBody.length() + "")};
                    response = this.getConnection().ExtensionMethod(szMethod, szFilePath, szBody.getBytes(), headers);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            if (methodToInvoke.equals(this.GET_IE)) {
                try {
                    String url = parameter.getUrl();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0;)")};
                    response = this.getConnection().Get(url, (NVPair[])null, headers);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            if (methodToInvoke.equals(this.POST)) {
                try {
                    String szUrl = parameter.getUrl();
                    NVPair[] oNVPairBody = parameter.getNVPairBody();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0;)")};
                    response = this.getConnection().Post(szUrl, oNVPairBody, headers);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            if (methodToInvoke.equals(this.GET_NS)) {
                try {
                    String url = parameter.getUrl();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.5")};
                    response = this.getConnection().Get(url, (NVPair[])null, headers);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            if (methodToInvoke.equals(this.DELETE)) {
                try {
                    String szFilePath = parameter.getFilePath();
                    NVPair[] headers = new NVPair[]{new NVPair("User-Agent", "Mozilla/4.5")};
                    response = this.getConnection().Delete(szFilePath, headers);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            if (methodToInvoke.equals(this.HEAD)) {
                try {
                    String szFilePath = parameter.getFilePath();
                    response = this.getConnection().Head(szFilePath);
                }
                catch (Exception e) {
                    return this.validateResponseForSafeway(e, response, parameter, iCurrentNumOfTries);
                }
            }
            return this.validateResponseForSafeway(null, response, parameter, iCurrentNumOfTries);
        }
        catch (Exception ex) {
            throw new ExWebDavPimException(ex);
        }
    }

    public HTTPResponse validateResponseForSafeway(Exception e, HTTPResponse response, ParameterBean parameters, int iCurrentNumOfTries) throws ExWebDavPimException {
        try {
            if (e != null) {
                if (iCurrentNumOfTries < this.m_iNumOfLoginTriesLimit) {
                    this.logonForSafeway();
                    return this.callServerForSafeway(parameters, ++iCurrentNumOfTries);
                }
                iCurrentNumOfTries = 0;
                throw new ExWebDavPimException(e);
            }
            if (response == null) {
                if (iCurrentNumOfTries < this.m_iNumOfLoginTriesLimit) {
                    this.logonForSafeway();
                    return this.callServerForSafeway(parameters, ++iCurrentNumOfTries);
                }
                if (iCurrentNumOfTries >= this.m_iNumOfLoginTriesLimit) {
                    iCurrentNumOfTries = 0;
                    throw new ExWebDavPimException(0L);
                }
            } else if (response.getStatusCode() == 401) {
                if (iCurrentNumOfTries < this.m_iNumOfLoginTriesLimit) {
                    this.logonForSafeway();
                    return this.callServerForSafeway(parameters, ++iCurrentNumOfTries);
                }
                if (iCurrentNumOfTries >= this.m_iNumOfLoginTriesLimit) {
                    iCurrentNumOfTries = 0;
                    throw new ExWebDavPimException(1L);
                }
            }
            return response;
        }
        catch (Exception ex) {
            throw new ExWebDavPimException(ex);
        }
    }

    public void logonForSafeway() throws ExWebDavPimException {
        try {
            String mailboxUrl = this.m_szUrlForSafeway + "/" + this.m_szMailbox;
            URL finalUrl = new URL(mailboxUrl);
            this.m_oHttpConnection = new HTTPConnection(finalUrl.getProtocol(), finalUrl.getHost(), finalUrl.getPort());
            this.m_oHttpConnection.addBasicAuthorization(this.m_oHttpConnection.getHost(), this.m_szUserName, this.m_szPassword);
            this.m_oHttpConnection.setAllowUserInteraction(false);
            this.m_oHttpConnection.setTimeout(120000);
            try {
                if (this.m_szProxyPort != null && this.m_szProxyHost != null) {
                    int port = Integer.parseInt(this.m_szProxyPort);
                    this.m_oHttpConnection.setCurrentProxy(this.m_szProxyHost, port);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void logonForSafeway(String url, String mailbox, String username, String password, String proxyPort, String proxyHost) throws Exception {
        this.m_szUrlForSafeway = url;
        this.m_szMailbox = mailbox;
        this.m_szUserName = username;
        this.m_szPassword = password;
        this.m_szProxyHost = proxyHost;
        this.m_szProxyPort = proxyPort;
        this.logonForSafeway();
    }

    public HTTPResponse sendRequestWithRange(String szMethod, String szFilePath, String szBody, int lowerRange, int upperRange) throws ExWebDavPimException {
        try {
            ParameterBean parameterBean = new ParameterBean();
            parameterBean.szInvokeMethod = this.EXTENSION_METHOD_WITH_RANGE;
            parameterBean.szMethod = szMethod;
            parameterBean.szFilePath = szFilePath;
            parameterBean.szBody = szBody;
            parameterBean.szRange = "rows=" + lowerRange + "-" + upperRange;
            this.m_iNumOfLoginTries = 0;
            return this.callServer(parameterBean);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private class ParameterBean {
        public String szInvokeMethod = "";
        public String szBody = "";
        public String szMethod = "";
        public String szFilePath = "";
        public String szDestinationPath = "";
        public String szUrl = "";
        public NVPair[] oNVPairBody;
        public String szRange = "";

        private ParameterBean() {
        }

        public String getInvokeMethod() {
            return this.szInvokeMethod;
        }

        public String getBody() {
            return this.szBody;
        }

        public String getMethod() {
            return this.szMethod;
        }

        public String getFilePath() {
            return this.szFilePath;
        }

        public String getDestinationPath() {
            return this.szDestinationPath;
        }

        public String getUrl() {
            return this.szUrl;
        }

        public NVPair[] getNVPairBody() {
            return this.oNVPairBody;
        }

        public String getRange() {
            return this.szRange;
        }
    }
}

