/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewTaskItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldTaskItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.ExWebDavPimTask;
import com.aligo.pim.exchangewebdav.ExWebDavPimTaskItemFilter;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTaskItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavMapiFieldHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.interfaces.PimTaskItemFilter;
import com.aligo.pim.interfaces.PimTaskItems;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimTaskItems
extends ExWebDavPimMessageItems
implements PimTaskItems {
    private ExWebDavPimTaskItemFilter m_oPimTaskItemFilter;
    private ExWebDavPimTask m_oPimTask;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private boolean m_bIsInitializeCalled = false;
    private boolean m_bIsTaskItemFilterCalled = false;
    private boolean m_bIsSpecialTaskFilter = false;

    public ExWebDavPimTaskItems(ExWebDavPimTask pimTask, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimTask = pimTask;
        this.m_oPimTaskItemFilter = new ExWebDavPimTaskItemFilter(this.getPimSession());
        this.m_bIsSpecialTaskFilter = pimSession.getUserInfo().getTaskSpecialFilter();
    }

    public PimTaskItemFilter getTaskItemFilter() throws ExWebDavPimException {
        try {
            this.m_bIsTaskItemFilterCalled = true;
            return this.m_oPimTaskItemFilter;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimTask getPimTask() {
        return this.m_oPimTask;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimTask().getFolderName();
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            String whereString = this.m_oPimTaskItemFilter.getWhereString();
            String orderByString = this.m_oPimTaskItemFilter.getOrderByString();
            Vector fieldsVector = ExWebDavPimTaskItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, orderByString, this.m_oPimSortType);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws PimException {
        try {
            int cacheCount;
            if (this.m_bIsTaskItemFilterCalled && !this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if (this.m_bIsTaskItemFilterCalled) {
                this.getCache().setPageSize(-1);
            }
            if ((cacheCount = this.getCache().getNumOfElements()) != -1) {
                return cacheCount;
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimTaskItem getFirstTaskItem() throws ExWebDavPimException {
        try {
            return this.getTaskItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskItem getNextTaskItem() throws ExWebDavPimException {
        try {
            return this.getTaskItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskItem getLastTaskItem() throws ExWebDavPimException {
        try {
            return this.getTaskItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskItem getPreviousTaskItem() throws ExWebDavPimException {
        try {
            return this.getTaskItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskItem getTaskItem(int itemNumber) throws ExWebDavPimException {
        block22: {
            try {
                Element element;
                if (!this.m_bIsInitializeCalled) {
                    this.initializeCache();
                }
                if ((element = this.getCache().getElement(itemNumber)) == null) {
                    return null;
                }
                ExWebDavPimOldTaskItem pimOldTaskItem = new ExWebDavPimOldTaskItem(this.getPimSession(), this.getPimTask(), element);
                if (this.m_bIsSpecialTaskFilter) {
                    if (this.m_bIsTaskItemFilterCalled) {
                        Date filterStartDate = this.m_oPimTaskItemFilter.getSpecialStartDate();
                        Date filterDueDate = this.m_oPimTaskItemFilter.getSpecialDueDate();
                        String filterSubject = this.m_oPimTaskItemFilter.getSpecialSubject();
                        Date actualDueDate = pimOldTaskItem.getDueDate();
                        String actualSubject = pimOldTaskItem.getSubject();
                        boolean bFilterStartDateSatisfied = false;
                        boolean bFilterDueDateSatisfied = false;
                        boolean bFilterSubjectSatisfied = false;
                        if (filterSubject != null) {
                            if (actualSubject == null) {
                                bFilterSubjectSatisfied = false;
                            } else if (actualSubject.indexOf(filterSubject) != -1) {
                                bFilterSubjectSatisfied = true;
                            }
                        } else {
                            bFilterSubjectSatisfied = true;
                        }
                        if (filterStartDate != null) {
                            if (actualDueDate == null) {
                                bFilterStartDateSatisfied = true;
                            } else if (actualDueDate.after(filterStartDate)) {
                                bFilterStartDateSatisfied = true;
                            }
                        } else {
                            bFilterStartDateSatisfied = true;
                        }
                        if (filterDueDate != null) {
                            if (actualDueDate == null) {
                                bFilterDueDateSatisfied = true;
                            } else if (filterDueDate.after(actualDueDate)) {
                                bFilterDueDateSatisfied = true;
                            }
                        } else {
                            bFilterDueDateSatisfied = true;
                        }
                        if (bFilterStartDateSatisfied && bFilterDueDateSatisfied && bFilterSubjectSatisfied) {
                            return pimOldTaskItem;
                        }
                        return this.getNextTaskItem();
                    }
                    break block22;
                }
                return pimOldTaskItem;
            }
            catch (Exception e) {
                throw new ExWebDavPimException(e);
            }
        }
        return null;
    }

    public PimTaskItem getTaskItem(String id) throws ExWebDavPimException {
        try {
            if (id == null) {
                return null;
            }
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            ExWebDavPimTaskItemFilter uidFilter = new ExWebDavPimTaskItemFilter(this.getPimSession());
            uidFilter.setID(id);
            String whereString = uidFilter.getWhereString();
            String orderByString = uidFilter.getOrderByString();
            Vector fieldsVector = ExWebDavPimTaskItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, orderByString, this.m_oPimSortType);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
            String text = StringUtility.getTextAfterEncoding(response);
            text = this.replaceMapiFields(text);
            int numOfElements = XMLUtilities.getNumOfElements(text, WebDavField.RESPONSE);
            Element element = null;
            int i2 = 0;
            while (i2 < numOfElements) {
                String retrievedId;
                element = XMLUtilities.getValueAsElement(text, WebDavField.RESPONSE, i2);
                if (element != null && (retrievedId = XMLUtilities.getValue(element, WebDavField.UID)).equals(id)) break;
                ++i2;
            }
            if (element == null) {
                return null;
            }
            ExWebDavPimOldTaskItem pimOldTaskItem = new ExWebDavPimOldTaskItem(this.getPimSession(), this.getPimTask(), element);
            return pimOldTaskItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskItem addTaskItem() throws ExWebDavPimException {
        try {
            return new ExWebDavPimNewTaskItem(this.getPimSession(), this.getPimTask());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void sort(PimSortType pimSortType) throws PimException {
        try {
            if (pimSortType != null) {
                this.m_oPimSortType = pimSortType;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws PimException {
        return this.getTaskItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getTaskItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getTaskItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstTaskItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextTaskItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastTaskItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousTaskItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addTaskItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public void delete() throws PimException {
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    private String replaceMapiFields(String response) {
        response = this.replaceMapiField(WebDavField.MAPI_RESPONSESTATUS, response);
        response = this.replaceMapiField(WebDavField.MAPI_APPOINTMENTSTATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_STATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_PERCENTAGE_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_TEAM_TASK, response);
        response = this.replaceMapiField(WebDavField.TASK_START_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_END_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_DATE_COMPLETED, response);
        response = this.replaceMapiField(WebDavField.TASK_ACTUAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_TOTAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_STATE, response);
        response = this.replaceMapiField(WebDavField.TASK_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_OWNER, response);
        response = this.replaceMapiField(WebDavField.TASK_IS_RECURRING, response);
        return response;
    }

    private String replaceMapiField(WebDavField webDavField, String response) {
        String lookingValue = webDavField.getPropertyName();
        String replaceValue = WebDavMapiFieldHelper.getReplceValue(webDavField);
        if (response.indexOf(lookingValue) != -1) {
            response = StringUtility.replace(response, lookingValue, replaceValue);
        }
        return response;
    }
}

