/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimTaskItemFilter;
import java.util.Date;

public class ExWebDavPimTaskItemFilter
extends ExWebDavPimMessageItemFilter
implements PimTaskItemFilter {
    private ExWebDavPimSession m_oPimSession;
    private Date m_oDueDate;
    private Date m_oStartDate;
    private String m_szSubject;

    public ExWebDavPimTaskItemFilter(ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            super.setOperand(PimFilterOperandType.OPEN);
            this.getFilterCriteria().add(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Task");
            super.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().add(WebDavField.CONTENTCLASS, ExWebDavPimFilterParam.EQUAL, "urn:content-classes:task");
            super.setOperand(PimFilterOperandType.CLOSE);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        return null;
    }

    public void setOperand(PimFilterOperandType pimFilterOperandType) throws ExWebDavPimException {
        if (!this.m_oPimSession.getUserInfo().getTaskSpecialFilter()) {
            super.setOperand(pimFilterOperandType);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        if (subject != null) {
            if (this.m_oPimSession.getUserInfo().getTaskSpecialFilter()) {
                this.setSpecialSubject(subject);
            } else {
                this.getFilterCriteria().addWithoutOrderBy(WebDavField.SUBJECT, ExWebDavPimFilterParam.LIKE, subject);
            }
        }
    }

    private void setSpecialSubject(String subject) {
        this.m_szSubject = subject;
    }

    public String getSpecialSubject() {
        return this.m_szSubject;
    }

    public void setID(String uid) throws ExWebDavPimException {
        if (uid != null) {
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.UID, ExWebDavPimFilterParam.LIKE, uid);
        }
    }

    public void setStartDate(Date startDate) throws PimException {
        if (startDate != null) {
            if (this.m_oPimSession.getUserInfo().getTaskSpecialFilter()) {
                this.setSpecialStartDate(startDate);
            } else {
                WebDavDate webDavDate = new WebDavDate(startDate);
                this.getFilterCriteria().addWithoutOrderBy(WebDavField.TASK_START_DATE, ExWebDavPimFilterParam.GREATERTHAN, webDavDate.getWebDavDateFormat());
            }
        }
    }

    private void setSpecialStartDate(Date startDate) {
        this.m_oStartDate = startDate;
    }

    public Date getSpecialStartDate() {
        return this.m_oStartDate;
    }

    public void setDueDate(Date dueDate) throws PimException {
        if (dueDate != null) {
            if (this.m_oPimSession.getUserInfo().getTaskSpecialFilter()) {
                this.setSpecialDueDate(dueDate);
            } else {
                WebDavDate webDavDate = new WebDavDate(dueDate);
                this.getFilterCriteria().addWithoutOrderBy(WebDavField.TASK_END_DATE, ExWebDavPimFilterParam.LESSTHAN, webDavDate.getWebDavDateFormat());
            }
        }
    }

    private void setSpecialDueDate(Date dueDate) {
        this.m_oDueDate = dueDate;
    }

    public Date getSpecialDueDate() {
        return this.m_oDueDate;
    }

    public void setDisplayName(String fileName) {
        if (fileName != null) {
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.DISPLAYNAME, ExWebDavPimFilterParam.LIKE, fileName);
        }
    }
}

