/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimServerType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimCalendar;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimInbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimOutbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimTask;
import com.aligo.pim.exchangewebdav.ExWebDavPimUserInfo;
import com.aligo.pim.exchangewebdav.util.ExWebDavHttpConnector;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFolderType;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTimeZoneGMTTypeMapper;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimSession;
import com.aligo.pim.interfaces.PimUserInfo;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExWebDavPimSession
implements PimSession {
    private ExWebDavPimUserInfo m_oPimUserInfo;
    private ExWebDavHttpConnector m_oHttpConnector;
    private PimTimeZoneType m_oPimTimeZoneType = ExWebDavPimTimeZoneGMTTypeMapper.getType(TimeZone.getDefault().getDisplayName(true, 0));
    private boolean isItLdapConnection = false;
    private PimAddressBook m_oLdapPimAddressBook;
    private ExWebDavPimFolderType m_oPimFolderType;
    private boolean m_bWasTimeZoneTypeSet = false;
    private PimAddressEntryItem m_oPimAddressEntryItem;
    private long m_lPreviousTimeLdapConnectionTestWasMade = 0L;

    public ExWebDavPimSession(ExWebDavPimUserInfo pimUserInfo) {
        this.m_oPimUserInfo = pimUserInfo.getClone();
    }

    public ExWebDavPimFolderType getPimFolderType() throws ExWebDavPimException {
        return this.m_oPimFolderType;
    }

    public void logon() throws ExWebDavPimException {
        this.m_oPimFolderType = new ExWebDavPimFolderType();
        this.m_oHttpConnector = new ExWebDavHttpConnector();
        this.m_oHttpConnector.logon(this);
        if (ExWebDavPimUserInfo.DEBUG) {
            System.out.println("Logged into webdav connection");
        }
        this.getRootFolder();
        String jndiServer = this.m_oPimUserInfo.getJndiLdapServer();
        if (jndiServer == null) {
            throw new ExWebDavPimException(6L);
        }
        this.m_oLdapPimAddressBook = this.getLdapAddressBook();
        this.isItLdapConnection = true;
    }

    public void setTimeZone(PimTimeZoneType pimTimeZone) {
        this.m_oPimTimeZoneType = pimTimeZone;
        this.m_bWasTimeZoneTypeSet = true;
    }

    public PimTimeZoneType getTimeZone() {
        return this.m_oPimTimeZoneType;
    }

    public ExWebDavHttpConnector getHttpConnector() {
        return this.m_oHttpConnector;
    }

    public void getRootFolder() throws ExWebDavPimException {
        try {
            Document document = DocumentFactory.createDOMDocument();
            Element rootElement = document.createElement("DAV:propfind");
            rootElement.setAttribute("xmlns:rootfolder", "urn:schemas:httpmail:");
            rootElement.setAttribute("xmlns:DAV", "DAV:");
            Element propElement = document.createElement("DAV:prop");
            Element mailboxElement = document.createElement("rootfolder:msgfolderroot");
            propElement.appendChild(mailboxElement);
            rootElement.appendChild(propElement);
            String xmlstring = XMLUtilities.toXMLStringNS(rootElement);
            HTTPResponse response = this.m_oHttpConnector.sendRequest("PROPFIND", "/exchange/" + this.m_oPimUserInfo.getMailbox(), xmlstring);
            if (XMLUtilities.getValue(response.getText(), "urn:schemas:httpmail:", "msgfolderroot") == "") {
                throw new ExWebDavPimException(46L);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getRootFolderName() {
        return ExWebDavPimFolderType.ROOT_FOLDER.toString();
    }

    public String getPublicRootFolderName() {
        return ExWebDavPimFolderType.PUBLIC_ROOT_FOLDER.toString();
    }

    public ExWebDavPimUserInfo getUserInfo() {
        return this.m_oPimUserInfo;
    }

    public String getUserMailbox() {
        return this.getUserInfo().getMailbox();
    }

    public ExWebDavPimPersonalAddressBook getContact(String user) throws ExWebDavPimException {
        try {
            if (user == null) {
                user = this.getUserMailbox();
            }
            return new ExWebDavPimPersonalAddressBook(this, this.getPimFolderType().getContactsFullName(this), this.getPimFolderType().getContactsDisplayName(this));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimCalendar getCalendar(String user) throws ExWebDavPimException {
        try {
            if (user == null) {
                user = this.getUserMailbox();
            }
            return new ExWebDavPimCalendar(this, this.getPimFolderType().getCalendarFullName(this), this.getPimFolderType().getCalendarDisplayName(this));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimInbox getInbox(String user) throws ExWebDavPimException {
        try {
            if (user == null) {
                user = this.getUserMailbox();
            }
            return new ExWebDavPimInbox(this, this.getPimFolderType().getInboxFullName(this), this.getPimFolderType().getInboxDisplayName(this));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimOutbox getOutbox(String user) throws ExWebDavPimException {
        try {
            if (user == null) {
                user = this.getUserMailbox();
            }
            return new ExWebDavPimOutbox(this, this.getPimFolderType().getInboxFullName(this), this.getPimFolderType().getInboxDisplayName(this));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressBook getLdapAddressBook() throws ExWebDavPimException {
        try {
            PimContainer pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.JNDI);
            PimUserInfo pimUserInfo = pimContainer.addUserInfo();
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_SERVER, this.m_oPimUserInfo.getJndiLdapServer());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_USERNAME, this.m_oPimUserInfo.getJndiLdapUserName());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PASSWORD, this.m_oPimUserInfo.getJndiLdapPassword());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PORT, this.m_oPimUserInfo.getJndiLdapPort());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_AB_BASE, this.m_oPimUserInfo.getJndiLdapABBaseDn());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_TRY_ANONYMOUS_FALLBACK, "false");
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_SERVER_TYPE, (Object)PimServerType.EXCHANGE);
            pimUserInfo.set(PimUserInfoParameter.DEBUG, new Boolean(ExWebDavPimUserInfo.DEBUG).toString());
            pimContainer.logon();
            this.m_oPimAddressEntryItem = pimContainer.getCurrentUser();
            if (ExWebDavPimUserInfo.DEBUG) {
                System.out.println("Logged into LDAP with JNDI");
            }
            return (PimAddressBook)pimContainer.getFolder(PimFolderType.GLOBAL_ADDRESS_BOOK);
        }
        catch (PimException e) {
            long code = e.getCode();
            throw new ExWebDavPimException(code);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressBook getGlobalAddressBook(String user) throws ExWebDavPimException {
        try {
            if (this.isItLdapConnection) {
                if (this.m_oLdapPimAddressBook == null) {
                    this.m_oLdapPimAddressBook = this.getLdapAddressBook();
                } else {
                    long timeNow = new Date().getTime();
                    long timeDiff = timeNow - this.m_lPreviousTimeLdapConnectionTestWasMade;
                    if (timeDiff >= 120000L) {
                        this.m_lPreviousTimeLdapConnectionTestWasMade = timeNow;
                        try {
                            PimAddressEntryItems pimAddressEntryItems = this.m_oLdapPimAddressBook.getAddressEntryItems();
                            PimAddressEntryItemFilter pimAddressEntryItemFilter = pimAddressEntryItems.getAddressEntryItemFilter();
                            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.OPEN);
                            pimAddressEntryItemFilter.setFirstName("A");
                            pimAddressEntryItemFilter.setOperand(PimFilterOperandType.CLOSE);
                            pimAddressEntryItems.getFirstAddressEntryItem();
                        }
                        catch (Exception e) {
                            this.m_oLdapPimAddressBook = this.getLdapAddressBook();
                        }
                    }
                }
                return this.m_oLdapPimAddressBook;
            }
            return new ExWebDavPimGlobalAddressBook(this, "", "");
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimFolder getTask(String user) throws ExWebDavPimException {
        try {
            if (user == null) {
                user = this.getUserMailbox();
            }
            return new ExWebDavPimTask(this, this.getPimFolderType().getTasksFullName(this), this.getPimFolderType().getTasksDisplayName(this));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getPrivateRootFolder() {
        return new ExWebDavPimFolder(this, this.getRootFolderName() + "/" + this.getUserMailbox(), "Root", "");
    }

    public PimFolder getPublicRootFolder() {
        return new ExWebDavPimFolder(this, ExWebDavPimFolderType.PUBLIC_ROOT_FOLDER.toString(), "PublicRoot", "");
    }

    public boolean isTimeZoneSetByUser() {
        return this.m_bWasTimeZoneTypeSet;
    }

    public void setTimeZoneInternal(PimTimeZoneType pimTimeZoneType) {
        this.m_oPimTimeZoneType = pimTimeZoneType;
    }

    public PimAddressEntryItem getCurrentUser() throws ExWebDavPimException {
        try {
            if (this.isItLdapConnection && this.m_oPimAddressEntryItem != null) {
                return this.m_oPimAddressEntryItem;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
        return null;
    }
}

