/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewPersonalAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldDistributionListItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldPersonalAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressEntryItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAddressEntryItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFieldTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimPersonalAddressEntryItems
extends ExWebDavPimMessageItems
implements PimAddressEntryItems {
    private ExWebDavPimPersonalAddressBook m_oPimPersonalAddressBook;
    private ExWebDavPimPersonalAddressEntryItemFilter m_oPimAddressEntryItemFilter;
    private boolean m_bIsInitializeCalled = false;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private boolean m_bIsAddressEntryItemFilterCalled;
    private Vector m_vOrderBy = new Vector();

    public ExWebDavPimPersonalAddressEntryItems(ExWebDavPimPersonalAddressBook pimPersonalAddressBook, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimPersonalAddressBook = pimPersonalAddressBook;
        this.m_oPimAddressEntryItemFilter = new ExWebDavPimPersonalAddressEntryItemFilter();
    }

    public ExWebDavPimPersonalAddressBook getPimPersonalAddressBook() {
        return this.m_oPimPersonalAddressBook;
    }

    public PimAddressEntryItem addAddressEntryItem() throws ExWebDavPimException {
        return new ExWebDavPimNewPersonalAddressEntryItem(this.getPimSession(), this.m_oPimPersonalAddressBook);
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws ExWebDavPimException {
        try {
            this.m_bIsAddressEntryItemFilterCalled = true;
            return this.m_oPimAddressEntryItemFilter;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimPersonalAddressBook getPersonalAddressBook() {
        return this.m_oPimPersonalAddressBook;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPersonalAddressBook().getFolderName();
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getOrderByString() {
        if (this.m_vOrderBy != null && this.m_vOrderBy.size() > 0) {
            StringBuffer orderByStrb = new StringBuffer();
            int i = 0;
            while (i < this.m_vOrderBy.size()) {
                WebDavField webDavField = (WebDavField)this.m_vOrderBy.elementAt(i);
                if (i != 0) {
                    orderByStrb.append(",");
                }
                orderByStrb.append("\"" + webDavField.getActualNameSpaceWithProperty() + "\" *TEMPL*");
                ++i;
            }
            return orderByStrb.toString();
        }
        return this.m_oPimAddressEntryItemFilter.getOrderByString();
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            String whereString = this.m_oPimAddressEntryItemFilter.getWhereString();
            String orderByString = this.getOrderByString();
            Vector fieldsVector = ExWebDavPimAddressEntryItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, orderByString, this.m_oPimSortType);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            int cacheCount;
            if (this.m_bIsAddressEntryItemFilterCalled && !this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if (this.m_bIsAddressEntryItemFilterCalled) {
                this.getCache().setPageSize(-1);
            }
            if ((cacheCount = this.getCache().getNumOfElements()) != -1) {
                return cacheCount;
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            String contentClassString = XMLUtilities.getValue(element, WebDavField.CONTENTCLASS);
            String outlookMessageClassString = XMLUtilities.getValue(element, WebDavField.OUTLOOKMESSAGECLASS);
            if (contentClassString != null && outlookMessageClassString != null && contentClassString.equals("urn:content-classes:group") && outlookMessageClassString.equals("IPM.DistList")) {
                return new ExWebDavPimOldDistributionListItem(this.getPimSession(), this.getPimPersonalAddressBook(), element);
            }
            return new ExWebDavPimOldPersonalAddressEntryItem(this.getPimSession(), this.getPimPersonalAddressBook(), element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            ExWebDavPimPersonalAddressEntryItemFilter uidFilter = new ExWebDavPimPersonalAddressEntryItemFilter();
            uidFilter.setID(id);
            String whereString = uidFilter.getWhereString();
            Vector fieldsVector = ExWebDavPimAddressEntryItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
            String text = StringUtility.getTextAfterEncoding(response);
            int numOfElements = XMLUtilities.getNumOfElements(text, WebDavField.RESPONSE);
            Element element = null;
            int i2 = 0;
            while (i2 < numOfElements) {
                String retrievedId;
                element = XMLUtilities.getValueAsElement(text, WebDavField.RESPONSE, i2);
                if (element != null && (retrievedId = XMLUtilities.getValue(element, WebDavField.UID)).equals(id)) break;
                ++i2;
            }
            if (element == null) {
                return null;
            }
            String contentClassString = XMLUtilities.getValue(element, WebDavField.CONTENTCLASS);
            String outlookMessageClassString = XMLUtilities.getValue(element, WebDavField.OUTLOOKMESSAGECLASS);
            if (contentClassString.equals("urn:content-classes:group") && outlookMessageClassString.equals("IPM.DistList")) {
                return new ExWebDavPimOldDistributionListItem(this.getPimSession(), this.getPimPersonalAddressBook(), element);
            }
            return new ExWebDavPimOldPersonalAddressEntryItem(this.getPimSession(), this.getPimPersonalAddressBook(), element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                this.m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws ExWebDavPimException {
        try {
            if (pimFieldType != null) {
                int i = 0;
                while (i < pimFieldType.length) {
                    WebDavField webDavField;
                    if (pimFieldType[i] != null && (webDavField = ExWebDavPimFieldTypeMapper.getType(pimFieldType[i])) != null) {
                        this.m_vOrderBy.add(webDavField);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
    }
}

