/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAttachmentItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.ExWebDavPimTaskItem;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavMapiFieldHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldTaskItem
extends ExWebDavPimMessageItem
implements ExWebDavPimTaskItem {
    private boolean m_bIsItNew;
    private ExWebDavPimAttachmentItems m_oPimAttachmentItems;
    private String m_szSubject;
    private String m_szText;
    private WebDavDate m_oStartTime;
    private WebDavDate m_oDueTime;
    private PimTaskStatusType m_oPimTaskStatusType = PimTaskStatusType.NOT_COMPLETE;
    private ExWebDavPimFolder m_oPimFolder;
    private Element m_oElement;

    public ExWebDavPimOldTaskItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) {
        super(pimSession);
        this.m_oPimFolder = pimFolder;
        this.m_oElement = element;
    }

    public String getHref() throws ExWebDavPimException {
        return XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.UID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void update() throws ExWebDavPimException {
        try {
            this.update(true, true);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void checkValidity() throws ExWebDavPimException {
        if (this.m_oStartTime != null && this.m_oDueTime != null && !this.m_oDueTime.after(this.m_oStartTime) && !this.m_oDueTime.equals(this.m_oStartTime)) {
            throw new ExWebDavPimException(13L);
        }
    }

    public void update(boolean makePermanent, boolean refreshObject) throws ExWebDavPimException {
        try {
            this.checkValidity();
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            if (this.m_szSubject != null) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject));
            }
            if (this.m_szText != null) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szText));
            }
            if (this.m_oDueTime != null) {
                this.m_oDueTime.resetToThisDay();
                toSend.add(new PropertyHolder(WebDavField.TASK_END_DATE, this.m_oDueTime.getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.COMMON_TASK_END_DATE, this.m_oDueTime.getFormattedDate()));
            }
            if (this.m_oStartTime != null) {
                this.m_oStartTime.resetToThisDay();
                toSend.add(new PropertyHolder(WebDavField.TASK_START_DATE, this.m_oStartTime.getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.COMMON_TASK_START_DATE, this.m_oStartTime.getFormattedDate()));
            }
            if (this.m_oPimTaskStatusType != null) {
                if (this.m_oPimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                    toSend.add(new PropertyHolder(WebDavField.TASK_COMPLETE, "1"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_PERCENTAGE_COMPLETE, "1.0"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_STATUS, "2"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_STATE, "1"));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    WebDavDate webDavDate = new WebDavDate(cal.getTime(), this.getPimSession());
                    toSend.add(new PropertyHolder(WebDavField.TASK_DATE_COMPLETED, webDavDate.getFormattedDate()));
                } else {
                    toSend.add(new PropertyHolder(WebDavField.TASK_COMPLETE, "0"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_PERCENTAGE_COMPLETE, "0."));
                    toSend.add(new PropertyHolder(WebDavField.TASK_STATUS, "0"));
                }
            }
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", this.getHref(), xmlString);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
        try {
            this.delete(true);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete(boolean flag) throws ExWebDavPimException {
        try {
            this.getPimSession().getHttpConnector().delete(this.getHref());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        try {
            this.m_szSubject = subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            String subject = XMLUtilities.getValue(this.m_oElement, WebDavField.SUBJECT);
            return subject == null ? "" : subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        try {
            this.m_szText = text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getText() throws ExWebDavPimException {
        try {
            String text = XMLUtilities.getValue(this.m_oElement, WebDavField.BODY);
            return text == null ? "" : text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate getWebDavStartTime() throws ExWebDavPimException {
        String dtStart = XMLUtilities.getValue(this.m_oElement, WebDavMapiFieldHelper.getReplaceWebDavField(WebDavField.TASK_START_DATE));
        if (dtStart == null) {
            return null;
        }
        WebDavDate webDavStartDate = new WebDavDate(dtStart, this.getPimSession(), true);
        return webDavStartDate;
    }

    public WebDavDate getWebDavDueTime() throws ExWebDavPimException {
        String dtEnd = XMLUtilities.getValue(this.m_oElement, WebDavMapiFieldHelper.getReplaceWebDavField(WebDavField.TASK_END_DATE));
        if (dtEnd == null) {
            return null;
        }
        WebDavDate webDavEndDate = new WebDavDate(dtEnd, this.getPimSession(), true);
        return webDavEndDate;
    }

    public void setStartDate(Date startDate) throws ExWebDavPimException {
        try {
            this.m_oStartTime = new WebDavDate(startDate, this.getPimSession());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartDate() throws ExWebDavPimException {
        try {
            WebDavDate startDate = this.getWebDavStartTime();
            if (startDate == null) {
                return null;
            }
            return startDate.getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setDueDate(Date dueDate) throws ExWebDavPimException {
        try {
            this.m_oDueTime = new WebDavDate(dueDate, this.getPimSession());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getDueDate() throws ExWebDavPimException {
        try {
            WebDavDate dueDate = this.getWebDavDueTime();
            if (dueDate == null) {
                return null;
            }
            return dueDate.getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        try {
            return "Task Item: " + this.getSubject();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws PimException {
        try {
            this.m_oPimTaskStatusType = pimTaskStatusType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskStatusType getStatus() throws PimException {
        try {
            String status = XMLUtilities.getValue(this.m_oElement, WebDavMapiFieldHelper.getReplaceWebDavField(WebDavField.TASK_COMPLETE));
            if (status == null) {
                return PimTaskStatusType.NOT_COMPLETE;
            }
            if (status.equals("1")) {
                return PimTaskStatusType.COMPLETE;
            }
            return PimTaskStatusType.NOT_COMPLETE;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

