/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimNthRecurParameter;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternDayTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternMonthTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternNthTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimYearlyRecurParameter;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExWebDavPimOldRecurrencePatternItem
extends ExWebDavPimNewRecurrencePatternItem {
    private String m_szRecurrenceString;

    public ExWebDavPimOldRecurrencePatternItem(String recurrenceString, ExWebDavPimAppointmentItem pimAppointmentItem) throws ExWebDavPimException {
        super(pimAppointmentItem);
        this.m_szRecurrenceString = recurrenceString;
        this.initialize();
    }

    public void initialize() throws ExWebDavPimException {
        try {
            if (this.m_szRecurrenceString == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(this.m_szRecurrenceString, ";");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                this.setAppropriateFields(str);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setAppropriateFields(String str) throws ExWebDavPimException {
        try {
            StringTokenizer subst = new StringTokenizer(str, "=");
            String index = subst.nextToken();
            String value = subst.nextToken();
            if (index.equals("FREQ")) {
                if (value.equals("DAILY")) {
                    this.setType(PimRecurrencePatternType.DAILY);
                } else if (value.equals("WEEKLY")) {
                    this.setType(PimRecurrencePatternType.WEEKLY);
                } else if (value.equals("MONTHLY")) {
                    this.setType(PimRecurrencePatternType.MONTHLY);
                } else if (value.equals("YEARLY")) {
                    this.setType(PimRecurrencePatternType.YEARLY);
                }
            } else if (index.equals("COUNT")) {
                try {
                    int noOfOccurences = Integer.parseInt(value);
                    this.setNoOfOccurrences(noOfOccurences);
                }
                catch (Exception e) {}
            } else if (index.equals("UNTIL")) {
                WebDavDate webDavDate = new WebDavDate(value, true, this.getPimSession());
                this.setRecurrenceEndDate(webDavDate.getDate());
            } else if (index.equals("INTERVAL")) {
                int interval = Integer.parseInt(value);
                this.setInterval(interval);
            } else if (index.equals("BYSETPOS")) {
                int pos = Integer.parseInt(value);
                Vector daysOfWeek = this.getDaysOfWeek();
                StringBuffer completeString = new StringBuffer();
                int i = 0;
                while (i < daysOfWeek.size()) {
                    String type = ExWebDavPimRecurrencePatternDayTypeMapper.getType((PimRecurrencePatternDayType)daysOfWeek.elementAt(i));
                    if (i != 0) {
                        completeString.append(", ");
                    }
                    completeString.append(type);
                    ++i;
                }
                this.setPimNthRecurParameter(ExWebDavPimNthRecurParameter.getRecurParameter(pos));
                this.setNthType(ExWebDavPimRecurrencePatternNthTypeMapper.getType(pos + ""));
                this.setPimRecurrencePatternDayType(ExWebDavPimRecurrencePatternDayTypeMapper.getType(completeString.toString()));
                this.setDayType(ExWebDavPimRecurrencePatternDayTypeMapper.getType(completeString.toString()));
                daysOfWeek = new Vector();
                this.setDaysOfWeek(daysOfWeek);
            } else if (index.equals("BYDAY")) {
                String day;
                StringTokenizer bydayst;
                boolean isItString = false;
                if (value.indexOf(",") == -1) {
                    bydayst = new StringTokenizer(value);
                    try {
                        int nthRecurParameter = Integer.parseInt(bydayst.nextToken());
                        day = bydayst.nextToken();
                        this.setPimNthRecurParameter(ExWebDavPimNthRecurParameter.getRecurParameter(nthRecurParameter));
                        this.setNthType(ExWebDavPimRecurrencePatternNthTypeMapper.getType(nthRecurParameter + ""));
                        this.setPimRecurrencePatternDayType(ExWebDavPimRecurrencePatternDayTypeMapper.getType(day.trim()));
                        this.setDayType(ExWebDavPimRecurrencePatternDayTypeMapper.getType(day.trim()));
                    }
                    catch (Exception e) {
                        isItString = true;
                    }
                } else {
                    isItString = true;
                }
                if (isItString) {
                    bydayst = new StringTokenizer(value, ",");
                    Vector<PimRecurrencePatternDayType> daysOfWeek = new Vector<PimRecurrencePatternDayType>();
                    while (bydayst.hasMoreTokens()) {
                        day = bydayst.nextToken();
                        daysOfWeek.add(ExWebDavPimRecurrencePatternDayTypeMapper.getType(day.trim()));
                    }
                    this.setDaysOfWeek(daysOfWeek);
                }
            } else if (index.equals("BYMONTHDAY")) {
                int day = Integer.parseInt(value);
                Vector<Integer> daysOfMonth = new Vector<Integer>();
                daysOfMonth.add(new Integer(day));
                this.setDaysOfMonth(daysOfMonth);
            } else if (index.equals("BYMONTH")) {
                int month = Integer.parseInt(value);
                ExWebDavPimYearlyRecurParameter pimYearlyRecurParameter = ExWebDavPimYearlyRecurParameter.getRecurParameter(month);
                this.setPimYearlyRecurParameter(pimYearlyRecurParameter);
                this.setMonthType(ExWebDavPimRecurrencePatternMonthTypeMapper.getType(month));
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

