/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFieldItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldPersonalAddressEntryItem
extends ExWebDavPimMessageItem
implements PimAddressEntryItem {
    private Element m_oElement;
    private ExWebDavPimFolder m_oPimFolder;
    private String m_szResponseXmlString;
    private String m_szFirstName;
    private String m_szLastName;
    private String m_szEmailAddress;
    private String m_szBusinessCity;
    private String m_szBusinessCountry;
    private String m_szBusinessFaxNumber;
    private String m_szBusinessState;
    private String m_szBusinessStreet;
    private String m_szBusinessTelephoneNumber;
    private String m_szBusinessZip;
    private String m_szCompanyName;
    private String m_szHomeCity;
    private String m_szHomeCountry;
    private String m_szHomeState;
    private String m_szHomeStreet;
    private String m_szHomeTelephoneNumber;
    private String m_szHomeZip;
    private String m_szMobileTelephoneNumber;
    private String m_szTitle;
    private String m_szMiddleName;

    public ExWebDavPimOldPersonalAddressEntryItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) throws ExWebDavPimException {
        super(pimSession);
        this.m_oElement = element;
        this.m_oPimFolder = pimFolder;
    }

    private String getFolderName() throws ExWebDavPimException {
        return this.m_oPimFolder.getFullFolderName();
    }

    public String getName() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.CN);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItems getMembers() throws ExWebDavPimException {
        return null;
    }

    public String getID() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.UID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimBusyStatusType getBusyStatusType(Date startTime, Date endTime, int interval) throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            return PimBusyStatusType.UNKNOWN;
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        return new ExWebDavPimFieldItems(this.m_oElement);
    }

    public String getHref() throws ExWebDavPimException {
        return XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
    }

    public void delete() throws ExWebDavPimException {
        this.getPimSession().getHttpConnector().delete(this.getHref());
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getMiddleName() throws ExWebDavPimException {
        String middleName = XMLUtilities.getValue(this.m_oElement, WebDavField.MIDDLENAME);
        if (middleName == null) {
            middleName = "";
        }
        return middleName;
    }

    private String getFullName() throws ExWebDavPimException {
        if (this.m_szFirstName != null || this.m_szLastName != null) {
            String middleName = this.getMiddleName();
            String firstName = this.getFirstName();
            String lastName = this.getLastName();
            firstName = this.m_szFirstName != null ? this.m_szFirstName : firstName;
            middleName = middleName != null ? middleName : "";
            lastName = this.m_szLastName != null ? this.m_szLastName : lastName;
            return firstName + " " + middleName + " " + lastName;
        }
        return null;
    }

    private String getFileAs() throws ExWebDavPimException {
        if (this.m_szFirstName != null || this.m_szLastName != null) {
            String middleName = this.getMiddleName();
            String firstName = this.getFirstName();
            String lastName = this.getLastName();
            firstName = this.m_szFirstName != null ? this.m_szFirstName : firstName;
            middleName = middleName != null ? middleName : "";
            lastName = this.m_szLastName != null ? this.m_szLastName : lastName;
            return lastName + ", " + firstName + " " + middleName;
        }
        return null;
    }

    public void update() throws ExWebDavPimException {
        try {
            String fileAs;
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            String fullName = this.getFullName();
            if (fullName != null) {
                toSend.add(new PropertyHolder(WebDavField.CN, fullName));
            }
            if (this.m_szFirstName != null) {
                toSend.add(new PropertyHolder(WebDavField.FIRSTNAME, this.m_szFirstName));
            }
            if (this.m_szMiddleName != null) {
                toSend.add(new PropertyHolder(WebDavField.MIDDLENAME, this.m_szMiddleName));
            }
            if (this.m_szLastName != null) {
                toSend.add(new PropertyHolder(WebDavField.SN, this.m_szLastName));
            }
            if (this.m_szEmailAddress != null) {
                toSend.add(new PropertyHolder(WebDavField.EMAIL1, "\"" + this.m_szEmailAddress + "\" <" + this.m_szEmailAddress + ">"));
            }
            if (this.m_szBusinessCity != null) {
                toSend.add(new PropertyHolder(WebDavField.L, this.m_szBusinessCity));
            }
            if (this.m_szMobileTelephoneNumber != null) {
                toSend.add(new PropertyHolder(WebDavField.MOBILE, this.m_szMobileTelephoneNumber));
            }
            if (this.m_szTitle != null) {
                toSend.add(new PropertyHolder(WebDavField.TITLE, this.m_szTitle));
            }
            if (this.m_szBusinessCountry != null) {
                toSend.add(new PropertyHolder(WebDavField.CO, this.m_szBusinessCountry));
            }
            if (this.m_szBusinessFaxNumber != null) {
                toSend.add(new PropertyHolder(WebDavField.FACSIMILETELEPHONENUMBER, this.m_szBusinessFaxNumber));
            }
            if (this.m_szBusinessState != null) {
                toSend.add(new PropertyHolder(WebDavField.ST, this.m_szBusinessState));
            }
            if (this.m_szBusinessStreet != null) {
                toSend.add(new PropertyHolder(WebDavField.STREET, this.m_szBusinessStreet));
            }
            if (this.m_szBusinessTelephoneNumber != null) {
                toSend.add(new PropertyHolder(WebDavField.TELEPHONENUMBER, this.m_szBusinessTelephoneNumber));
            }
            if (this.m_szBusinessZip != null) {
                toSend.add(new PropertyHolder(WebDavField.POSTALCODE, this.m_szBusinessZip));
            }
            if (this.m_szCompanyName != null) {
                toSend.add(new PropertyHolder(WebDavField.O, this.m_szCompanyName));
            }
            if (this.m_szHomeCity != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMECITY, this.m_szHomeCity));
            }
            if (this.m_szHomeCountry != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMECOUNTRY, this.m_szHomeCountry));
            }
            if (this.m_szHomeState != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMESTATE, this.m_szHomeState));
            }
            if (this.m_szHomeStreet != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMESTREET, this.m_szHomeStreet));
            }
            if (this.m_szHomeTelephoneNumber != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMEPHONE, this.m_szHomeTelephoneNumber));
            }
            if (this.m_szHomeZip != null) {
                toSend.add(new PropertyHolder(WebDavField.HOMEPOSTALCODE, this.m_szHomeZip));
            }
            if ((fileAs = this.getFileAs()) != null) {
                toSend.add(new PropertyHolder(WebDavField.FILEAS, fileAs));
            }
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", this.getHref(), xmlString);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getEmailAddress() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.EMAIL1);
            if (str == null) {
                return "";
            }
            return StringUtility.stripOutJustEmail(str);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getLastName() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.SN);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getFirstName() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.FIRSTNAME);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getLogonName() throws PimException {
        return this.getFullName();
    }

    public String getAlternateFullName() throws PimException {
        return "";
    }

    public String getBusinessTelephoneNumber() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.TELEPHONENUMBER);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeTelephoneNumber() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMEPHONE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getMobileTelephoneNumber() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.MOBILE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessFaxNumber() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.FACSIMILETELEPHONENUMBER);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getTitle() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.TITLE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCompanyName() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.O);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessStreet() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.STREET);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessCity() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.L);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessState() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.ST);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessZip() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.POSTALCODE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessCountry() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.CO);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeStreet() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMESTREET);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeCity() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMECITY);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeState() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMESTATE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeZip() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMEPOSTALCODE);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeCountry() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.HOMECOUNTRY);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        return null;
    }

    public void setEmailAddress(String emailAddress) throws ExWebDavPimException {
        this.m_szEmailAddress = emailAddress;
    }

    public void setLastName(String lastName) throws ExWebDavPimException {
        this.m_szLastName = lastName;
    }

    public void setFirstName(String firstname) throws ExWebDavPimException {
        this.m_szFirstName = firstname;
    }

    public void setMiddleName(String middleName) throws PimException {
        this.m_szMiddleName = middleName;
    }

    public void setAlternateFullName(String alternateFullName) throws PimException {
    }

    public void setBusinessTelephoneNumber(String bTelNumber) throws ExWebDavPimException {
        this.m_szBusinessTelephoneNumber = bTelNumber;
    }

    public void setHomeTelephoneNumber(String hTelNumber) throws ExWebDavPimException {
        this.m_szHomeTelephoneNumber = hTelNumber;
    }

    public void setMobileTelephoneNumber(String mTelNumber) throws ExWebDavPimException {
        this.m_szMobileTelephoneNumber = mTelNumber;
    }

    public void setBusinessFaxNumber(String bFaxNumber) throws ExWebDavPimException {
        this.m_szBusinessFaxNumber = bFaxNumber;
    }

    public void setTitle(String title) throws ExWebDavPimException {
        this.m_szTitle = title;
    }

    public void setCompanyName(String companyName) throws ExWebDavPimException {
        this.m_szCompanyName = companyName;
    }

    public void setHomeStreet(String hStreet) throws ExWebDavPimException {
        this.m_szHomeStreet = hStreet;
    }

    public void setHomeCity(String hCity) throws ExWebDavPimException {
        this.m_szHomeCity = hCity;
    }

    public void setHomeState(String hState) throws ExWebDavPimException {
        this.m_szHomeState = hState;
    }

    public void setHomeZip(String hZip) throws ExWebDavPimException {
        this.m_szHomeZip = hZip;
    }

    public void setHomeCountry(String hCountry) throws ExWebDavPimException {
        this.m_szHomeCountry = hCountry;
    }

    public void setBusinessStreet(String bStreet) throws ExWebDavPimException {
        this.m_szBusinessStreet = bStreet;
    }

    public void setBusinessCity(String bCity) throws ExWebDavPimException {
        this.m_szBusinessCity = bCity;
    }

    public void setBusinessState(String bState) throws ExWebDavPimException {
        this.m_szBusinessState = bState;
    }

    public void setBusinessZip(String bZip) throws ExWebDavPimException {
        this.m_szBusinessZip = bZip;
    }

    public void setBusinessCountry(String bCountry) throws ExWebDavPimException {
        this.m_szBusinessCountry = bCountry;
    }

    public PimAddressEntryItems addMembers() throws PimException {
        return null;
    }
}

