/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimMeetingItemResponseType;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMailMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMeetingItemResponseTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavPimUtility;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMeetingItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldMeetingItem
extends ExWebDavPimOldMailMessageItem
implements PimMeetingItem {
    private String m_szBody;
    private String m_szSubject;
    private boolean m_bIsAllDayEvent;
    private String draftFolderResponseFileName;

    public ExWebDavPimOldMeetingItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) {
        super(pimSession, pimFolder, element);
    }

    public String getLocation() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.getElement(), WebDavField.LOCATION);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartTime() throws ExWebDavPimException {
        try {
            return this.getWebDavStartTime().getDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public WebDavDate getWebDavEndTime() throws ExWebDavPimException {
        String dtEnd = XMLUtilities.getValue(this.getElement(), WebDavField.DTEND);
        WebDavDate webDavEndDate = new WebDavDate(dtEnd, this.getPimSession());
        return webDavEndDate;
    }

    public WebDavDate getWebDavStartTime() throws ExWebDavPimException {
        String dtStart = XMLUtilities.getValue(this.getElement(), WebDavField.DTSTART);
        WebDavDate webDavStartDate = new WebDavDate(dtStart, this.getPimSession());
        return webDavStartDate;
    }

    public Date getEndTime() throws ExWebDavPimException {
        try {
            return this.getWebDavEndTime().getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean isAllDayEvent() throws ExWebDavPimException {
        try {
            String allDayEvent = XMLUtilities.getValue(this.getElement(), WebDavField.ALLDAYEVENT);
            this.m_bIsAllDayEvent = allDayEvent.equals("1");
            return this.m_bIsAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimAppointmentItem getExWebDavPimAppointmentItem() throws ExWebDavPimException {
        ExWebDavPimOldAppointmentItem exWebDavPimOldAppointmentItem = new ExWebDavPimOldAppointmentItem(this.getPimSession(), this.getPimFolder(), this.getElement());
        return exWebDavPimOldAppointmentItem;
    }

    private Vector fillInvitees(Vector toSend) throws ExWebDavPimException {
        try {
            PimRecipientItems pimRecipientItems = this.getRecipientItems();
            PimRecipientItem pimRecipientItem = pimRecipientItems.getFirstRecipientItem();
            while (pimRecipientItem != null) {
                String emailAddress = pimRecipientItem.getEmailAddress();
                if (emailAddress == null) {
                    emailAddress = pimRecipientItem.getAddressEntryItem().getEmailAddress();
                }
                toSend.add(new PropertyHolder(WebDavField.HEADER_TO, emailAddress));
                pimRecipientItem = pimRecipientItems.getNextRecipientItem();
            }
            return toSend;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private ExWebDavPimGlobalAddressEntryItem getExWebDavAddressEntry() throws ExWebDavPimException {
        return null;
    }

    public String getOrganizer() throws ExWebDavPimException {
        String organizer = XMLUtilities.getValue(this.getElement(), WebDavField.ORGANIZER);
        return organizer;
    }

    public PimAppointmentItem getAssociatedAppointmentItem() throws ExWebDavPimException {
        try {
            return this.getExWebDavPimAppointmentItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean getUnread() throws ExWebDavPimException {
        return false;
    }

    public void setUnread(boolean flag) throws ExWebDavPimException {
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimFieldItems getFields() throws ExWebDavPimException {
        return null;
    }

    public void update() throws ExWebDavPimException {
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExWebDavPimException {
    }

    public void respond(PimMeetingItemResponseType pimMeetingItemResponseType) throws ExWebDavPimException {
        try {
            int end;
            Vector toSend = new Vector();
            toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.getSubject()));
            toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.getBody()));
            if (this.getImportance() != null) {
                toSend.add(new PropertyHolder(WebDavField.PRIORITY, ExWebDavPimImportanceTypeMapper.getType(this.getImportance())));
            } else {
                toSend.add(new PropertyHolder(WebDavField.PRIORITY, "0"));
            }
            if (this.getLocation() != null) {
                toSend.add(new PropertyHolder(WebDavField.LOCATION, this.getLocation()));
            }
            if (!this.isAllDayEvent()) {
                if (this.getWebDavEndTime() != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.getWebDavEndTime().getFormattedDate()));
                    toSend.add(new PropertyHolder(WebDavField.PATTERNEND, this.getWebDavEndTime().getFormattedDate()));
                }
                if (this.getWebDavStartTime() != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.getWebDavStartTime().getFormattedDate()));
                    toSend.add(new PropertyHolder(WebDavField.PATTERNSTART, this.getWebDavStartTime().getFormattedDate()));
                }
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "BUSY"));
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "0"));
            } else {
                if (this.getWebDavEndTime() != null) {
                    this.getWebDavEndTime().resetToNextDay();
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.getWebDavEndTime().getFormattedDate()));
                }
                if (this.getWebDavStartTime() != null) {
                    this.getWebDavStartTime().resetToThisDay();
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.getWebDavStartTime().getFormattedDate()));
                }
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "1"));
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "FREE"));
            }
            toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "CONFIRMED"));
            toSend.add(new PropertyHolder(WebDavField.MAPI_RESPONSESTATUS, ExWebDavPimMeetingItemResponseTypeMapper.getType(pimMeetingItemResponseType)));
            WebDavDate webDavDate = new WebDavDate(new Date());
            toSend.add(new PropertyHolder(WebDavField.REPLYTIME, webDavDate.getFormattedDate()));
            toSend = this.fillInvitees(toSend);
            Element recurStringElement = XMLUtilities.getValueAsElement(this.getElement(), WebDavField.RRULE);
            Element exDateElement = XMLUtilities.getValueAsElement(this.getElement(), WebDavField.EXDATE);
            String recurrenceString = null;
            if (recurStringElement != null) {
                recurrenceString = XMLUtilities.getValue(recurStringElement, WebDavField.V);
            }
            if (recurrenceString != null) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "1"));
                PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                if (exDateElement != null) {
                    int numOfElements = XMLUtilities.getNumOfElements(exDateElement, WebDavField.V);
                    Vector<PropertyHolder> exDateV = new Vector<PropertyHolder>();
                    int i = 0;
                    while (i < numOfElements) {
                        String exDate = XMLUtilities.getValue(exDateElement, WebDavField.V, i);
                        WebDavDate webDavDate1 = new WebDavDate(exDate, this.getPimSession());
                        exDateV.add(new PropertyHolder(WebDavField.V, webDavDate1.getFormattedDate()));
                        ++i;
                    }
                    if (exDateV.size() > 0) {
                        toSend.add(new PropertyHolder(WebDavField.EXDATE, exDateV));
                    }
                }
            }
            toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.Appointment"));
            toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:appointment"));
            toSend.add(new PropertyHolder(WebDavField.ORGANIZER, this.getOrganizer()));
            String calendarUid = XMLUtilities.getValue(this.getElement(), WebDavField.CALENDARUID);
            toSend.add(new PropertyHolder(WebDavField.CALENDARUID, calendarUid));
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getPimSession().getCalendar(null).getFolderName();
            String calendarUID = XMLUtilities.getValue(this.getElement(), WebDavField.CALENDARUID);
            String whereString = "(\"http://schemas.microsoft.com/exchange/outlookmessageclass\"='IPM.Appointment' OR \"DAV:contentclass\"='urn:content-classes:appointment')  AND \"urn:schemas:calendar:uid\"='" + calendarUID + "'";
            Vector<WebDavField> fieldsVector = new Vector<WebDavField>();
            fieldsVector.add(WebDavField.UID);
            fieldsVector.add(WebDavField.CALENDARUID);
            fieldsVector.add(WebDavField.DISPLAYNAME);
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
            int numOfElements = XMLUtilities.getNumOfElements(response.getText(), WebDavField.RESPONSE);
            Element element = null;
            int i2 = 0;
            while (i2 < numOfElements) {
                String uid;
                element = XMLUtilities.getValueAsElement(response.getText(), WebDavField.RESPONSE, i2);
                if (element != null && (uid = XMLUtilities.getValue(element, WebDavField.CALENDARUID)).equals(calendarUID)) break;
                ++i2;
            }
            String uniqueFileName = "";
            if (element != null) {
                uniqueFileName = fromString + "/" + XMLUtilities.getValue(element, WebDavField.DISPLAYNAME);
                this.getPimSession().getHttpConnector().delete(uniqueFileName);
            }
            uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getCalndarFolderName(), this.getSubject());
            response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            String cmd = "";
            if (pimMeetingItemResponseType.equals(PimMeetingItemResponseType.ACCEPTED)) {
                cmd = "accept";
            } else if (pimMeetingItemResponseType.equals(PimMeetingItemResponseType.TENTATIVE)) {
                cmd = "tentative";
            } else if (pimMeetingItemResponseType.equals(PimMeetingItemResponseType.DECLINED)) {
                cmd = "decline";
            }
            response = this.getPimSession().getHttpConnector().sendRequest("GET", uniqueFileName + "?Cmd=" + cmd, "");
            String responseText = response.getText();
            int start = responseText.indexOf("<INPUT type=\"hidden\" name=\"MsgID\" value=\"");
            if (start != -1 && (end = responseText.indexOf("\" />", start)) != -1) {
                this.draftFolderResponseFileName = responseText.substring(start + 41, end);
            }
            this.getPimSession().getHttpConnector().delete(this.getHref());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            if (this.m_szSubject != null || this.m_szBody != null) {
                this.m_szSubject = this.m_szSubject == null ? this.getSubject() : this.m_szSubject;
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject));
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szBody == null ? this.getBody() : this.m_szBody));
                String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
                String fileName = this.getPimSession().getRootFolderName() + "/" + this.getPimSession().getUserInfo().getMailbox() + this.draftFolderResponseFileName;
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", fileName, xmlString);
            }
            HTTPResponse hTTPResponse = this.getPimSession().getHttpConnector().move(this.getPimSession().getRootFolderName() + "/" + this.getPimSession().getUserInfo().getMailbox() + this.draftFolderResponseFileName, this.getPimSession().getPimFolderType().getMailSubmissionURI(this.getPimSession()));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        try {
            ExWebDavPimOldRecipientItems pimRecipientItems = new ExWebDavPimOldRecipientItems(this.getPimSession());
            String to = XMLUtilities.getValue(this.getElement(), WebDavField.HEADER_TO);
            if (to != null) {
                WebDavPimUtility.parseAndAddRecipients(this.getPimSession(), pimRecipientItems, to, PimRecipientType.TO);
            }
            return pimRecipientItems;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem reply() throws ExWebDavPimException {
        return null;
    }

    public PimMailMessageItem replyAll() throws ExWebDavPimException {
        return null;
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        return "MeetingItem: " + this.getSubject();
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        this.m_szSubject = subject;
    }

    public void setBody(String szBody) throws ExWebDavPimException {
        this.m_szBody = szBody;
    }
}

