/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFieldItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMailAttachmentItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimMailMessageItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAddressEntryItemFinder;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAttachmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import com.aligo.pim.interfaces.PimMailMessageItem;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public abstract class ExWebDavPimOldMailMessageItem
extends ExWebDavPimMessageItem
implements PimMailMessageItem {
    private Element m_oElement;
    private ExWebDavPimFolder m_oPimFolder;

    public ExWebDavPimOldMailMessageItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) {
        super(pimSession);
        this.m_oElement = element;
        this.m_oPimFolder = pimFolder;
    }

    protected Element getElement() {
        return this.m_oElement;
    }

    protected ExWebDavPimFolder getPimFolder() {
        return this.m_oPimFolder;
    }

    protected String getFolderName() throws ExWebDavPimException {
        return this.m_oPimFolder.getFullFolderName();
    }

    protected String getCalndarFolderName() throws ExWebDavPimException {
        return this.getPimSession().getCalendar(null).getFolderName();
    }

    protected String getHref() throws ExWebDavPimException {
        return XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
    }

    public PimMailAttachmentItems getAttachmentItems() throws ExWebDavPimException {
        try {
            return new ExWebDavPimMailAttachmentItems(this.getPimSession(), this.m_oElement);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            String subject = XMLUtilities.getValue(this.m_oElement, WebDavField.SUBJECT);
            return subject == null ? "" : subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBody() throws ExWebDavPimException {
        try {
            String body = XMLUtilities.getValue(this.m_oElement, WebDavField.BODY);
            if (body == null) {
                Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
                String fromString = this.getFolderName();
                ExWebDavPimMailMessageItemFilter uidFilter = new ExWebDavPimMailMessageItemFilter();
                uidFilter.setID(this.getID());
                String whereString = uidFilter.getWhereString();
                Vector<WebDavField> fieldsVector = new Vector<WebDavField>();
                fieldsVector.add(WebDavField.BODY);
                fieldsVector.add(WebDavField.UID);
                int i = 0;
                while (i < fieldsVector.size()) {
                    selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                    ++i;
                }
                String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
                HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
                String text = StringUtility.getTextAfterEncoding(response);
                int numOfElements = XMLUtilities.getNumOfElements(text, WebDavField.RESPONSE);
                Element element = null;
                int i2 = 0;
                while (i2 < numOfElements) {
                    String retrievedId;
                    element = XMLUtilities.getValueAsElement(text, WebDavField.RESPONSE, i2);
                    if (element != null && (retrievedId = XMLUtilities.getValue(element, WebDavField.UID)).equals(this.getID())) break;
                    ++i2;
                }
                if (element == null) {
                    return null;
                }
                body = XMLUtilities.getValue(element, WebDavField.BODY);
            }
            return body == null ? "" : body;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExWebDavPimException {
        try {
            String importanceString = XMLUtilities.getValue(this.m_oElement, WebDavField.IMPORTANCE);
            if (importanceString == null) {
                return PimImportanceType.NORMAL;
            }
            return ExWebDavPimImportanceTypeMapper.getType(importanceString);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean getUnread() throws ExWebDavPimException {
        try {
            String readString = XMLUtilities.getValue(this.m_oElement, WebDavField.READSTATUS);
            if (readString == null) {
                return false;
            }
            int read = Integer.parseInt(readString);
            switch (read) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getSender() throws ExWebDavPimException {
        try {
            String senderEmail = XMLUtilities.getValue(this.m_oElement, WebDavField.FROMEMAIL);
            if (senderEmail != null) {
                return ExWebDavPimAddressEntryItemFinder.searchFromGABWithEmailAddress(senderEmail, this.getPimSession());
            }
            String senderName = XMLUtilities.getValue(this.m_oElement, WebDavField.FROMNAME);
            if (senderName != null) {
                return ExWebDavPimAddressEntryItemFinder.searchFromABWithName(senderName, this.getPimSession());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSenderName() throws PimException {
        PimAddressEntryItem pimAddressEntryItem = this.getSender();
        if (pimAddressEntryItem == null) {
            return null;
        }
        return pimAddressEntryItem.getName();
    }

    public String getClassType() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.CLASSTYPE);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.UID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws PimException {
        this.getPimSession().getHttpConnector().delete(this.getHref());
    }

    public WebDavDate getWebDavTimeReceived() throws ExWebDavPimException {
        String dtReceived = XMLUtilities.getValue(this.m_oElement, WebDavField.DATERECEIVED);
        if (dtReceived == null) {
            return null;
        }
        WebDavDate webDavDate = new WebDavDate(dtReceived, this.getPimSession());
        return webDavDate;
    }

    public Date getTimeReceived() throws ExWebDavPimException {
        try {
            WebDavDate webDavDate = this.getWebDavTimeReceived();
            if (webDavDate != null) {
                return this.getWebDavTimeReceived().getDate();
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return new ExWebDavPimFieldItems(this.m_oElement);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean hasAttachment() throws ExWebDavPimException {
        try {
            String hasAttchement = XMLUtilities.getValue(this.m_oElement, WebDavField.HAS_ATTACHMENT);
            if (hasAttchement == null) {
                return false;
            }
            if (hasAttchement.equals("1")) {
                return true;
            }
            if (hasAttchement.equals("0")) {
                return false;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
        return false;
    }

    public long getSize() throws ExWebDavPimException {
        try {
            String contentLengthStr = XMLUtilities.getValue(this.m_oElement, WebDavField.GETCONTENTLENGTH);
            if (contentLengthStr != null) {
                Long contentLength = new Long(contentLengthStr);
                return contentLength;
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    public long getBodySize() throws ExWebDavPimException {
        try {
            long totalSizeOfMessage = this.getSize();
            if (totalSizeOfMessage != -1L) {
                PimMailAttachmentItems pimAttachmentItems = this.getAttachmentItems();
                PimAttachmentItem pimAttachmentItem = pimAttachmentItems.getFirstAttachmentItem();
                long totalSizeOfAttachments = 0L;
                while (pimAttachmentItem != null) {
                    long size = 0L;
                    if (size != -1L) {
                        totalSizeOfAttachments += size;
                    }
                    pimAttachmentItem = pimAttachmentItems.getNextAttachmentItem();
                }
                long actualSizeOfBody = totalSizeOfMessage - totalSizeOfAttachments;
                if (actualSizeOfBody > 0L) {
                    return actualSizeOfBody;
                }
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    public abstract void setUnread(boolean var1) throws PimException;

    public abstract PimMailMessageItem replyAll() throws PimException;

    public abstract PimMailMessageItem reply() throws PimException;
}

