/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewMailItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMailMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavPimUtility;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldMailItem
extends ExWebDavPimOldMailMessageItem
implements PimMailItem {
    private ExWebDavPimRecipientItems m_oPimRecipientItems;
    private boolean m_bUnread;
    private boolean m_bIsSetUnreadMethodCalled;

    public ExWebDavPimOldMailItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) {
        super(pimSession, pimFolder, element);
    }

    public void setBody(String body) throws ExWebDavPimException {
    }

    public void setSubject(String subject) throws ExWebDavPimException {
    }

    public void setImportance(PimImportanceType type) throws ExWebDavPimException {
    }

    public void setUnread(boolean flag) throws ExWebDavPimException {
        try {
            this.m_bIsSetUnreadMethodCalled = true;
            this.m_bUnread = flag;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        try {
            ExWebDavPimOldRecipientItems pimRecipientItems = new ExWebDavPimOldRecipientItems(this.getPimSession());
            String to = XMLUtilities.getValue(this.getElement(), WebDavField.TO);
            WebDavPimUtility.parseAndAddRecipients(this.getPimSession(), pimRecipientItems, to, PimRecipientType.TO);
            String cc = XMLUtilities.getValue(this.getElement(), WebDavField.CC);
            WebDavPimUtility.parseAndAddRecipients(this.getPimSession(), pimRecipientItems, cc, PimRecipientType.CC);
            return pimRecipientItems;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public PimMailMessageItem reply() throws ExWebDavPimException {
        return this.reply(false);
    }

    public PimMailMessageItem replyAll() throws ExWebDavPimException {
        return this.reply(true);
    }

    public PimMailMessageItem reply(boolean replyAll) throws ExWebDavPimException {
        try {
            ExWebDavPimNewMailItem reply = new ExWebDavPimNewMailItem(this.getPimSession(), this.getPimFolder());
            reply.setSubject("RE: " + this.getSubject());
            reply.setBody(this.getBody());
            PimRecipientItems pimRecipientItems = reply.getRecipientItems();
            PimRecipientItem pimRecipientItem = pimRecipientItems.addRecipientItem();
            pimRecipientItem.setEmailAddress(this.getSender().getEmailAddress());
            pimRecipientItem.setRecipientType(PimRecipientType.TO);
            pimRecipientItem.resolve();
            pimRecipientItem.update();
            String user = this.getPimSession().getUserInfo().getUserName();
            PimAddressEntryItem pimAddressEntryItem = this.getPimSession().getCurrentUser();
            String currentUsersEmailAddress = pimAddressEntryItem.getEmailAddress();
            if (replyAll) {
                PimRecipientItems oldRecipientItems = this.getRecipientItems();
                PimRecipientItem oldRecipientItem = oldRecipientItems.getFirstRecipientItem();
                while (oldRecipientItem != null) {
                    boolean add = false;
                    if (!oldRecipientItem.getEmailAddress().equals(currentUsersEmailAddress)) {
                        PimRecipientItem newRecipientItem = pimRecipientItems.addRecipientItem();
                        newRecipientItem.setEmailAddress(oldRecipientItem.getEmailAddress());
                        newRecipientItem.setRecipientType(oldRecipientItem.getRecipientType());
                        newRecipientItem.resolve();
                        newRecipientItem.update();
                    }
                    oldRecipientItem = oldRecipientItems.getNextRecipientItem();
                }
            }
            return reply;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        try {
            ExWebDavPimNewMailItem forward = new ExWebDavPimNewMailItem(this.getPimSession(), this.getPimFolder());
            forward.setSubject("FW: " + this.getSubject());
            forward.setBody(this.getBody());
            return forward;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public void update() throws ExWebDavPimException {
        try {
            if (this.m_bIsSetUnreadMethodCalled) {
                Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
                if (this.m_bUnread) {
                    toSend.add(new PropertyHolder(WebDavField.READSTATUS, "0"));
                } else {
                    toSend.add(new PropertyHolder(WebDavField.READSTATUS, "1"));
                }
                String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
                HTTPResponse hTTPResponse = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", this.getHref(), xmlString);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExWebDavPimException {
    }

    public String getName() throws ExWebDavPimException {
        try {
            return "Mail Item with subject: " + this.getSubject();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

