/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAddressEntryItemsInterface;
import com.aligo.pim.exchangewebdav.ExWebDavPimDistListMemberItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMemberItemsFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewDistListMemberItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldDistListMemberItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldDistributionListItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.HTTPField;
import com.aligo.pim.exchangewebdav.util.HTTPFieldValue;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.HtmlParser;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExWebDavPimOldDistListMemberItems
extends ExWebDavPimDistListMemberItems
implements ExWebDavPimAddressEntryItemsInterface {
    private Element m_oElement;
    private HashMap m_hMemberElements = new HashMap();
    private Vector m_vNewMemberElements = new Vector();
    private static final String MEMBER_ID_DELIMITER = "^";
    private String m_szDistListHREF;
    private PimFieldType[] m_oOrderBy;
    public static PimFieldType m_oDefaultPimFieldType = PimFieldType.NAME;
    public static PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private ExWebDavPimPersonalAddressBook m_oPimPersonalAddressBook;
    private ExWebDavPimOldDistributionListItem m_oPimOldDistributionListItem;
    private ExWebDavPimMemberItemsFilter m_oPimAddressEntryItemFilter;
    private boolean m_bInitializeCalled = false;

    public ExWebDavPimOldDistListMemberItems(ExWebDavPimSession pimSession, ExWebDavPimOldDistributionListItem pimOldDistListItem, ExWebDavPimPersonalAddressBook pimPersonalAddressBook, Element element) throws ExWebDavPimException {
        super(pimSession);
        this.m_oElement = element;
        this.m_oPimPersonalAddressBook = pimPersonalAddressBook;
        this.m_oPimOldDistributionListItem = pimOldDistListItem;
    }

    public String generateId(Element memberElement) {
        String szName = XMLUtilities.getPCData(XMLUtilities.getFirstMatch(memberElement, "dn"));
        String szEmail = XMLUtilities.getPCData(XMLUtilities.getFirstMatch(memberElement, "email"));
        return szName + MEMBER_ID_DELIMITER + szEmail;
    }

    private synchronized void initialize() throws ExWebDavPimException {
        try {
            String href = this.getDistListHREF();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestReturnAsXml(href + "?Cmd=Open");
            String toAppend = new String("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><!DOCTYPE html [<!ENTITY nbsp \"&#160;\">]>");
            String finalResponseText = toAppend + new HtmlParser().parse(response.getText());
            Document finalResponseDocument = DocumentFactory.openStringAsDom(finalResponseText);
            Element rootMemberElement = XMLUtilities.getFirstMatch(finalResponseDocument.getDocumentElement(), "cdldata", true);
            List memberList = XMLUtilities.getMatchingChildren(rootMemberElement, "member");
            this.m_hMemberElements = new HashMap();
            if (memberList != null) {
                Iterator memberListIterator = memberList.iterator();
                while (memberListIterator.hasNext()) {
                    Node node = (Node)memberListIterator.next();
                    if (node == null || !(node instanceof Element) || this.m_oPimAddressEntryItemFilter != null && !this.m_oPimAddressEntryItemFilter.isItValid((Element)node)) continue;
                    String id = this.generateId((Element)node);
                    this.m_hMemberElements.put(id, (Element)node);
                }
            }
            this.m_bInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getDistListHREF() throws ExWebDavPimException {
        if (this.m_szDistListHREF == null) {
            this.m_szDistListHREF = XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
        }
        return this.m_szDistListHREF;
    }

    private String getFolderName() throws ExWebDavPimException {
        return this.m_oPimPersonalAddressBook.getFolderName();
    }

    public ExWebDavPimPersonalAddressBook getPimPersonalAddressBook() {
        return this.m_oPimPersonalAddressBook;
    }

    public PimAddressEntryItem addAddressEntryItem() throws ExWebDavPimException {
        return new ExWebDavPimNewDistListMemberItem(this.getPimSession(), this);
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws ExWebDavPimException {
        try {
            if (this.m_oPimAddressEntryItemFilter == null) {
                this.m_oPimAddressEntryItemFilter = new ExWebDavPimMemberItemsFilter();
            }
            return this.m_oPimAddressEntryItemFilter;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Vector getNewAddressEntryItems() {
        return this.m_vNewMemberElements;
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
        if (pimAddressEntryItem != null) {
            this.m_vNewMemberElements.add(pimAddressEntryItem);
        }
    }

    public void update() throws ExWebDavPimException {
        try {
            super.update();
            this.m_vNewMemberElements = new Vector();
            if (this.m_oPimOldDistributionListItem.isNameChanged()) {
                String baseref = this.getDistListHREF();
                NVPair[] body = new NVPair[]{new NVPair(HTTPField.COMMAND.getFieldName(), HTTPFieldValue.SAVE.getFieldValue()), new NVPair(HTTPField.MSGCLASS.getFieldName(), HTTPFieldValue.IPM_DISTLIST.getFieldValue()), new NVPair(HTTPField.DL_NAME.getFieldName(), this.m_oPimOldDistributionListItem.getChangedName())};
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestAsPostReturnAsXml(baseref, body);
                Document savedocument = DocumentFactory.openStringAsDom(response.getText());
                Element hrefelement = XMLUtilities.getFirstMatch(savedocument.getDocumentElement(), HTTPFieldValue.HREF.getFieldValue(), true);
                this.m_szDistListHREF = XMLUtilities.getPCData(hrefelement);
            }
            this.initialize();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            if (!this.m_bInitializeCalled) {
                this.initialize();
            }
            if (this.m_hMemberElements != null) {
                return this.m_hMemberElements.size();
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws ExWebDavPimException {
        try {
            if (!this.m_bInitializeCalled) {
                this.initialize();
            }
            if (this.m_hMemberElements == null || itemNumber >= this.getCount()) {
                return null;
            }
            Object key = this.m_hMemberElements.keySet().toArray()[itemNumber];
            return new ExWebDavPimOldDistListMemberItem(this.getPimSession(), this, (Element)this.m_hMemberElements.get(key));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws ExWebDavPimException {
        try {
            Element memberElement;
            if (!this.m_bInitializeCalled) {
                this.initialize();
            }
            if ((memberElement = (Element)this.m_hMemberElements.get(id)) != null) {
                return new ExWebDavPimOldDistListMemberItem(this.getPimSession(), this, memberElement);
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public synchronized void deleteMember(String id) throws ExWebDavPimException {
        try {
            this.initialize();
            Element memberElement = (Element)this.m_hMemberElements.get(id);
            if (memberElement != null) {
                String memberId = XMLUtilities.getPCData(XMLUtilities.getFirstMatch(memberElement, "memberid"));
                NVPair[] body = new NVPair[]{new NVPair(HTTPField.COMMAND.getFieldName(), HTTPFieldValue.DELETE_MEMBER.getFieldValue()), new NVPair(HTTPField.MSGCLASS.getFieldName(), HTTPFieldValue.IPM_DISTLIST.getFieldValue()), new NVPair(HTTPField.MEMBER_ID.getFieldName(), memberId)};
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestAsPostReturnAsXml(this.getDistListHREF(), body);
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimSortType getSortType() throws ExWebDavPimException {
        return m_oPimSortType;
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws ExWebDavPimException {
        if (pimFieldType != null) {
            this.m_oOrderBy = new PimFieldType[pimFieldType.length];
            int i = 0;
            while (i < pimFieldType.length) {
                if (pimFieldType[i] != null) {
                    this.m_oOrderBy[i] = pimFieldType[i];
                }
                ++i;
            }
        }
    }

    public PimFieldType[] getOrderBy() {
        if (this.m_oOrderBy == null || this.m_oOrderBy.length == 0) {
            this.m_oOrderBy = new PimFieldType[1];
            this.m_oOrderBy[0] = m_oDefaultPimFieldType;
        }
        return this.m_oOrderBy;
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }
}

