/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimAccessLevelType;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimMeetingItemResponseType;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAddressEntryItemFinder;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimBusyStatusTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMeetingItemResponseTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTimeZoneTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavMapiFieldHelper;
import com.aligo.pim.exchangewebdav.util.WebDavPimUtility;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldAppointmentItem
extends ExWebDavPimMessageItem
implements ExWebDavPimAppointmentItem {
    private Element m_oElement;
    private ExWebDavPimFolder m_oPimFolder;
    private PimCalendarType m_oPimCalendarType;
    private PimBusyStatusType m_oPimBusyStatusType;
    private WebDavDate m_oStartTime;
    private WebDavDate m_oEndTime;
    private boolean m_bIsAllDayEvent;
    private String m_szText;
    private PimImportanceType m_oPimImportanceType;
    private String m_szLocation;
    private String m_szSubject;
    private ExWebDavPimRecurrencePatternItem m_oPimRecurrencePatternItem;
    private ExWebDavPimReminderItem m_oPimReminderItem;
    private boolean m_bIsUpdateDone;
    ExWebDavPimRecipientItems pimRecipientItems;

    public ExWebDavPimOldAppointmentItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder, Element element) throws ExWebDavPimException {
        super(pimSession);
        this.m_oElement = element;
        this.m_oPimFolder = pimFolder;
        this.isAllDayEvent();
    }

    public ExWebDavPimFolder getPimFolder() {
        return this.m_oPimFolder;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimFolder().getFullFolderName();
    }

    public PimReminderItem getReminderItem() throws ExWebDavPimException {
        try {
            return this.addReminderItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimReminderItem addReminderItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String reminderOffset = XMLUtilities.getValue(this.m_oElement, WebDavField.REMINDEROFFSET);
                this.m_oPimReminderItem = reminderOffset == null ? new ExWebDavPimNewReminderItem() : new ExWebDavPimOldReminderItem(reminderOffset);
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                String instanceType = XMLUtilities.getValue(this.m_oElement, WebDavField.INSTANCETYPE);
                if (instanceType.equals("0")) {
                    return null;
                }
                if (instanceType.equals("2")) {
                    String calendarUID = XMLUtilities.getValue(this.m_oElement, WebDavField.CALENDARUID);
                    ExWebDavPimMessageItemsCache cache = new ExWebDavPimMessageItemsCache(this.getPimSession());
                    String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<DAV:searchrequest xmlns:DAV=\"DAV:\">\n    <DAV:sql>SELECT  &quot;DAV:uid&quot;,&quot;urn:schemas:httpmail:subject&quot;,&quot;urn:schemas:httpmail:textdescription&quot;,&quot;urn:schemas:mailheader:priority&quot;,&quot;urn:schemas:calendar:location&quot;,&quot;urn:schemas:calendar:instancetype&quot;,&quot;urn:schemas:calendar:rrule&quot;,&quot;xml:v&quot;,&quot;urn:schemas:calendar:exdate&quot;,&quot;urn:schemas:calendar:method&quot;,&quot;urn:schemas:calendar:dtend&quot;,&quot;urn:schemas:calendar:dtstart&quot;,&quot;urn:schemas:calendar:reminderoffset&quot;,&quot;urn:schemas:calendar:alldayevent&quot;,&quot;urn:schemas:calendar:busystatus&quot;,&quot;urn:schemas:calendar:responserequested&quot;,&quot;urn:schemas:calendar:meetingstatus&quot;,&quot;http://schemas.microsoft.com/exchange/outlookmessageclass&quot;,&quot;DAV:contentclass&quot;,&quot;DAV:displayname&quot;,&quot;urn:schemas:calendar:duration&quot;,&quot;urn:schemas:calendar:uid&quot;,&quot;urn:schemas:mailheader:to&quot;,&quot;http://schemas.microsoft.com/mapi/id/{00062002-0000-0000-C000-000000000046}/0x8218&quot;,&quot;DAV:href&quot;,&quot;urn:schemas:calendar:organizer&quot; FROM &quot;" + this.getFolderName() + "&quot; WHERE ((&quot;http://schemas.microsoft.com/exchange/outlookmessageclass&quot;='IPM.Appointment' OR &quot;DAV:contentclass&quot;='urn:content-classes:appointment') AND (&quot;urn:schemas:calendar:instancetype&quot;=1) AND &quot;urn:schemas:calendar:uid&quot;='" + calendarUID + "') ORDER BY &quot;http://schemas.microsoft.com/exchange/outlookmessageclass&quot; ASC , &quot;DAV:contentclass&quot; ASC</DAV:sql>\n" + "</DAV:searchrequest>";
                    ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
                    getAllItemsReqRes.setRequestXml(xml);
                    getAllItemsReqRes.setRequestMethod("SEARCH");
                    getAllItemsReqRes.setRequestFolder(this.getFolderName());
                    getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
                    cache.setAllItemsReqRes(getAllItemsReqRes);
                    Element master = cache.getElement(0);
                    if (master == null) {
                        return null;
                    }
                    Element recurStringElement = XMLUtilities.getValueAsElement(master, WebDavField.RRULE);
                    Element exDateElement = XMLUtilities.getValueAsElement(master, WebDavField.EXDATE);
                    if (recurStringElement != null) {
                        String recurrenceString = XMLUtilities.getValue(recurStringElement, WebDavField.V);
                        if (recurrenceString == null) {
                            this.m_oPimRecurrencePatternItem = new ExWebDavPimNewRecurrencePatternItem(this);
                        } else {
                            this.m_oPimRecurrencePatternItem = new ExWebDavPimOldRecurrencePatternItem(recurrenceString, this);
                            if (exDateElement != null) {
                                int numOfElements = XMLUtilities.getNumOfElements(exDateElement, WebDavField.V);
                                Vector<Date> exDateV = new Vector<Date>();
                                int i = 0;
                                while (i < numOfElements) {
                                    String exDate = XMLUtilities.getValue(exDateElement, WebDavField.V, i);
                                    WebDavDate webDavDate = new WebDavDate(exDate, this.getPimSession());
                                    exDateV.add(webDavDate.getDate());
                                    ++i;
                                }
                                if (exDateV.size() > 0) {
                                    this.m_oPimRecurrencePatternItem.setExceptionDates(exDateV);
                                }
                            }
                        }
                    }
                }
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.SUBJECT);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private String getCalendarUid() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.CALENDARUID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.UID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExWebDavPimException {
        try {
            String importance = XMLUtilities.getValue(this.m_oElement, WebDavField.IMPORTANCE);
            if (importance == null) {
                return PimImportanceType.NORMAL;
            }
            return ExWebDavPimImportanceTypeMapper.getType(importance);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAccessLevelType getAccessLevel() throws PimException {
        return null;
    }

    public PimAddressEntryItem getSender() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getDuration() throws ExWebDavPimException {
        try {
            String duration = XMLUtilities.getValue(this.m_oElement, WebDavField.DURATION);
            if (duration == null) {
                return 0;
            }
            long lduration = Long.parseLong(duration);
            return (int)(lduration / 60L);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLocation() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.LOCATION);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getText() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.TEXTDESCRIPTION);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartTime() throws ExWebDavPimException {
        try {
            return this.getWebDavStartTime().getDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public WebDavDate getWebDavEndTime() throws ExWebDavPimException {
        String dtEnd = XMLUtilities.getValue(this.m_oElement, WebDavField.DTEND);
        WebDavDate webDavEndDate = new WebDavDate(dtEnd, this.getPimSession());
        return webDavEndDate;
    }

    public WebDavDate getWebDavStartTime() throws ExWebDavPimException {
        String dtStart = XMLUtilities.getValue(this.m_oElement, WebDavField.DTSTART);
        WebDavDate webDavStartDate = new WebDavDate(dtStart, this.getPimSession());
        return webDavStartDate;
    }

    public Date getEndTime() throws ExWebDavPimException {
        try {
            return this.getWebDavEndTime().getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean isAllDayEvent() throws ExWebDavPimException {
        try {
            String allDayEvent = XMLUtilities.getValue(this.m_oElement, WebDavField.ALLDAYEVENT);
            this.m_bIsAllDayEvent = allDayEvent.equals("1");
            return this.m_bIsAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        try {
            this.m_szSubject = subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setLocation(String location) throws ExWebDavPimException {
        try {
            this.m_szLocation = location;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setImportance(PimImportanceType importance) throws ExWebDavPimException {
        try {
            this.m_oPimImportanceType = importance;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setAccessLevel(PimAccessLevelType accessLevelType) throws PimException {
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws ExWebDavPimException {
        try {
            this.m_oPimBusyStatusType = pimBusyStatusType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        try {
            this.m_szText = text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStartTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oStartTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setEndTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oEndTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
        try {
            this.getPimSession().getHttpConnector().delete(this.getFileName());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimAddressEntryItem getOrganizer() throws ExWebDavPimException {
        String organizer = XMLUtilities.getValue(this.m_oElement, WebDavField.ORGANIZER);
        int start = organizer.indexOf("<");
        int end = organizer.indexOf(">");
        if (start != -1 && end != -1) {
            organizer = organizer.substring(start + 1, end);
        }
        return ExWebDavPimAddressEntryItemFinder.searchFromGABWithEmailAddress(organizer, this.getPimSession());
    }

    public void setMeetingStatus(int meetingStatus) throws ExWebDavPimException {
    }

    public void setAllDayEvent(boolean isAllDayEvent) throws ExWebDavPimException {
        try {
            this.m_bIsAllDayEvent = isAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void checkValidity() throws ExWebDavPimException {
        Date startTime = new Date();
        Date endTime = new Date();
        endTime = this.m_oEndTime == null ? this.getEndTime() : this.m_oEndTime.getDate();
        int result = endTime.compareTo(startTime = this.m_oStartTime == null ? this.getStartTime() : this.m_oStartTime.getDate());
        if (result < 0) {
            throw new ExWebDavPimException(13L);
        }
    }

    private Vector fillCommonPropertites(Vector toSend, boolean meeting) throws ExWebDavPimException {
        try {
            this.checkValidity();
            if (this.m_szSubject != null) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject));
            } else if (meeting) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.getSubject()));
            }
            if (this.m_szText != null) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szText));
            } else if (meeting) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.getText()));
            }
            if (this.m_oPimImportanceType != null) {
                toSend.add(new PropertyHolder(WebDavField.IMPORTANCE, ExWebDavPimImportanceTypeMapper.getType(this.m_oPimImportanceType)));
            } else if (meeting) {
                toSend.add(new PropertyHolder(WebDavField.IMPORTANCE, ExWebDavPimImportanceTypeMapper.getType(this.getImportance())));
            }
            if (this.m_szLocation != null) {
                toSend.add(new PropertyHolder(WebDavField.LOCATION, this.m_szLocation));
            } else if (meeting) {
                toSend.add(new PropertyHolder(WebDavField.LOCATION, this.getLocation()));
            }
            if (this.m_oPimRecurrencePatternItem == null) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "0"));
            } else {
                ExWebDavPimNewRecurrencePatternItem pimRecurrencePatternItem = (ExWebDavPimNewRecurrencePatternItem)this.m_oPimRecurrencePatternItem;
                if (pimRecurrencePatternItem.isItRecurringItem()) {
                    toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "2"));
                    String recurrenceString = pimRecurrencePatternItem.getRecurrencePatternString();
                    PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                    toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                    Vector exceptionDates = this.m_oPimRecurrencePatternItem.getExceptionDates();
                    if (exceptionDates != null) {
                        Vector<PropertyHolder> properties = new Vector<PropertyHolder>();
                        int i = 0;
                        while (i < exceptionDates.size()) {
                            WebDavDate webDavDate = new WebDavDate((Date)exceptionDates.elementAt(i), this.getPimSession());
                            properties.add(new PropertyHolder(WebDavField.V, webDavDate.getFormattedDate()));
                            ++i;
                        }
                        toSend.add(new PropertyHolder(WebDavField.EXDATE, properties));
                    }
                }
            }
            if (!meeting) {
                if (!this.m_bIsAllDayEvent) {
                    if (this.m_oEndTime != null) {
                        toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                    }
                    if (this.m_oStartTime != null) {
                        toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                    }
                    if (this.m_oPimReminderItem != null && this.m_oPimReminderItem.isReminderSet()) {
                        toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, this.m_oPimReminderItem.getNoOfSecondsBeforeStart() + ""));
                    }
                    if (this.m_oPimBusyStatusType == null) {
                        toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "BUSY"));
                    }
                    toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "0"));
                } else {
                    if (this.m_oEndTime != null) {
                        this.m_oEndTime.resetToNextDay();
                        toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                    }
                    if (this.m_oStartTime != null) {
                        this.m_oStartTime.resetToThisDay();
                        toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                    }
                    toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "1"));
                    if (this.m_oPimBusyStatusType == null) {
                        toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "FREE"));
                    }
                    toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, "0"));
                }
            } else if (!this.isAllDayEvent()) {
                ExWebDavPimNewReminderItem exWebDavPimNewReminderItem;
                ExWebDavPimOldReminderItem exWebDavPimOldReminderItem;
                toSend.add(new PropertyHolder(WebDavField.DTEND, this.getWebDavEndTime().getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.DTSTART, this.getWebDavStartTime().getFormattedDate()));
                PimReminderItem pimReminderItem = this.getReminderItem();
                if (pimReminderItem instanceof ExWebDavPimOldReminderItem && (exWebDavPimOldReminderItem = (ExWebDavPimOldReminderItem)this.getReminderItem()) != null && exWebDavPimOldReminderItem.isReminderSet()) {
                    toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, exWebDavPimOldReminderItem.getNoOfSecondsBeforeStart() + ""));
                }
                if (pimReminderItem instanceof ExWebDavPimNewReminderItem && (exWebDavPimNewReminderItem = (ExWebDavPimNewReminderItem)this.getReminderItem()) != null && exWebDavPimNewReminderItem.isReminderSet()) {
                    toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, exWebDavPimNewReminderItem.getNoOfSecondsBeforeStart() + ""));
                }
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "BUSY"));
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "0"));
            } else {
                WebDavDate endDate = this.getWebDavEndTime();
                endDate.resetToNextDay();
                toSend.add(new PropertyHolder(WebDavField.DTEND, endDate.getFormattedDate()));
                WebDavDate startDate = this.getWebDavEndTime();
                startDate.resetToThisDay();
                toSend.add(new PropertyHolder(WebDavField.DTSTART, startDate.getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "1"));
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "FREE"));
            }
            if (this.m_oPimBusyStatusType != null) {
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, ExWebDavPimBusyStatusTypeMapper.getType(this.m_oPimBusyStatusType)));
            }
            return toSend;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private Vector fillMeetingProperties(Vector toSend) {
        toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "CONFIRMED"));
        toSend.add(new PropertyHolder(WebDavField.RESPONSEREQUESTED, "1"));
        toSend.add(new PropertyHolder(WebDavField.FINVITED, "1"));
        return toSend;
    }

    private Vector fillInvitees(Vector toSend) throws ExWebDavPimException {
        try {
            PimRecipientItems pimRecipientItems = this.getRecipientItems();
            PimRecipientItem pimRecipientItem = pimRecipientItems.getFirstRecipientItem();
            StringBuffer email = new StringBuffer();
            boolean first = true;
            while (pimRecipientItem != null) {
                String emailAddress = pimRecipientItem.getEmailAddress();
                if (emailAddress == null) {
                    emailAddress = pimRecipientItem.getAddressEntryItem().getEmailAddress();
                }
                if (first) {
                    first = false;
                } else {
                    email.append(";");
                }
                email.append(emailAddress);
                pimRecipientItem = pimRecipientItems.getNextRecipientItem();
            }
            toSend.add(new PropertyHolder(WebDavField.HEADER_TO, email.toString()));
            return toSend;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void update() throws ExWebDavPimException {
        try {
            this.m_bIsUpdateDone = false;
            Vector toSend = new Vector();
            toSend = this.fillCommonPropertites(toSend, false);
            this.m_oPimCalendarType = this.getType();
            if (this.m_oPimCalendarType != null) {
                if (this.m_oPimCalendarType.equals(PimCalendarType.APPOINTMENT)) {
                    toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "TENTATIVE"));
                } else if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                    toSend = this.fillMeetingProperties(toSend);
                    toSend = this.fillInvitees(toSend);
                }
            }
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            String fileName = this.getFileName();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", fileName, xmlString);
            this.m_bIsUpdateDone = true;
            if (this.m_oPimCalendarType != null && this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                this.createMeetingRequest();
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void createMeetingRequest() throws ExWebDavPimException {
        try {
            Vector toSend = new Vector();
            toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.Schedule.Meeting.Request"));
            toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:calendarmessage"));
            toSend = this.fillCommonPropertites(toSend, true);
            String timeZoneId = ExWebDavPimTimeZoneTypeMapper.getType(this.getPimSession().getTimeZone());
            toSend.add(new PropertyHolder(WebDavField.TIMEZONEID, timeZoneId));
            toSend.add(new PropertyHolder(WebDavField.CALENDARUID, this.getCalendarUid()));
            toSend = this.fillInvitees(toSend);
            if (this.m_oPimRecurrencePatternItem == null) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "0"));
            } else {
                ExWebDavPimNewRecurrencePatternItem pimRecurrencePatternItem = (ExWebDavPimNewRecurrencePatternItem)this.m_oPimRecurrencePatternItem;
                if (pimRecurrencePatternItem.isItRecurringItem()) {
                    toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "1"));
                    String recurrenceString = pimRecurrencePatternItem.getRecurrencePatternString();
                    PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                    toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                    Vector exceptionDates = this.m_oPimRecurrencePatternItem.getExceptionDates();
                    if (exceptionDates != null) {
                        Vector<PropertyHolder> properties = new Vector<PropertyHolder>();
                        int i = 0;
                        while (i < exceptionDates.size()) {
                            WebDavDate webDavDate = new WebDavDate((Date)exceptionDates.elementAt(i), this.getPimSession());
                            properties.add(new PropertyHolder(WebDavField.V, webDavDate.getFormattedDate()));
                            ++i;
                        }
                        toSend.add(new PropertyHolder(WebDavField.EXDATE, properties));
                    }
                }
            }
            toSend.add(new PropertyHolder(WebDavField.RESPONSESTATUS, "1"));
            toSend.add(new PropertyHolder(WebDavField.RESPONSESTATE, "0"));
            toSend.add(new PropertyHolder(WebDavField.APPTSTATEFLAGS, "3"));
            toSend.add(new PropertyHolder(WebDavField.MAPI_BUSYSTATUS, "1"));
            toSend.add(new PropertyHolder(WebDavField.MAPI_INTENDEBUSYSTATUS, "2"));
            toSend.add(new PropertyHolder(WebDavField.RESPONSEREQUESTED, "1"));
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            String uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getFolderName(), this.m_szSubject == null ? this.getSubject() : this.m_szSubject);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                response = this.getPimSession().getHttpConnector().move(uniqueFileName, this.getPimSession().getPimFolderType().getMailSubmissionURI(this.getPimSession()));
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private String getFileName() throws ExWebDavPimException {
        try {
            return this.getFolderName() + "/" + XMLUtilities.getValue(this.m_oElement, WebDavField.DISPLAYNAME);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        try {
            if (this.pimRecipientItems == null) {
                this.pimRecipientItems = new ExWebDavPimOldRecipientItems(this.getPimSession());
                String to = XMLUtilities.getValue(this.m_oElement, WebDavField.HEADER_TO);
                if (to != null) {
                    WebDavPimUtility.parseAndAddRecipients(this.getPimSession(), this.pimRecipientItems, to, PimRecipientType.TO);
                }
            }
            return this.pimRecipientItems;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public void setType(PimCalendarType pimCalendarType) throws ExWebDavPimException {
        this.m_oPimCalendarType = pimCalendarType;
    }

    public PimCalendarType getType() throws ExWebDavPimException {
        try {
            String meetingStatus = XMLUtilities.getValue(this.m_oElement, WebDavMapiFieldHelper.getReplaceWebDavField(WebDavField.MAPI_RESPONSESTATUS));
            if (meetingStatus == null || meetingStatus != null && meetingStatus.equals(ExWebDavPimMeetingItemResponseTypeMapper.getType(PimMeetingItemResponseType.NONE))) {
                return PimCalendarType.APPOINTMENT;
            }
            return PimCalendarType.MEETING;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStatus(PimMeetingItemResponseType pimMeetingItemResponseType) throws PimException {
    }

    public PimMeetingItemResponseType getStatus() throws PimException {
        return null;
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        return "Appointment: " + this.getSubject() + " in " + this.getLocation();
    }
}

