/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAttachmentItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.ExWebDavPimTaskItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimTaskItemFilter;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimNewTaskItem
extends ExWebDavPimMessageItem
implements ExWebDavPimTaskItem {
    private boolean m_bIsItNew;
    private ExWebDavPimAttachmentItems m_oPimAttachmentItems;
    private String m_szSubject = "";
    private String m_szText = "";
    private PimTaskStatusType m_oPimTaskStatusType = PimTaskStatusType.NOT_COMPLETE;
    private ExWebDavPimFolder m_oPimFolder;
    private boolean m_bIsUpdateDone;
    private String m_szUniqueFileName = "";
    private String taskUid;
    private WebDavDate m_oStartTime;
    private WebDavDate m_oDueTime;

    public ExWebDavPimNewTaskItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder) {
        super(pimSession);
        this.m_oPimFolder = pimFolder;
    }

    private ExWebDavPimFolder getPimFolder() {
        return this.m_oPimFolder;
    }

    private String getFolderName() throws ExWebDavPimException {
        return this.getPimFolder().getFullFolderName();
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            if (this.m_bIsUpdateDone) {
                if (this.m_szUniqueFileName != null) {
                    Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
                    String fromString = this.getFolderName();
                    ExWebDavPimTaskItemFilter pimTaskItemFilter = new ExWebDavPimTaskItemFilter(this.getPimSession());
                    pimTaskItemFilter.setDisplayName(this.m_szUniqueFileName);
                    String whereString = pimTaskItemFilter.getWhereString();
                    Vector<WebDavField> fieldsVector = new Vector<WebDavField>();
                    fieldsVector.add(WebDavField.UID);
                    fieldsVector.add(WebDavField.DISPLAYNAME);
                    int i = 0;
                    while (i < fieldsVector.size()) {
                        selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                        ++i;
                    }
                    String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
                    int numOfElements = XMLUtilities.getNumOfElements(response.getText(), WebDavField.RESPONSE);
                    Element element = null;
                    int i2 = 0;
                    while (i2 < numOfElements) {
                        String displayName;
                        element = XMLUtilities.getValueAsElement(response.getText(), WebDavField.RESPONSE, i2);
                        if (element != null && (displayName = XMLUtilities.getValue(element, WebDavField.DISPLAYNAME)).equals(this.m_szUniqueFileName)) break;
                        ++i2;
                    }
                    if (element == null) {
                        return null;
                    }
                    String id = XMLUtilities.getValue(element, WebDavField.UID);
                    return id;
                }
            } else {
                return null;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        try {
            this.m_szSubject = subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            return this.m_szSubject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        try {
            this.m_szText = text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getText() throws ExWebDavPimException {
        try {
            return this.m_szText;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate getWebDavStartTime() throws ExWebDavPimException {
        return this.m_oStartTime;
    }

    public WebDavDate getWebDavDueTime() throws ExWebDavPimException {
        return this.m_oDueTime;
    }

    public void setStartDate(Date startDate) throws ExWebDavPimException {
        try {
            if (startDate != null) {
                this.m_oStartTime = new WebDavDate(startDate, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartDate() throws ExWebDavPimException {
        try {
            if (this.m_oStartTime != null) {
                return this.m_oStartTime.getDate();
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setDueDate(Date dueDate) throws ExWebDavPimException {
        try {
            if (dueDate != null) {
                this.m_oDueTime = new WebDavDate(dueDate, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getDueDate() throws ExWebDavPimException {
        try {
            if (this.m_oDueTime != null) {
                return this.m_oDueTime.getDate();
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        try {
            return "Task Item: " + this.getSubject();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws PimException {
        try {
            this.m_oPimTaskStatusType = pimTaskStatusType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimTaskStatusType getStatus() throws PimException {
        try {
            return this.m_oPimTaskStatusType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void checkValidity() throws ExWebDavPimException {
        if (this.m_oStartTime != null && this.m_oDueTime != null && !this.m_oDueTime.after(this.m_oStartTime) && !this.m_oDueTime.equals(this.m_oStartTime)) {
            throw new ExWebDavPimException(13L);
        }
    }

    public void update() throws ExWebDavPimException {
        try {
            this.update(true, true);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void update(boolean makePermanent, boolean refreshObject) throws ExWebDavPimException {
        try {
            this.checkValidity();
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            if (this.m_szSubject != null) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject));
            }
            if (this.m_szText != null) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szText));
            }
            if (this.m_oDueTime != null) {
                this.m_oDueTime.resetToThisDay();
                toSend.add(new PropertyHolder(WebDavField.TASK_END_DATE, this.m_oDueTime.getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.COMMON_TASK_END_DATE, this.m_oDueTime.getFormattedDate()));
            }
            if (this.m_oStartTime != null) {
                this.m_oStartTime.resetToThisDay();
                toSend.add(new PropertyHolder(WebDavField.TASK_START_DATE, this.m_oStartTime.getFormattedDate()));
                toSend.add(new PropertyHolder(WebDavField.COMMON_TASK_START_DATE, this.m_oStartTime.getFormattedDate()));
            }
            if (this.m_oPimTaskStatusType != null) {
                if (this.m_oPimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                    if (this.getStatus().equals(PimTaskStatusType.NOT_COMPLETE)) {
                        toSend.add(new PropertyHolder(WebDavField.TASK_COMPLETE, "1"));
                        toSend.add(new PropertyHolder(WebDavField.TASK_PERCENTAGE_COMPLETE, "1.0"));
                        toSend.add(new PropertyHolder(WebDavField.TASK_STATUS, "2"));
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(new Date());
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        WebDavDate webDavDate = new WebDavDate(cal.getTime(), this.getPimSession());
                        toSend.add(new PropertyHolder(WebDavField.TASK_DATE_COMPLETED, webDavDate.getFormattedDate()));
                    }
                } else if (this.getStatus().equals(PimTaskStatusType.COMPLETE)) {
                    toSend.add(new PropertyHolder(WebDavField.TASK_COMPLETE, "0"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_PERCENTAGE_COMPLETE, "0.0"));
                    toSend.add(new PropertyHolder(WebDavField.TASK_STATUS, "0"));
                }
            } else {
                toSend.add(new PropertyHolder(WebDavField.TASK_COMPLETE, "0"));
            }
            toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.Task"));
            toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:task"));
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            String uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getFolderName(), this.m_szSubject);
            this.m_szUniqueFileName = uniqueFileName.substring(uniqueFileName.lastIndexOf("/") + 1, uniqueFileName.length());
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            this.m_bIsUpdateDone = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void delete(boolean flag) throws ExWebDavPimException {
    }
}

