/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternMonthType;
import com.aligo.pim.PimRecurrencePatternNthType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimNthRecurParameter;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternDayTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternMonthTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRecurrencePatternNthTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimYearlyRecurParameter;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.util.RecurrenceUtil;
import java.util.Date;
import java.util.Vector;

public class ExWebDavPimNewRecurrencePatternItem
extends ExWebDavPimItem
implements ExWebDavPimRecurrencePatternItem {
    private ExWebDavPimAppointmentItem m_oPimAppointmentItem;
    private PimRecurrencePatternType m_oPimRecurrencePatternType;
    private int m_iInterval;
    private Vector m_vDaysOfMonth;
    private int m_iNoOfOccurences = -1;
    private WebDavDate m_oRecurrenceEndDate;
    private boolean m_bIsUpdateCalled;
    private Vector m_vDaysOfWeek;
    private String m_szRecurrencePatternString;
    private ExWebDavPimNthRecurParameter m_oPimNthRecurParameter;
    private ExWebDavPimYearlyRecurParameter m_oPimYearlyRecurParameter;
    private PimRecurrencePatternDayType m_oPimRecurrencePatternDayType;
    private Vector m_vExceptionDates = null;
    private PimRecurrencePatternNthType m_oPimNthType;
    private PimRecurrencePatternMonthType m_oPimMonthType;
    private PimRecurrencePatternDayType m_oPimDayType;

    public ExWebDavPimNewRecurrencePatternItem(ExWebDavPimAppointmentItem pimAppointmentItem) {
        super(pimAppointmentItem.getPimSession());
        this.m_oPimAppointmentItem = pimAppointmentItem;
    }

    public ExWebDavPimAppointmentItem getPimAppointmentItem() {
        return this.m_oPimAppointmentItem;
    }

    public String getRecurrencePatternString() {
        return this.m_szRecurrencePatternString;
    }

    public void setType(PimRecurrencePatternType pimRecurrencePatternType) throws PimException {
        try {
            if (pimRecurrencePatternType != null) {
                this.m_oPimRecurrencePatternType = pimRecurrencePatternType;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setInterval(int interval) throws PimException {
        try {
            if (interval > 0) {
                this.m_iInterval = interval;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setDaysOfWeek(Vector daysOfWeek) throws PimException {
        try {
            if (daysOfWeek == null) {
                throw new ExWebDavPimException(55L);
            }
            if (daysOfWeek.size() > 0) {
                Vector tempVector = new Vector();
                int i = 0;
                while (i < daysOfWeek.size()) {
                    Object obj = daysOfWeek.elementAt(i);
                    if (!(obj instanceof PimRecurrencePatternDayType)) {
                        throw new ExWebDavPimException(55L);
                    }
                    int repeatIndex = daysOfWeek.lastIndexOf(obj);
                    if (i == repeatIndex) {
                        tempVector.add(obj);
                    }
                    ++i;
                }
                this.m_vDaysOfWeek = tempVector;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(55L);
        }
    }

    public void setDaysOfMonth(Vector daysOfMonth) throws PimException {
        try {
            if (daysOfMonth == null) {
                throw new ExWebDavPimException(56L);
            }
            if (daysOfMonth.size() > 0) {
                Vector<Integer> tempVector = new Vector<Integer>();
                int i = 0;
                while (i < daysOfMonth.size()) {
                    int dayOfMonth = (Integer)daysOfMonth.elementAt(i);
                    if (dayOfMonth <= 0 || dayOfMonth > 31) {
                        throw new ExWebDavPimException(56L);
                    }
                    int repeatIndex = daysOfMonth.lastIndexOf(new Integer(dayOfMonth));
                    if (i == repeatIndex) {
                        tempVector.add(new Integer(dayOfMonth));
                    }
                    ++i;
                }
                this.m_vDaysOfMonth = tempVector;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(56L);
        }
    }

    public void setNoOfOccurrences(int noOfOccurrences) throws PimException {
        try {
            this.m_iNoOfOccurences = noOfOccurrences;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setNoOfInstances(int noOfInstances) throws PimException {
        this.setNoOfOccurrences(noOfInstances);
    }

    public void setRecurrenceEndDate(Date endDate) throws PimException {
        try {
            if (endDate != null) {
                this.m_oRecurrenceEndDate = new WebDavDate(endDate, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setExceptionDates(Vector exceptionDates) throws ExWebDavPimException {
        try {
            if (exceptionDates != null && exceptionDates.size() > 0) {
                int i = 0;
                while (i < exceptionDates.size()) {
                    Date exceptionDate = (Date)exceptionDates.elementAt(i);
                    if (exceptionDate == null) {
                        throw new ExWebDavPimException(28L);
                    }
                    ++i;
                }
                this.m_vExceptionDates = exceptionDates;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(28L);
        }
    }

    public Vector getExceptionDates() throws ExWebDavPimException {
        try {
            return this.m_vExceptionDates;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createDailyEveryNDays(Date recurrenceEndDate, int nDays) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setInterval(nDays);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createDailyEveryNDays(int noOfOccurrences, int nDays) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nDays);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(Date recurrenceEndDate, int nWeeks, Vector daysOfWeek) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createWeeklyNoOfInstances(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws PimException {
        this.createWeeklyEveryNWeeks(noOfOccurrences, nWeeks, daysOfWeek);
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, int nMonths, Vector daysOfMonth) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createMonthlyEveryNMonths(int noOfOccurrences, int nMonths, Vector daysOfMonth) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createYearlyTheNthDayOfMonth(int noOfOccurences, PimRecurrencePatternNthType pimRecurrencePatternNthType, PimRecurrencePatternDayType pimRecurrencePatternDayType, PimRecurrencePatternMonthType pimRecurrencePatternMonthType) throws PimException {
        this.setType(PimRecurrencePatternType.YEARLY);
        this.setNoOfOccurrences(noOfOccurences);
        this.setNthType(pimRecurrencePatternNthType);
        this.setDayType(pimRecurrencePatternDayType);
        this.setMonthType(pimRecurrencePatternMonthType);
    }

    public void createYearlyTheNthDayOfMonth(Date recurrenceEndDate, PimRecurrencePatternNthType pimRecurrencePatternNthType, PimRecurrencePatternDayType pimRecurrencePatternDayType, PimRecurrencePatternMonthType pimRecurrencePatternMonthType) throws PimException {
        this.setType(PimRecurrencePatternType.YEARLY);
        this.setRecurrenceEndDate(recurrenceEndDate);
        this.setNthType(pimRecurrencePatternNthType);
        this.setDayType(pimRecurrencePatternDayType);
        this.setMonthType(pimRecurrencePatternMonthType);
    }

    public void createYearlyEveryNYears(Date recurrenceEndDate, int nYears) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setInterval(nYears);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createYearlyEveryNYears(int noOfOccurrences, int nYears) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nYears);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createYearly(int noOfOccurences, ExWebDavPimNthRecurParameter nthParam, PimRecurrencePatternDayType dayInstance, ExWebDavPimYearlyRecurParameter yearInstance) throws ExWebDavPimException {
        try {
            this.setNoOfOccurrences(noOfOccurences);
            this.setType(PimRecurrencePatternType.YEARLY);
            this.m_oPimNthRecurParameter = nthParam;
            this.m_oPimRecurrencePatternDayType = dayInstance;
            this.m_oPimYearlyRecurParameter = yearInstance;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void createYearly(Date recurrenceEndDate, ExWebDavPimNthRecurParameter nthParam, PimRecurrencePatternDayType dayInstance, ExWebDavPimYearlyRecurParameter yearInstance) throws ExWebDavPimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setRecurrenceEndDate(recurrenceEndDate);
            this.m_oPimNthRecurParameter = nthParam;
            this.m_oPimRecurrencePatternDayType = dayInstance;
            this.m_oPimYearlyRecurParameter = yearInstance;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean isItRecurringItem() throws ExWebDavPimException {
        return this.m_bIsUpdateCalled;
    }

    private void doValidityCheck() throws ExWebDavPimException {
        try {
            WebDavDate oStartTime = this.getPimAppointmentItem().getWebDavStartTime();
            if (oStartTime == null) {
                throw new ExWebDavPimException(59L);
            }
            WebDavDate oEndTime = this.getPimAppointmentItem().getWebDavEndTime();
            if (oEndTime == null) {
                throw new ExWebDavPimException(59L);
            }
            if (!oEndTime.after(oStartTime) && !oEndTime.equals(oStartTime)) {
                throw new ExWebDavPimException(13L);
            }
            if (this.m_oRecurrenceEndDate != null && !this.m_oRecurrenceEndDate.after(oEndTime)) {
                throw new ExWebDavPimException(61L);
            }
            if (this.m_oPimRecurrencePatternType == null) {
                throw new ExWebDavPimException(60L);
            }
            if (this.m_vDaysOfMonth == null) {
                this.m_vDaysOfMonth = new Vector();
            }
            if (this.m_iInterval < 1) {
                this.m_iInterval = 1;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setPimNthRecurParameter(ExWebDavPimNthRecurParameter nthParam) {
        this.m_oPimNthRecurParameter = nthParam;
    }

    public void setNthType(PimRecurrencePatternNthType pimRecurrencePatternNthType) {
        this.m_oPimNthType = pimRecurrencePatternNthType;
    }

    public void setDayType(PimRecurrencePatternDayType pimRecurrencePatternDayType) {
        this.m_oPimDayType = pimRecurrencePatternDayType;
    }

    public void setMonthType(PimRecurrencePatternMonthType pimRecurrencePatternMonthType) throws PimException {
        this.m_oPimMonthType = pimRecurrencePatternMonthType;
    }

    public void setPimRecurrencePatternDayType(PimRecurrencePatternDayType dayInstance) {
        this.m_oPimRecurrencePatternDayType = dayInstance;
    }

    public void setPimYearlyRecurParameter(ExWebDavPimYearlyRecurParameter pimYearlyRecurParameter) {
        this.m_oPimYearlyRecurParameter = pimYearlyRecurParameter;
    }

    public void createMonthlyEveryNMonths(int noOfOccurrences, ExWebDavPimNthRecurParameter nthParam, PimRecurrencePatternDayType dayInstance, int interval) throws PimException {
        this.setType(PimRecurrencePatternType.MONTHLY);
        this.setNoOfOccurrences(noOfOccurrences);
        this.setInterval(interval);
        this.m_oPimNthRecurParameter = nthParam;
        this.m_oPimRecurrencePatternDayType = dayInstance;
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, ExWebDavPimNthRecurParameter nthParam, PimRecurrencePatternDayType dayInstance, int interval) throws PimException {
        this.setType(PimRecurrencePatternType.MONTHLY);
        this.setRecurrenceEndDate(recurrenceEndDate);
        this.setInterval(interval);
        this.m_oPimNthRecurParameter = nthParam;
        this.m_oPimRecurrencePatternDayType = dayInstance;
    }

    public void createMonthlyTheNthDayOfEveryNMonth(int noOfOccurrences, PimRecurrencePatternNthType nthType, PimRecurrencePatternDayType dayInstance, int interval) throws PimException {
        this.setType(PimRecurrencePatternType.MONTHLY);
        this.setNoOfOccurrences(noOfOccurrences);
        this.setInterval(interval);
        this.setNthType(nthType);
        this.setDayType(dayInstance);
    }

    public void createMonthlyTheNthDayOfEveryNMonth(Date recurrenceEndDate, PimRecurrencePatternNthType nthType, PimRecurrencePatternDayType dayInstance, int interval) throws PimException {
        this.setType(PimRecurrencePatternType.MONTHLY);
        this.setRecurrenceEndDate(recurrenceEndDate);
        this.setInterval(interval);
        this.setNthType(nthType);
        this.setDayType(dayInstance);
    }

    public void update() throws ExWebDavPimException {
        try {
            this.doValidityCheck();
            this.m_bIsUpdateCalled = false;
            StringBuffer strb = new StringBuffer();
            if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.DAILY)) {
                strb.append("FREQ=DAILY");
                this.addNoOfOccurences(strb);
                if (this.m_iInterval > 0) {
                    strb.append(";");
                    strb.append("INTERVAL=" + this.m_iInterval);
                }
                strb.append(";");
                strb.append("WKST=SU");
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.WEEKLY)) {
                strb.append("FREQ=WEEKLY");
                this.addNoOfOccurences(strb);
                if (this.m_iInterval > 0) {
                    strb.append(";");
                    strb.append("INTERVAL=" + this.m_iInterval);
                }
                if (this.m_vDaysOfWeek != null && this.m_vDaysOfWeek.size() > 0) {
                    strb.append(";");
                    strb.append("BYDAY=");
                    int i = 0;
                    while (i < this.m_vDaysOfWeek.size()) {
                        PimRecurrencePatternDayType pimRecurrencePatternDayType = (PimRecurrencePatternDayType)this.m_vDaysOfWeek.elementAt(i);
                        String day = ExWebDavPimRecurrencePatternDayTypeMapper.getType(pimRecurrencePatternDayType);
                        if (i != 0) {
                            strb.append(",");
                        }
                        strb.append(day);
                        ++i;
                    }
                }
                strb.append(";");
                strb.append("WKST=SU");
                Date actualStartTime = RecurrenceUtil.getValidStartDateForCreateWeeklyWithDaysOfWeek((Date)this.m_oPimAppointmentItem.getStartTime(), (Vector)this.m_vDaysOfWeek);
                this.m_oPimAppointmentItem.setStartTime(actualStartTime);
                this.m_oPimAppointmentItem.setEndTime(RecurrenceUtil.getCorrespondingEndDate((Date)this.m_oPimAppointmentItem.getEndTime(), (Date)actualStartTime));
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.MONTHLY)) {
                strb.append("FREQ=MONTHLY");
                this.addNoOfOccurences(strb);
                if (this.m_iInterval > 0) {
                    strb.append(";");
                    strb.append("INTERVAL=" + this.m_iInterval);
                }
                if (this.m_vDaysOfMonth != null && this.m_vDaysOfMonth.size() > 0) {
                    strb.append(";");
                    strb.append("BYMONTHDAY=");
                    int bymonthday = (Integer)this.m_vDaysOfMonth.elementAt(0);
                    strb.append(bymonthday + "");
                    Vector actualDaysOfMonth = new Vector();
                    actualDaysOfMonth.add(this.m_vDaysOfMonth.elementAt(0));
                    Date actualStartTime = RecurrenceUtil.getValidStartDateForCreateMonthlyWithDaysOfMonth((Date)this.m_oPimAppointmentItem.getStartTime(), actualDaysOfMonth);
                    this.m_oPimAppointmentItem.setStartTime(actualStartTime);
                    this.m_oPimAppointmentItem.setEndTime(RecurrenceUtil.getCorrespondingEndDate((Date)this.m_oPimAppointmentItem.getEndTime(), (Date)actualStartTime));
                } else if (this.m_oPimNthRecurParameter != null && this.m_oPimRecurrencePatternDayType != null) {
                    strb.append(";");
                    strb.append("BYDAY=");
                    if (this.m_oPimRecurrencePatternDayType.equals(PimRecurrencePatternDayType.DAY)) {
                        strb.append(ExWebDavPimRecurrencePatternDayTypeMapper.getType(this.m_oPimRecurrencePatternDayType));
                        strb.append(";");
                        strb.append("BYSETPOS=");
                        strb.append(this.m_oPimNthRecurParameter.getType());
                    } else {
                        strb.append(this.m_oPimNthRecurParameter.getType());
                        strb.append(" ");
                    }
                } else if (this.m_oPimNthType != null && this.m_oPimDayType != null) {
                    strb.append(";");
                    strb.append("BYDAY=");
                    if (this.m_oPimDayType.equals(PimRecurrencePatternDayType.DAY)) {
                        strb.append(ExWebDavPimRecurrencePatternDayTypeMapper.getType(this.m_oPimDayType));
                        strb.append(";");
                        strb.append("BYSETPOS=");
                        strb.append(ExWebDavPimRecurrencePatternNthTypeMapper.getType(this.m_oPimNthType));
                    } else {
                        strb.append(ExWebDavPimRecurrencePatternNthTypeMapper.getType(this.m_oPimNthType));
                        strb.append(" ");
                        strb.append(ExWebDavPimRecurrencePatternDayTypeMapper.getType(this.m_oPimDayType));
                        Date actualStartTime = RecurrenceUtil.getValidStartDateForCreateMonthlyWithTheNthDayOfEveryNMonth((Date)this.m_oPimAppointmentItem.getStartTime(), (PimRecurrencePatternNthType)this.m_oPimNthType, (PimRecurrencePatternDayType)this.m_oPimDayType);
                        this.m_oPimAppointmentItem.setStartTime(actualStartTime);
                        this.m_oPimAppointmentItem.setEndTime(RecurrenceUtil.getCorrespondingEndDate((Date)this.m_oPimAppointmentItem.getEndTime(), (Date)actualStartTime));
                    }
                }
                strb.append(";");
                strb.append("WKST=SU");
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.YEARLY)) {
                strb.append("FREQ=YEARLY");
                this.addNoOfOccurences(strb);
                if (this.m_iInterval > 0) {
                    strb.append(";");
                    strb.append("INTERVAL=" + this.m_iInterval);
                }
                if (this.m_oPimNthRecurParameter != null && this.m_oPimYearlyRecurParameter != null && this.m_oPimRecurrencePatternDayType != null) {
                    strb.append(";");
                    strb.append("BYDAY=");
                    strb.append(this.m_oPimNthRecurParameter.getType());
                    strb.append(" ");
                    strb.append(ExWebDavPimRecurrencePatternDayTypeMapper.getType(this.m_oPimRecurrencePatternDayType));
                    strb.append(";");
                    strb.append("BYMONTH=");
                    strb.append(this.m_oPimYearlyRecurParameter.getType());
                } else if (this.m_oPimNthType != null && this.m_oPimMonthType != null && this.m_oPimDayType != null) {
                    strb.append(";");
                    strb.append("BYDAY=");
                    strb.append(ExWebDavPimRecurrencePatternNthTypeMapper.getType(this.m_oPimNthType));
                    strb.append(" ");
                    strb.append(ExWebDavPimRecurrencePatternDayTypeMapper.getType(this.m_oPimDayType));
                    strb.append(";");
                    strb.append("BYMONTH=");
                    strb.append(ExWebDavPimRecurrencePatternMonthTypeMapper.getType(this.m_oPimMonthType));
                    Date actualStartTime = RecurrenceUtil.getValidStartDateForCreateYearlyWithTheNthDayOfTheNthMonth((Date)this.m_oPimAppointmentItem.getStartTime(), (PimRecurrencePatternNthType)this.m_oPimNthType, (PimRecurrencePatternDayType)this.m_oPimDayType, (PimRecurrencePatternMonthType)this.m_oPimMonthType);
                    this.m_oPimAppointmentItem.setStartTime(actualStartTime);
                    this.m_oPimAppointmentItem.setEndTime(RecurrenceUtil.getCorrespondingEndDate((Date)this.m_oPimAppointmentItem.getEndTime(), (Date)actualStartTime));
                } else {
                    WebDavDate webDavDate = this.getPimAppointmentItem().getWebDavStartTime();
                    int month = webDavDate.getIntegerMonth();
                    int day = webDavDate.getIntegerDay();
                    strb.append(";");
                    strb.append("BYMONTHDAY=");
                    strb.append(day + "");
                    strb.append(";");
                    strb.append("BYMONTH=");
                    strb.append(month + "");
                }
                strb.append(";");
                strb.append("WKST=SU");
            }
            this.m_szRecurrencePatternString = strb.toString();
            this.m_bIsUpdateCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void addNoOfOccurences(StringBuffer strb) {
        if (this.m_oRecurrenceEndDate == null && this.m_iNoOfOccurences > 0) {
            strb.append(";");
            strb.append("COUNT=" + this.m_iNoOfOccurences);
        } else if (this.m_oRecurrenceEndDate != null) {
            strb.append(";");
            strb.append("UNTIL=" + this.m_oRecurrenceEndDate.getFormattedDateForRecurrence());
        }
    }

    public void delete() throws ExWebDavPimException {
        try {
            this.m_bIsUpdateCalled = false;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getID() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getName() throws ExWebDavPimException {
        try {
            return "Recurrence Pattern Item";
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecurrencePatternType getType() throws PimException {
        try {
            return this.m_oPimRecurrencePatternType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getInterval() throws PimException {
        try {
            return this.m_iInterval;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Vector getDaysOfWeek() throws PimException {
        try {
            return this.m_vDaysOfWeek;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Vector getDaysOfMonth() throws PimException {
        try {
            return this.m_vDaysOfMonth;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getNoOfOccurrences() throws PimException {
        try {
            return this.m_iNoOfOccurences;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getRecurrenceEndDate() throws PimException {
        try {
            if (this.m_oRecurrenceEndDate == null) {
                return null;
            }
            return this.m_oRecurrenceEndDate.getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecurrencePatternNthType getNthType() throws PimException {
        return this.m_oPimNthType;
    }

    public PimRecurrencePatternDayType getDayType() throws PimException {
        return this.m_oPimDayType;
    }

    public PimRecurrencePatternMonthType getMonthType() throws PimException {
        return this.m_oPimMonthType;
    }

    public Vector getMonthsOfYear() throws PimException {
        return null;
    }
}

