/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimDistListMemberItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewDistListMemberItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimNewPersonalAddressEntryItem
extends ExWebDavPimMessageItem
implements PimAddressEntryItem {
    private String m_szFirstName = "";
    private String m_szLastName = "";
    private String m_szEmailAddress = "";
    private String m_szBusinessCity = "";
    private String m_szBusinessCountry = "";
    private String m_szBusinessFaxNumber = "";
    private String m_szBusinessState = "";
    private String m_szBusinessStreet = "";
    private String m_szBusinessTelephoneNumber = "";
    private String m_szBusinessZip = "";
    private String m_szCompanyName = "";
    private String m_szHomeCity = "";
    private String m_szHomeCountry = "";
    private String m_szHomeState = "";
    private String m_szHomeStreet = "";
    private String m_szHomeTelephoneNumber = "";
    private String m_szHomeZip = "";
    private String m_szMobileTelephoneNumber = "";
    private String m_szTitle = "";
    private String m_szMiddleName = "";
    private ExWebDavPimFolder m_oPimFolder;
    private ExWebDavPimDistListMemberItems m_oPimNewDistListMemberItems;
    private String m_szUniqueFileName;
    private boolean m_bIsUpdateDone;

    public ExWebDavPimNewPersonalAddressEntryItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder) {
        super(pimSession);
        this.m_oPimFolder = pimFolder;
    }

    public ExWebDavPimFolder getPimFolder() {
        return this.m_oPimFolder;
    }

    public String getName() throws ExWebDavPimException {
        try {
            return this.getFirstName() + " " + this.getLastName();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItems getMembers() throws ExWebDavPimException {
        try {
            return this.m_oPimNewDistListMemberItems;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimAddressEntryItems addMembers() throws PimException {
        try {
            if (this.m_oPimNewDistListMemberItems == null) {
                this.m_oPimNewDistListMemberItems = new ExWebDavPimNewDistListMemberItems(this.getPimSession(), this.getPimFolder(), this);
            }
            return this.m_oPimNewDistListMemberItems;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            if (this.m_bIsUpdateDone) {
                if (this.m_szUniqueFileName != null) {
                    Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
                    String fromString = this.getFolderName();
                    String whereString = "(\"http://schemas.microsoft.com/exchange/outlookmessageclass\"='IPM.Contact' OR \"DAV:contentclass\"='urn:content-classes:person' OR \"http://schemas.microsoft.com/exchange/outlookmessageclass\"='IPM.DistList' OR \"DAV:contentclass\"='urn:content-classes:group')  AND \"DAV:displayname\"='" + this.m_szUniqueFileName + "'";
                    Vector<WebDavField> fieldsVector = new Vector<WebDavField>();
                    fieldsVector.add(WebDavField.UID);
                    fieldsVector.add(WebDavField.DISPLAYNAME);
                    int i = 0;
                    while (i < fieldsVector.size()) {
                        selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                        ++i;
                    }
                    String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
                    int numOfElements = XMLUtilities.getNumOfElements(response.getText(), WebDavField.RESPONSE);
                    Element element = null;
                    int i2 = 0;
                    while (i2 < numOfElements) {
                        String displayName;
                        element = XMLUtilities.getValueAsElement(response.getText(), WebDavField.RESPONSE, i2);
                        if (element != null && (displayName = XMLUtilities.getValue(element, WebDavField.DISPLAYNAME)).equals(this.m_szUniqueFileName)) break;
                        ++i2;
                    }
                    if (element == null) {
                        return null;
                    }
                    String id = XMLUtilities.getValue(element, WebDavField.UID);
                    return id;
                }
            } else {
                return null;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimBusyStatusType getBusyStatusType(Date startTime, Date endTime, int interval) throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            return PimBusyStatusType.UNKNOWN;
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        return null;
    }

    public void delete() throws ExWebDavPimException {
    }

    public void delete(boolean flag) throws PimException {
    }

    public String getFullName() throws ExWebDavPimException {
        String fullName = this.getName();
        if (!StringUtility.isItValid(fullName)) {
            fullName = "Unknown UserName";
        }
        return fullName;
    }

    private String getFolderName() throws ExWebDavPimException {
        return this.m_oPimFolder.getFullFolderName();
    }

    public boolean isThisDistListItem() {
        return this.m_oPimNewDistListMemberItems != null;
    }

    public void update() throws ExWebDavPimException {
        try {
            if (this.isThisDistListItem()) {
                if (!StringUtility.isItValid(this.getName())) {
                    return;
                }
                this.m_oPimNewDistListMemberItems.update();
            } else {
                Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
                if (this.getFullName() != null) {
                    toSend.add(new PropertyHolder(WebDavField.CN, this.getFullName()));
                }
                if (this.getFirstName() != null) {
                    toSend.add(new PropertyHolder(WebDavField.FIRSTNAME, this.getFirstName()));
                }
                if (this.getMiddleName() != null) {
                    toSend.add(new PropertyHolder(WebDavField.MIDDLENAME, this.getMiddleName()));
                }
                if (this.getLastName() != null) {
                    toSend.add(new PropertyHolder(WebDavField.SN, this.getLastName()));
                }
                if (this.getEmailAddress() != null) {
                    toSend.add(new PropertyHolder(WebDavField.EMAIL1, "\"" + this.getEmailAddress() + "\" <" + this.getEmailAddress() + ">"));
                }
                if (this.getBusinessCity() != null) {
                    toSend.add(new PropertyHolder(WebDavField.L, this.getBusinessCity()));
                }
                if (this.getMobileTelephoneNumber() != null) {
                    toSend.add(new PropertyHolder(WebDavField.MOBILE, this.getMobileTelephoneNumber()));
                }
                if (this.getTitle() != null) {
                    toSend.add(new PropertyHolder(WebDavField.TITLE, this.getTitle()));
                }
                if (this.getBusinessCountry() != null) {
                    toSend.add(new PropertyHolder(WebDavField.CO, this.getBusinessCountry()));
                }
                if (this.getBusinessFaxNumber() != null) {
                    toSend.add(new PropertyHolder(WebDavField.FACSIMILETELEPHONENUMBER, this.getBusinessFaxNumber()));
                }
                if (this.getBusinessState() != null) {
                    toSend.add(new PropertyHolder(WebDavField.ST, this.getBusinessState()));
                }
                if (this.getBusinessStreet() != null) {
                    toSend.add(new PropertyHolder(WebDavField.STREET, this.getBusinessStreet()));
                }
                if (this.getBusinessTelephoneNumber() != null) {
                    toSend.add(new PropertyHolder(WebDavField.TELEPHONENUMBER, this.getBusinessTelephoneNumber()));
                }
                if (this.getBusinessZip() != null) {
                    toSend.add(new PropertyHolder(WebDavField.POSTALCODE, this.getBusinessZip()));
                }
                if (this.getCompanyName() != null) {
                    toSend.add(new PropertyHolder(WebDavField.O, this.getCompanyName()));
                }
                if (this.getHomeCity() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMECITY, this.getHomeCity()));
                }
                if (this.getHomeCountry() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMECOUNTRY, this.getHomeCountry()));
                }
                if (this.getHomeState() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMESTATE, this.getHomeState()));
                }
                if (this.getHomeStreet() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMESTREET, this.getHomeStreet()));
                }
                if (this.getHomeTelephoneNumber() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMEPHONE, this.getHomeTelephoneNumber()));
                }
                if (this.getHomeZip() != null) {
                    toSend.add(new PropertyHolder(WebDavField.HOMEPOSTALCODE, this.getHomeZip()));
                }
                toSend.add(new PropertyHolder(WebDavField.FILEASID, "1"));
                toSend.add(new PropertyHolder(WebDavField.FILEAS, this.getLastName() + ", " + this.getFirstName()));
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.getFirstName() + " " + this.getLastName()));
                toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.CONTACT"));
                toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:person"));
                String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
                String uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getFolderName(), this.getFullName());
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
                this.m_szUniqueFileName = uniqueFileName.substring(uniqueFileName.lastIndexOf("/") + 1, uniqueFileName.length());
                this.m_bIsUpdateDone = true;
            }
        }
        catch (ExWebDavPimException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(41L);
        }
    }

    public String getEmailAddress() throws ExWebDavPimException {
        try {
            return this.m_szEmailAddress;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getLastName() throws ExWebDavPimException {
        try {
            return this.m_szLastName;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getFirstName() throws ExWebDavPimException {
        try {
            return this.m_szFirstName;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getMiddleName() throws PimException {
        return this.m_szMiddleName;
    }

    public String getLogonName() throws PimException {
        return "";
    }

    public String getAlternateFullName() throws PimException {
        return "";
    }

    public String getBusinessTelephoneNumber() throws ExWebDavPimException {
        try {
            return this.m_szBusinessTelephoneNumber;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeTelephoneNumber() throws ExWebDavPimException {
        try {
            return this.m_szHomeTelephoneNumber;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getMobileTelephoneNumber() throws ExWebDavPimException {
        try {
            return this.m_szMobileTelephoneNumber;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessFaxNumber() throws ExWebDavPimException {
        try {
            return this.m_szBusinessFaxNumber;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getTitle() throws ExWebDavPimException {
        try {
            return this.m_szTitle;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCompanyName() throws ExWebDavPimException {
        try {
            return this.m_szCompanyName;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeStreet() throws ExWebDavPimException {
        try {
            return this.m_szHomeStreet;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeCity() throws ExWebDavPimException {
        try {
            return this.m_szHomeCity;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeState() throws ExWebDavPimException {
        try {
            return this.m_szHomeState;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeZip() throws ExWebDavPimException {
        try {
            return this.m_szHomeZip;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getHomeCountry() throws ExWebDavPimException {
        try {
            return this.m_szHomeCountry;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessStreet() throws ExWebDavPimException {
        try {
            return this.m_szBusinessStreet;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessCity() throws ExWebDavPimException {
        try {
            return this.m_szBusinessCity;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessState() throws ExWebDavPimException {
        try {
            return this.m_szBusinessState;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessZip() throws ExWebDavPimException {
        try {
            return this.m_szBusinessZip;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getBusinessCountry() throws ExWebDavPimException {
        try {
            return this.m_szBusinessCountry;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        return null;
    }

    public void setEmailAddress(String emailAddress) throws ExWebDavPimException {
        this.m_szEmailAddress = emailAddress;
    }

    public void setLastName(String lastName) throws ExWebDavPimException {
        this.m_szLastName = lastName;
    }

    public void setFirstName(String firstName) throws ExWebDavPimException {
        this.m_szFirstName = firstName;
    }

    public void setMiddleName(String middleName) throws PimException {
        this.m_szMiddleName = middleName;
    }

    public void setAlternateFullName(String alternateFullName) throws PimException {
    }

    public void setBusinessTelephoneNumber(String bTelNumber) throws ExWebDavPimException {
        this.m_szBusinessTelephoneNumber = bTelNumber;
    }

    public void setHomeTelephoneNumber(String hTelNumber) throws ExWebDavPimException {
        this.m_szHomeTelephoneNumber = hTelNumber;
    }

    public void setMobileTelephoneNumber(String mTelNumber) throws ExWebDavPimException {
        this.m_szMobileTelephoneNumber = mTelNumber;
    }

    public void setBusinessFaxNumber(String bFaxNumber) throws ExWebDavPimException {
        this.m_szBusinessFaxNumber = bFaxNumber;
    }

    public void setTitle(String title) throws ExWebDavPimException {
        this.m_szTitle = title;
    }

    public void setCompanyName(String companyName) throws ExWebDavPimException {
        this.m_szCompanyName = companyName;
    }

    public void setHomeStreet(String hStreet) throws ExWebDavPimException {
        this.m_szHomeStreet = hStreet;
    }

    public void setHomeCity(String hCity) throws ExWebDavPimException {
        this.m_szHomeCity = hCity;
    }

    public void setHomeState(String hState) throws ExWebDavPimException {
        this.m_szHomeState = hState;
    }

    public void setHomeZip(String hZip) throws ExWebDavPimException {
        this.m_szHomeZip = hZip;
    }

    public void setHomeCountry(String hCountry) throws ExWebDavPimException {
        this.m_szHomeCountry = hCountry;
    }

    public void setBusinessStreet(String bStreet) throws ExWebDavPimException {
        this.m_szBusinessStreet = bStreet;
    }

    public void setBusinessCity(String bCity) throws ExWebDavPimException {
        this.m_szBusinessCity = bCity;
    }

    public void setBusinessState(String bState) throws ExWebDavPimException {
        this.m_szBusinessState = bState;
    }

    public void setBusinessZip(String bZip) throws ExWebDavPimException {
        this.m_szBusinessZip = bZip;
    }

    public void setBusinessCountry(String bCountry) throws ExWebDavPimException {
        this.m_szBusinessCountry = bCountry;
    }
}

