/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewMailMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class ExWebDavPimNewMailItem
extends ExWebDavPimNewMailMessageItem
implements PimMailItem {
    private ExWebDavPimRecipientItems m_oPimRecipientItems;

    public ExWebDavPimNewMailItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder) {
        super(pimSession, pimFolder);
    }

    public void update() throws PimException {
        try {
            PimRecipientItems pimRecipientItems = this.getRecipientItems();
            PimRecipientItem pimRecipientItem = pimRecipientItems.getFirstRecipientItem();
            String toBuffer = "";
            String ccBuffer = "";
            String bccBuffer = "";
            while (pimRecipientItem != null) {
                if (pimRecipientItem.getRecipientType().equals(PimRecipientType.TO)) {
                    toBuffer = toBuffer + pimRecipientItem.getEmailAddress() + ",";
                } else if (pimRecipientItem.getRecipientType().equals(PimRecipientType.CC)) {
                    ccBuffer = ccBuffer + pimRecipientItem.getEmailAddress() + ",";
                }
                if (pimRecipientItem.getRecipientType().equals(PimRecipientType.BCC)) {
                    bccBuffer = bccBuffer + pimRecipientItem.getEmailAddress() + ",";
                }
                pimRecipientItem = pimRecipientItems.getNextRecipientItem();
            }
            StringBuffer mail = new StringBuffer();
            if (!toBuffer.equals("")) {
                mail.append("TO: ");
                mail.append(toBuffer.substring(0, toBuffer.length() - 1));
                mail.append("\n");
            }
            if (!ccBuffer.equals("")) {
                mail.append("CC: ");
                mail.append(ccBuffer.substring(0, ccBuffer.length() - 1));
                mail.append("\n");
            }
            if (this.getSubject() != null && !this.getSubject().equals("")) {
                mail.append("Subject: ");
                mail.append(this.getSubject());
                mail.append("\n");
            }
            if (this.getImportance() != null) {
                mail.append("Importance: ");
                mail.append(ExWebDavPimImportanceTypeMapper.getTypeForComposingMail(this.getImportance()));
                mail.append("\n");
            }
            mail.append("Date: ");
            mail.append(new Date());
            mail.append("X-Mailer: ");
            mail.append("test mailer");
            mail.append("\n");
            mail.append("MIME-Version: ");
            mail.append("1.0");
            mail.append("\n");
            mail.append("Content-Type: ");
            mail.append("text/plain; ");
            Locale locale = Locale.getDefault();
            if (locale.equals(Locale.JAPAN)) {
                mail.append("charset = ");
                mail.append("\"iso-2022-jp\"");
                mail.append("\n");
            } else {
                mail.append("charset = ");
                mail.append("\"iso-8859-1\"");
                mail.append("\n");
            }
            mail.append("Content-Transfer-Encoding: ");
            mail.append("7bit");
            mail.append("\n\n");
            mail.append(this.getBody());
            String uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getDraftsFolderFullName(), this.getSubject() == null ? "No Subject" : this.getSubject());
            HTTPResponse response = this.getPimSession().getHttpConnector().put(uniqueFileName, mail.toString());
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            if (!bccBuffer.equals("")) {
                toSend.add(new PropertyHolder(WebDavField.BCC, bccBuffer.substring(0, bccBuffer.length() - 1)));
                String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
                response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            }
            response = this.getPimSession().getHttpConnector().move(uniqueFileName, this.getPimSession().getPimFolderType().getMailSubmissionURI(this.getPimSession()));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws PimException {
        return null;
    }

    public String getName() throws PimException {
        return null;
    }

    public void send() throws PimException {
    }

    public PimMessageItem forward() throws PimException {
        return null;
    }

    public PimMailMessageItem reply() throws PimException {
        return null;
    }

    public PimMailMessageItem replyAll() throws PimException {
        return null;
    }
}

