/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimAccessLevelType;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimMeetingItemResponseType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFolder;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewRecipientItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimBusyStatusTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTimeZoneTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimNewAppointmentItem
extends ExWebDavPimMessageItem
implements ExWebDavPimAppointmentItem {
    private ExWebDavPimFolder m_oPimFolder;
    private String m_szSubject;
    private String m_szText;
    private PimImportanceType m_oPimImportanceType;
    private PimBusyStatusType m_oPimBusyStatusType;
    private String m_szLocation;
    private WebDavDate m_oStartTime;
    private WebDavDate m_oEndTime;
    private boolean m_bIsAllDayEvent;
    private PimCalendarType m_oPimCalendarType;
    private ExWebDavPimNewRecurrencePatternItem m_oPimRecurrencePatternItem;
    private ExWebDavPimReminderItem m_oPimReminderItem;
    private ExWebDavPimNewRecipientItems m_oPimRecipientItems;
    private boolean m_bIsUpdateDone;
    private String m_szUniqueFileName = "";
    private String calendarUid;
    private Date m_oStartDate;

    public ExWebDavPimNewAppointmentItem(ExWebDavPimSession pimSession, ExWebDavPimFolder pimFolder) {
        super(pimSession);
        this.m_oPimFolder = pimFolder;
    }

    public PimReminderItem getReminderItem() throws ExWebDavPimException {
        try {
            return this.addReminderItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimFolder getPimFolder() {
        return this.m_oPimFolder;
    }

    public PimReminderItem addReminderItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new ExWebDavPimNewReminderItem();
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getClassType() throws ExWebDavPimException {
        try {
            return 0;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setRecurrencePatternItem(ExWebDavPimNewRecurrencePatternItem pimNewRecurrencePatternItem) {
        this.m_oPimRecurrencePatternItem = pimNewRecurrencePatternItem;
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                this.m_oPimRecurrencePatternItem = new ExWebDavPimNewRecurrencePatternItem(this);
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            return this.m_szSubject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            if (this.m_bIsUpdateDone) {
                if (this.m_szUniqueFileName != null) {
                    Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
                    String fromString = this.getFolderName();
                    String whereString = "(\"http://schemas.microsoft.com/exchange/outlookmessageclass\"='IPM.Appointment' OR \"DAV:contentclass\"='urn:content-classes:appointment')  AND \"DAV:displayname\"='" + this.m_szUniqueFileName + "'";
                    Vector<WebDavField> fieldsVector = new Vector<WebDavField>();
                    fieldsVector.add(WebDavField.UID);
                    fieldsVector.add(WebDavField.CALENDARUID);
                    fieldsVector.add(WebDavField.DISPLAYNAME);
                    int i = 0;
                    while (i < fieldsVector.size()) {
                        selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                        ++i;
                    }
                    String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
                    int numOfElements = XMLUtilities.getNumOfElements(response.getText(), WebDavField.RESPONSE);
                    Element element = null;
                    int i2 = 0;
                    while (i2 < numOfElements) {
                        String displayName;
                        element = XMLUtilities.getValueAsElement(response.getText(), WebDavField.RESPONSE, i2);
                        if (element != null && (displayName = XMLUtilities.getValue(element, WebDavField.DISPLAYNAME)).equals(this.m_szUniqueFileName)) break;
                        ++i2;
                    }
                    if (element == null) {
                        return null;
                    }
                    String id = XMLUtilities.getValue(element, WebDavField.UID);
                    this.calendarUid = XMLUtilities.getValue(element, WebDavField.CALENDARUID);
                    return id;
                }
            } else {
                return null;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExWebDavPimException {
        try {
            return this.m_oPimImportanceType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAccessLevelType getAccessLevel() throws PimException {
        return null;
    }

    public PimAddressEntryItem getSender() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getDuration() throws ExWebDavPimException {
        try {
            return 0;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getLocation() throws ExWebDavPimException {
        try {
            return this.m_szLocation;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getText() throws ExWebDavPimException {
        try {
            return this.m_szText;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartTime() throws ExWebDavPimException {
        try {
            if (this.m_oStartTime != null) {
                return this.m_oStartTime.getDate();
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate getWebDavEndTime() {
        return this.m_oEndTime;
    }

    public WebDavDate getWebDavStartTime() {
        return this.m_oStartTime;
    }

    public Date getEndTime() throws ExWebDavPimException {
        try {
            if (this.m_oEndTime != null) {
                return this.m_oEndTime.getDate();
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean isAllDayEvent() throws ExWebDavPimException {
        try {
            return this.m_bIsAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        try {
            this.m_szSubject = subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setLocation(String location) throws ExWebDavPimException {
        try {
            this.m_szLocation = location;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setImportance(PimImportanceType importance) throws ExWebDavPimException {
        try {
            this.m_oPimImportanceType = importance;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setAccessLevel(PimAccessLevelType accessLevelType) throws PimException {
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws ExWebDavPimException {
        if (pimBusyStatusType != null) {
            this.m_oPimBusyStatusType = pimBusyStatusType;
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        try {
            this.m_szText = text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStartTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oStartDate = date;
                this.m_oStartTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setEndTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oEndTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimAddressEntryItem getOrganizer() throws ExWebDavPimException {
        return null;
    }

    public void setMeetingStatus(int meetingStatus) throws ExWebDavPimException {
    }

    public void setAllDayEvent(boolean isAllDayEvent) throws ExWebDavPimException {
        try {
            this.m_bIsAllDayEvent = isAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void checkValidity() throws ExWebDavPimException {
        if (this.m_oStartTime == null) {
            throw new ExWebDavPimException(84L);
        }
        if (this.m_oEndTime == null && !this.m_bIsAllDayEvent) {
            throw new ExWebDavPimException(85L);
        }
        if (this.m_bIsAllDayEvent) {
            this.m_oEndTime = new WebDavDate(this.m_oStartDate, this.getPimSession());
        }
        if (!(this.m_oStartTime != null && this.m_oEndTime != null && this.m_oEndTime.after(this.m_oStartTime) || this.m_oEndTime.equals(this.m_oStartTime))) {
            throw new ExWebDavPimException(13L);
        }
    }

    private Vector fillCommonPropertites(Vector toSend) throws ExWebDavPimException {
        try {
            this.checkValidity();
            if (this.m_szSubject != null) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject == null ? "No Subject" : this.m_szSubject));
            }
            if (this.m_szText != null) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szText));
            }
            if (this.m_oPimImportanceType != null) {
                toSend.add(new PropertyHolder(WebDavField.IMPORTANCE, ExWebDavPimImportanceTypeMapper.getType(this.m_oPimImportanceType)));
            } else {
                toSend.add(new PropertyHolder(WebDavField.IMPORTANCE, "1"));
            }
            if (this.m_szLocation != null) {
                toSend.add(new PropertyHolder(WebDavField.LOCATION, this.m_szLocation));
            }
            if (this.m_oPimRecurrencePatternItem == null) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "0"));
            } else {
                ExWebDavPimNewRecurrencePatternItem pimRecurrencePatternItem = this.m_oPimRecurrencePatternItem;
                if (pimRecurrencePatternItem.isItRecurringItem()) {
                    toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "1"));
                    String recurrenceString = pimRecurrencePatternItem.getRecurrencePatternString();
                    PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                    toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                    Vector exceptionDates = this.m_oPimRecurrencePatternItem.getExceptionDates();
                    if (exceptionDates != null) {
                        Vector<PropertyHolder> properties = new Vector<PropertyHolder>();
                        int i = 0;
                        while (i < exceptionDates.size()) {
                            WebDavDate webDavDate = new WebDavDate((Date)exceptionDates.elementAt(i), this.getPimSession());
                            properties.add(new PropertyHolder(WebDavField.V, webDavDate.getFormattedDate()));
                            ++i;
                        }
                        toSend.add(new PropertyHolder(WebDavField.EXDATE, properties));
                    }
                }
            }
            if (!this.m_bIsAllDayEvent) {
                if (this.m_oEndTime != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                }
                if (this.m_oStartTime != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                }
                if (this.m_oPimReminderItem != null && this.m_oPimReminderItem.isReminderSet()) {
                    toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, this.m_oPimReminderItem.getNoOfSecondsBeforeStart() + ""));
                }
                if (this.m_oPimBusyStatusType == null) {
                    toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "BUSY"));
                }
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "0"));
            } else {
                if (this.m_oEndTime != null) {
                    this.m_oEndTime.resetToNextDay();
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                }
                if (this.m_oStartTime != null) {
                    this.m_oStartTime.resetToThisDay();
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                }
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "1"));
                if (this.m_oPimBusyStatusType == null) {
                    toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "FREE"));
                }
                toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, "0"));
            }
            if (this.m_oPimBusyStatusType != null) {
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, ExWebDavPimBusyStatusTypeMapper.getType(this.m_oPimBusyStatusType)));
            }
            return toSend;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private Vector fillMeetingProperties(Vector toSend) {
        toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "CONFIRMED"));
        toSend.add(new PropertyHolder(WebDavField.RESPONSEREQUESTED, "1"));
        toSend.add(new PropertyHolder(WebDavField.FINVITED, "1"));
        return toSend;
    }

    private Vector fillInvitees(Vector toSend) throws ExWebDavPimException {
        try {
            PimRecipientItems pimRecipientItems = this.getRecipientItems();
            PimRecipientItem pimRecipientItem = pimRecipientItems.getFirstRecipientItem();
            boolean firstTime = true;
            StringBuffer mailList = new StringBuffer();
            while (pimRecipientItem != null) {
                String emailAddress = pimRecipientItem.getEmailAddress();
                if (emailAddress == null) {
                    emailAddress = pimRecipientItem.getAddressEntryItem().getEmailAddress();
                }
                if (firstTime) {
                    firstTime = false;
                } else {
                    mailList.append(";");
                }
                mailList.append(emailAddress);
                pimRecipientItem = pimRecipientItems.getNextRecipientItem();
            }
            toSend.add(new PropertyHolder(WebDavField.HEADER_TO, mailList.toString()));
            toSend.add(new PropertyHolder(WebDavField.ORGANIZER, this.getPimSession().getUserInfo().getMailbox()));
            return toSend;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void update() throws ExWebDavPimException {
        this.m_bIsUpdateDone = false;
        String uniqueFileName = null;
        try {
            if (this.m_oPimCalendarType == null) {
                this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            }
            Vector toSend = new Vector();
            toSend = this.fillCommonPropertites(toSend);
            if (this.m_oPimCalendarType.equals(PimCalendarType.APPOINTMENT)) {
                toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "TENTATIVE"));
                toSend.add(new PropertyHolder(WebDavField.MAPI_RESPONSESTATUS, "0"));
            } else if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                toSend = this.fillMeetingProperties(toSend);
                toSend = this.fillInvitees(toSend);
            }
            toSend.add(new PropertyHolder(WebDavField.CREATED, new WebDavDate(new Date(), this.getPimSession()).getFormattedDate()));
            String timeZoneId = ExWebDavPimTimeZoneTypeMapper.getType(this.getPimSession().getTimeZone());
            toSend.add(new PropertyHolder(WebDavField.TIMEZONEID, timeZoneId));
            toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.Appointment"));
            toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:appointment"));
            toSend.add(new PropertyHolder(WebDavField.TRANSPARENT, "OPAQUE"));
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getFolderName(), this.m_szSubject == null ? "No Subject" : this.m_szSubject);
            this.m_szUniqueFileName = uniqueFileName.substring(uniqueFileName.lastIndexOf("/") + 1, uniqueFileName.length());
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            this.m_bIsUpdateDone = true;
            String id = this.getID();
            if (id == null) {
                throw new ExWebDavPimException(33L);
            }
            if (this.m_oPimCalendarType != null && this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                this.createMeetingRequest();
            }
        }
        catch (ExWebDavPimException ewp) {
            throw ewp;
        }
        catch (Exception e) {
            if (uniqueFileName != null && !uniqueFileName.equals("")) {
                this.m_bIsUpdateDone = this.getPimSession().getHttpConnector().doesFileExist(uniqueFileName);
            }
            this.m_bIsUpdateDone = false;
            throw new ExWebDavPimException(e);
        }
    }

    private void createMeetingRequest() throws ExWebDavPimException {
        try {
            Vector toSend = new Vector();
            toSend.add(new PropertyHolder(WebDavField.OUTLOOKMESSAGECLASS, "IPM.Schedule.Meeting.Request"));
            toSend.add(new PropertyHolder(WebDavField.CONTENTCLASS, "urn:content-classes:calendarmessage"));
            toSend = this.fillCommonPropertites(toSend);
            String timeZoneId = ExWebDavPimTimeZoneTypeMapper.getType(this.getPimSession().getTimeZone());
            toSend.add(new PropertyHolder(WebDavField.TIMEZONEID, timeZoneId));
            toSend.add(new PropertyHolder(WebDavField.CALENDARUID, this.calendarUid));
            toSend = this.fillInvitees(toSend);
            if (this.m_oPimRecurrencePatternItem == null) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "0"));
            } else {
                ExWebDavPimNewRecurrencePatternItem pimRecurrencePatternItem = this.m_oPimRecurrencePatternItem;
                if (pimRecurrencePatternItem.isItRecurringItem()) {
                    toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "1"));
                    String recurrenceString = pimRecurrencePatternItem.getRecurrencePatternString();
                    PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                    toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                    Vector exceptionDates = this.m_oPimRecurrencePatternItem.getExceptionDates();
                    if (exceptionDates != null) {
                        Vector<PropertyHolder> properties = new Vector<PropertyHolder>();
                        int i = 0;
                        while (i < exceptionDates.size()) {
                            WebDavDate webDavDate = new WebDavDate((Date)exceptionDates.elementAt(i), this.getPimSession());
                            properties.add(new PropertyHolder(WebDavField.V, webDavDate.getFormattedDate()));
                            ++i;
                        }
                        toSend.add(new PropertyHolder(WebDavField.EXDATE, properties));
                    }
                }
            }
            toSend.add(new PropertyHolder(WebDavField.RESPONSESTATUS, "1"));
            toSend.add(new PropertyHolder(WebDavField.RESPONSESTATE, "0"));
            toSend.add(new PropertyHolder(WebDavField.APPTSTATEFLAGS, "3"));
            toSend.add(new PropertyHolder(WebDavField.MAPI_BUSYSTATUS, "1"));
            toSend.add(new PropertyHolder(WebDavField.MAPI_INTENDEBUSYSTATUS, "2"));
            toSend.add(new PropertyHolder(WebDavField.RESPONSEREQUESTED, "1"));
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            String uniqueFileName = this.getPimSession().getHttpConnector().getUniqueFileName(this.getFolderName(), this.m_szSubject == null ? "No Subject" : this.m_szSubject);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", uniqueFileName, xmlString);
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                response = this.getPimSession().getHttpConnector().move(uniqueFileName, this.getPimSession().getPimFolderType().getMailSubmissionURI(this.getPimSession()));
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimFolder().getFullFolderName();
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        try {
            if (this.m_oPimRecipientItems == null) {
                this.m_oPimRecipientItems = new ExWebDavPimNewRecipientItems(this.getPimSession());
            }
            return this.m_oPimRecipientItems;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public void setType(PimCalendarType pimCalendarType) throws ExWebDavPimException {
        this.m_oPimCalendarType = pimCalendarType;
    }

    public PimCalendarType getType() throws ExWebDavPimException {
        return this.m_oPimCalendarType;
    }

    public void setStatus(PimMeetingItemResponseType pimMeetingItemResponseType) throws PimException {
    }

    public PimMeetingItemResponseType getStatus() throws PimException {
        return null;
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        return "Appointment: " + this.getSubject() + " in " + this.getLocation();
    }
}

