/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimInbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimMailMessageItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewMailItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMailItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMeetingItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMailMessageItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMailMessageItemFilter;
import com.aligo.pim.interfaces.PimMailMessageItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimMailMessageItems
extends ExWebDavPimMessageItems
implements PimMailMessageItems {
    private ExWebDavPimInbox m_oPimInbox;
    private ExWebDavPimMailMessageItemFilter m_oPimMailMessageItemFilter;
    private boolean m_bIsInitializeCalled = false;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private boolean m_bIsMailMessageItemFilterCalled;

    public ExWebDavPimMailMessageItems(ExWebDavPimInbox pimInbox, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimInbox = pimInbox;
        this.m_oPimMailMessageItemFilter = new ExWebDavPimMailMessageItemFilter();
    }

    public PimMailMessageItemFilter getMailMessageItemFilter() throws ExWebDavPimException {
        this.m_bIsMailMessageItemFilterCalled = true;
        return this.m_oPimMailMessageItemFilter;
    }

    public PimMailItem addMailItem() throws ExWebDavPimException {
        try {
            return new ExWebDavPimNewMailItem(this.getPimSession(), this.getPimInbox());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimInbox getPimInbox() {
        return this.m_oPimInbox;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimInbox().getFolderName();
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getOrderByString() {
        return this.m_oPimMailMessageItemFilter.getOrderByString();
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            String whereString = this.m_oPimMailMessageItemFilter.getWhereString();
            String orderByString = this.getOrderByString();
            Vector fieldsVector = ExWebDavPimMailMessageItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, orderByString, this.m_oPimSortType);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            if (this.m_oPimMailMessageItemFilter.isFilter()) {
                if (!this.m_bIsInitializeCalled) {
                    this.initializeCache();
                }
                this.getCache().setPageSize(-1);
                int cacheCount = this.getCache().getNumOfElements();
                if (cacheCount != -1) {
                    return cacheCount;
                }
            } else if (this.m_oPimMailMessageItemFilter.isUnreadFilter()) {
                String xmlstring = this.getUnreadCountXmlString();
                HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
                String count = XMLUtilities.getValue(response.getText(), WebDavField.UNREADCOUNT);
                return Integer.parseInt(count);
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getUnreadCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.UNREADCOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getMailMessageItem(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            return this.returnPimMailMessageItem(element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getMailMessageItem(String id) throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            ExWebDavPimMailMessageItemFilter uidFilter = new ExWebDavPimMailMessageItemFilter();
            uidFilter.setID(id);
            String whereString = uidFilter.getWhereString();
            Vector fieldsVector = ExWebDavPimMailMessageItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
            String text = StringUtility.getTextAfterEncoding(response);
            int numOfElements = XMLUtilities.getNumOfElements(text, WebDavField.RESPONSE);
            Element element = null;
            int i2 = 0;
            while (i2 < numOfElements) {
                String retrievedId;
                element = XMLUtilities.getValueAsElement(text, WebDavField.RESPONSE, i2);
                if (element != null && (retrievedId = XMLUtilities.getValue(element, WebDavField.UID)).equals(id)) break;
                ++i2;
            }
            if (element == null) {
                return null;
            }
            return this.returnPimMailMessageItem(element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getFirstMailMessageItem() throws ExWebDavPimException {
        try {
            return this.getMailMessageItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getNextMailMessageItem() throws ExWebDavPimException {
        try {
            return this.getMailMessageItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getLastMailMessageItem() throws ExWebDavPimException {
        try {
            PimMailMessageItem pimMailMessageItem = this.getMailMessageItem(this.getLastIndex());
            while (pimMailMessageItem == null) {
                int index = this.getPreviousIndex();
                if (index < 0) break;
                pimMailMessageItem = this.getMailMessageItem(index);
            }
            return pimMailMessageItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailMessageItem getPreviousMailMessageItem() throws ExWebDavPimException {
        try {
            return this.getMailMessageItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                this.m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getMailMessageItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getMailMessageItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getMailMessageItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstMailMessageItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextMailMessageItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastMailMessageItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousMailMessageItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addMailItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    public void delete(String[] ids) throws ExWebDavPimException {
        try {
            int length = ids.length;
            int i = 0;
            while (i < length) {
                PimMailMessageItem pimMailMessageItem = this.getMailMessageItem(ids[i]);
                pimMailMessageItem.delete();
                ++i;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private PimMailMessageItem returnPimMailMessageItem(Element element) throws ExWebDavPimException {
        String classType = XMLUtilities.getValue(element, WebDavField.CLASSTYPE);
        if (classType.equals("IPM.Schedule.Meeting.Request")) {
            return new ExWebDavPimOldMeetingItem(this.getPimSession(), this.getPimInbox(), element);
        }
        return new ExWebDavPimOldMailItem(this.getPimSession(), this.getPimInbox(), element);
    }
}

