/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItemFilter;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMailMessageItemFilter;
import java.util.Date;

public class ExWebDavPimMailMessageItemFilter
extends ExWebDavPimMessageItemFilter
implements PimMailMessageItemFilter {
    private WebDavField m_oDefaultOrderByField = WebDavField.DATERECEIVED;
    private boolean bIsUnreadFilter = false;
    private boolean bIsFilter = false;

    public void setFilter(boolean bIsFilter) {
        this.bIsFilter = bIsFilter;
    }

    public boolean isFilter() {
        return this.bIsFilter;
    }

    public boolean isUnreadFilter() {
        return this.bIsUnreadFilter;
    }

    public void setUnreadFilter(boolean bIsUnreadFilter) {
        this.bIsUnreadFilter = bIsUnreadFilter;
    }

    public ExWebDavPimMailMessageItemFilter() throws ExWebDavPimException {
        try {
            this.setOperand(PimFilterOperandType.OPEN);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Note");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Schedule.Meeting.Request");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Schedule.Meeting.Resp.Pos");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Schedule.Meeting.Resp.Neg");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Schedule.Meeting.Resp.Tent");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Schedule.Meeting.Canceled");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "REPORT.IPM.Note.NDR");
            this.setOperand(PimFilterOperandType.CLOSE);
            this.getFilterCriteria().addOrderBy(this.m_oDefaultOrderByField);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws PimException {
        return null;
    }

    public String getOrderByString() {
        return super.getOrderByString();
    }

    public void setID(String uid) throws ExWebDavPimException {
        if (uid != null) {
            this.setFilter(true);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.UID, ExWebDavPimFilterParam.LIKE, uid);
        }
    }

    public void setSender(String sender) throws PimException {
        if (sender != null) {
            this.setFilter(true);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.FROM, ExWebDavPimFilterParam.CONTAINS, sender);
        }
    }

    public void setUnread(boolean unread) throws PimException {
        this.setUnreadFilter(unread);
        this.getFilterCriteria().addWithoutOrderBy(WebDavField.READSTATUS, ExWebDavPimFilterParam.EQUAL_WITHOUT_QUOTES, unread ? "false" : "true");
    }

    public void setImportance(PimImportanceType importance) throws PimException {
        if (importance != null) {
            this.setFilter(true);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.IMPORTANCE, ExWebDavPimFilterParam.EQUAL_WITHOUT_QUOTES, ExWebDavPimImportanceTypeMapper.getType(importance));
        }
    }

    public void setStartTime(Date date) throws PimException {
        if (date != null) {
            this.setFilter(true);
            WebDavDate webDavDate = new WebDavDate(date);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.DATERECEIVED, ExWebDavPimFilterParam.GREATERTHAN, webDavDate.getWebDavDateFormat());
        }
    }

    public void setEndTime(Date date) throws PimException {
        if (date != null) {
            this.setFilter(true);
            WebDavDate webDavDate = new WebDavDate(date);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.DATERECEIVED, ExWebDavPimFilterParam.LESSTHAN, webDavDate.getWebDavDateFormat());
        }
    }

    public void setSubject(String subject) throws PimException {
        if (subject != null) {
            this.setFilter(true);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.SUBJECT, ExWebDavPimFilterParam.LIKE, subject);
        }
    }

    public void setBody(String body) throws PimException {
        if (body != null) {
            this.setFilter(true);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.BODY, ExWebDavPimFilterParam.LIKE, body);
        }
    }
}

