/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.exchangewebdav.ExWebDavPimAttachmentItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMailAttachmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAttachmentItem;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMailAttachmentItem;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimMailAttachmentItems
extends ExWebDavPimAttachmentItems
implements PimMailAttachmentItems {
    private boolean m_bIsInitializeCalled = false;

    public ExWebDavPimMailAttachmentItems(ExWebDavPimSession pimSession, Element element) {
        super(pimSession, element);
    }

    public void delete() throws ExWebDavPimException {
    }

    private String getHref() throws ExWebDavPimException {
        return XMLUtilities.getValue(this.getElement(), WebDavField.HREF);
    }

    private void initializeCache() throws ExWebDavPimException {
        ExWebDavPimMessageItemsCache cache = this.getCache();
        ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
        getAllItemsReqRes.setRequestXml(this.getAttachmentItemsXmlString());
        getAllItemsReqRes.setRequestMethod("X-MS-ENUMATTS");
        getAllItemsReqRes.setRequestFolder(this.getHref());
        cache.setAllItemsReqRes(getAllItemsReqRes);
        cache.setPageSize(this.getRequestPageSize());
        this.m_bIsInitializeCalled = true;
    }

    private String getAttachmentItemsXmlString() {
        Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
        toSend.add(new PropertyHolder(WebDavField.ATTACHMENTLIST, ""));
        toSend.add(new PropertyHolder(WebDavField.UID, ""));
        String xmlString = WebDavHelper.createPropFindXml(toSend);
        return xmlString;
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMailAttachmentItem getFirstMailAttachmentItem() throws ExWebDavPimException {
        try {
            return this.getMailAttachmentItem(this.getFirstIndex());
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailAttachmentItem getNextMailAttachmentItem() throws ExWebDavPimException {
        try {
            return this.getMailAttachmentItem(this.getNextIndex());
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailAttachmentItem getLastMailAttachmentItem() throws ExWebDavPimException {
        try {
            return this.getMailAttachmentItem(this.getLastIndex());
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailAttachmentItem getPreviousMailAttachmentItem() throws ExWebDavPimException {
        try {
            return this.getMailAttachmentItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            return this.getCache().getNumOfElements();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimMailAttachmentItem getMailAttachmentItem(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            return new ExWebDavPimOldMailAttachmentItem(this.getPimSession(), element);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailAttachmentItem getMailAttachmentItem(String id) throws ExWebDavPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            int count = this.getCache().getNumOfElements();
            int i = 0;
            while (i < count) {
                Element element = this.getCache().getElement(i);
                if (XMLUtilities.getValue(element, WebDavField.HREF).equals(id)) {
                    return new ExWebDavPimOldMailAttachmentItem(this.getPimSession(), element);
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailAttachmentItem addMailAttachmentItem() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getAttachmentItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getAttachmentItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addAttachmentItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstAttachmentItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextAttachmentItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastAttachmentItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousAttachmentItem();
    }

    public PimAttachmentItem getAttachmentItem(int itemNumber) throws ExWebDavPimException {
        return this.getMailAttachmentItem(itemNumber);
    }

    public PimAttachmentItem getAttachmentItem(String id) throws ExWebDavPimException {
        return this.getMailAttachmentItem(id);
    }

    public PimAttachmentItem addAttachmentItem() throws ExWebDavPimException {
        return this.addMailAttachmentItem();
    }

    public PimAttachmentItem getFirstAttachmentItem() throws ExWebDavPimException {
        return this.getFirstMailAttachmentItem();
    }

    public PimAttachmentItem getNextAttachmentItem() throws ExWebDavPimException {
        return this.getNextMailAttachmentItem();
    }

    public PimAttachmentItem getLastAttachmentItem() throws ExWebDavPimException {
        return this.getLastMailAttachmentItem();
    }

    public PimAttachmentItem getPreviousAttachmentItem() throws ExWebDavPimException {
        return this.getPreviousMailAttachmentItem();
    }
}

