/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimFolderItemsType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchangewebdav.ExWebDavPimCalendar;
import com.aligo.pim.exchangewebdav.ExWebDavPimDeleted;
import com.aligo.pim.exchangewebdav.ExWebDavPimDrafts;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimGeneral;
import com.aligo.pim.exchangewebdav.ExWebDavPimInbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimOutbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimSent;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.ExWebDavPimTask;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFolderCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimItem;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimFolders
extends ExWebDavPimItems
implements PimFolders {
    String m_szFolderName;
    private ExWebDavPimMessageItemsCache m_oCache;
    private boolean m_bIsInitializeCalled = false;

    public ExWebDavPimFolders(ExWebDavPimSession pimSession, String folderName) {
        super(pimSession);
        this.m_szFolderName = folderName;
        this.m_oCache = new ExWebDavPimMessageItemsCache(pimSession);
    }

    public ExWebDavPimMessageItemsCache getCache() {
        return this.m_oCache;
    }

    private String getFolderName() {
        if (this.m_szFolderName.indexOf(" ") != -1) {
            return StringUtility.replace(this.m_szFolderName, " ", "%20");
        }
        return this.m_szFolderName;
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            Vector fieldsVector = ExWebDavPimFolderCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String whereString = "\"" + WebDavField.ISFOLDER.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.EQUAL + "true";
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            int cacheCount;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((cacheCount = this.getCache().getNumOfElements()) != -1) {
                return cacheCount;
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getFolder(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            String folderName = XMLUtilities.getValue(element, WebDavField.DISPLAYNAME);
            String folderType = XMLUtilities.getValue(element, WebDavField.OUTLOOKFOLDERCLASS);
            String folderFullName = XMLUtilities.getValue(element, WebDavField.HREF);
            return this.getRespectivePimFolder(folderName, folderFullName, folderType);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getFolder(String id) throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder addFolder() throws ExWebDavPimException {
        return this.addFolder("Unknown");
    }

    public PimFolder addFolder(String name) throws ExWebDavPimException {
        return this.addFolder(name, PimFolderItemsType.MAIL_ITEMS);
    }

    public PimFolder addFolder(String name, PimFolderItemsType pimFolderItemsType) throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getRespectivePimFolder(String folderName, String folderFullName, String folderType) throws ExWebDavPimException {
        try {
            System.out.println("Fodler rype " + folderType);
            if (folderFullName != null) {
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getOutboxFullName(this.getPimSession()))) {
                    return new ExWebDavPimOutbox(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getSentItemsFullName(this.getPimSession()))) {
                    return new ExWebDavPimSent(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getDeletedItemsFullName(this.getPimSession()))) {
                    return new ExWebDavPimDeleted(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getDraftsFullName(this.getPimSession()))) {
                    return new ExWebDavPimDrafts(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getInboxFullName(this.getPimSession()))) {
                    return new ExWebDavPimInbox(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getCalendarFullName(this.getPimSession()))) {
                    return new ExWebDavPimCalendar(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getContactsFullName(this.getPimSession()))) {
                    return new ExWebDavPimPersonalAddressBook(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getJournalFullName(this.getPimSession()))) {
                    return new ExWebDavPimGeneral(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getNotesFullName(this.getPimSession()))) {
                    return new ExWebDavPimGeneral(this.getPimSession(), folderFullName, folderName);
                }
                if (folderFullName.equals(this.getPimSession().getPimFolderType().getTasksFullName(this.getPimSession()))) {
                    return new ExWebDavPimTask(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType == null) {
                    return new ExWebDavPimInbox(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.Note")) {
                    return new ExWebDavPimInbox(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.Appointment")) {
                    return new ExWebDavPimCalendar(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.Journal")) {
                    return new ExWebDavPimGeneral(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.StcikyNote")) {
                    return new ExWebDavPimGeneral(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.Task")) {
                    return new ExWebDavPimTask(this.getPimSession(), folderFullName, folderName);
                }
                if (folderType.equals("IPF.Contact")) {
                    return new ExWebDavPimPersonalAddressBook(this.getPimSession(), folderFullName, folderName);
                }
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
        return new ExWebDavPimGeneral(this.getPimSession(), folderFullName, folderName);
    }

    public PimFolder getFirstFolder() throws ExWebDavPimException {
        try {
            return this.getFolder(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getNextFolder() throws ExWebDavPimException {
        try {
            return this.getFolder(this.getNextIndex());
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimFolder getLastFolder() throws ExWebDavPimException {
        try {
            return this.getFolder(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFolder getPreviousFolder() throws ExWebDavPimException {
        try {
            return this.getFolder(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void sort(PimSortType pimSortType) throws ExWebDavPimException {
    }

    public void delete() throws ExWebDavPimException {
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getFolder(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getFolder(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addFolder();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstFolder();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextFolder();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastFolder();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousFolder();
    }
}

