/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimFilter;
import java.util.Vector;

public abstract class ExWebDavPimFilter
implements PimFilter {
    private FilterCriteria m_oFilterCriteria = new FilterCriteria();

    protected FilterCriteria getFilterCriteria() {
        return this.m_oFilterCriteria;
    }

    public String getWhereString() {
        return this.getFilterCriteria().getWhereString();
    }

    public String getOrderByString() {
        return this.getFilterCriteria().getOrderByString();
    }

    public void setOperand(PimFilterOperandType pimFilterOperandType) throws ExWebDavPimException {
        try {
            this.getFilterCriteria().add(pimFilterOperandType);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public abstract PimFieldItems getFieldItems() throws PimException;

    public class FilterCriteria {
        private Vector m_vWhereVector = new Vector();
        private Vector m_vOrderVector = new Vector();
        private boolean operandAdded = true;
        private boolean commaAdded = true;
        private boolean closeBracketAdded = false;

        public void add(WebDavField webDavField, ExWebDavPimFilterParam operator, String value) {
            this.add(webDavField, operator, value, true);
        }

        public void addWithoutOrderBy(WebDavField webDavField, ExWebDavPimFilterParam operator, String value) {
            this.add(webDavField, operator, value, false);
        }

        public void add(WebDavField webDavField, ExWebDavPimFilterParam operator, String value, boolean orderBy) {
            value = StringUtility.replace(value, "'", "''");
            if (this.closeBracketAdded) {
                this.add(PimFilterOperandType.AND);
            }
            if (this.operandAdded) {
                String completeString = new String();
                if (operator.equals(ExWebDavPimFilterParam.LIKE)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\" " + ExWebDavPimFilterParam.LIKE + " '" + value + "%'";
                } else if (operator.equals(ExWebDavPimFilterParam.CONTAINS)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.LIKE + "'%" + value + "%'";
                } else if (operator.equals(ExWebDavPimFilterParam.EQUAL)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.EQUAL + "'" + value + "'";
                } else if (operator.equals(ExWebDavPimFilterParam.NOTEQUAL)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.NOTEQUAL + "'" + value + "'";
                } else if (operator.equals(ExWebDavPimFilterParam.GREATERTHAN)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.GREATERTHAN + "'" + value + "'";
                } else if (operator.equals(ExWebDavPimFilterParam.LESSTHAN)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.LESSTHAN + " '" + value + "'";
                } else if (operator.equals(ExWebDavPimFilterParam.EQUAL_WITHOUT_QUOTES)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.EQUAL_WITHOUT_QUOTES + value;
                } else if (operator.equals(ExWebDavPimFilterParam.NOTEQUAL_WITHOUT_QUOTES)) {
                    completeString = "\"" + webDavField.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.NOTEQUAL_WITHOUT_QUOTES + value;
                }
                this.m_vWhereVector.add(completeString);
                if (orderBy) {
                    this.addOrderBy(webDavField);
                }
                this.operandAdded = false;
            } else {
                this.add(PimFilterOperandType.AND);
                this.add(webDavField, operator, value, orderBy);
            }
        }

        public void addOrderBy(WebDavField webDavField) {
            if (this.commaAdded) {
                this.m_vOrderVector.add("\"" + webDavField.getActualNameSpaceWithProperty() + "\" *TEMPL*");
                this.commaAdded = false;
            } else {
                this.m_vOrderVector.add(" , ");
                this.commaAdded = true;
                this.addOrderBy(webDavField);
            }
        }

        public void add(PimFilterOperandType pimFilterOperandType) {
            if (pimFilterOperandType.equals(PimFilterOperandType.OR)) {
                this.m_vWhereVector.add(" OR ");
                this.closeBracketAdded = false;
            } else if (pimFilterOperandType.equals(PimFilterOperandType.AND)) {
                this.m_vWhereVector.add(" AND ");
                this.closeBracketAdded = false;
            } else if (pimFilterOperandType.equals(PimFilterOperandType.OPEN)) {
                if (this.closeBracketAdded) {
                    this.add(PimFilterOperandType.AND);
                }
                this.m_vWhereVector.add("(");
                this.closeBracketAdded = false;
            } else if (pimFilterOperandType.equals(PimFilterOperandType.CLOSE)) {
                this.m_vWhereVector.add(")");
                this.closeBracketAdded = true;
            }
            this.operandAdded = true;
        }

        public String getOrderByString() {
            StringBuffer strb = new StringBuffer();
            int i = 0;
            while (i < this.m_vOrderVector.size()) {
                strb.append(this.m_vOrderVector.elementAt(i));
                ++i;
            }
            return strb.toString();
        }

        public String getWhereString() {
            StringBuffer strb = new StringBuffer();
            int i = 0;
            while (i < this.m_vWhereVector.size()) {
                strb.append(this.m_vWhereVector.elementAt(i));
                ++i;
            }
            return strb.toString();
        }
    }
}

