/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import com.aligo.pim.PimFieldType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.HTTPField;
import com.aligo.pim.exchangewebdav.util.HTTPFieldValue;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import java.util.Vector;

public abstract class ExWebDavPimDistListMemberItems
extends ExWebDavPimMessageItems
implements PimAddressEntryItems {
    protected ExWebDavPimDistListMemberItems(ExWebDavPimSession pimSession) {
        super(pimSession);
    }

    public abstract String getDistListHREF() throws ExWebDavPimException;

    public abstract Vector getNewAddressEntryItems() throws ExWebDavPimException;

    public void update() throws ExWebDavPimException {
        try {
            Vector m_vAddressEntryItems = this.getNewAddressEntryItems();
            int i = 0;
            while (i < m_vAddressEntryItems.size()) {
                PimAddressEntryItem pimAddressEntryItem = (PimAddressEntryItem)m_vAddressEntryItems.elementAt(i);
                String name = pimAddressEntryItem.getName();
                String emailAddress = pimAddressEntryItem.getEmailAddress();
                String member = "";
                if (emailAddress == null || emailAddress.equals("")) {
                    throw new ExWebDavPimException(83L);
                }
                if (!StringUtility.isItValidEmail(emailAddress)) {
                    throw new ExWebDavPimException(71L);
                }
                if (StringUtility.isItValid(name) && StringUtility.isItValidEmail(emailAddress)) {
                    member = name + "[smtp:" + emailAddress + "]";
                } else if (StringUtility.isItValid(name)) {
                    member = name;
                } else if (StringUtility.isItValidEmail(emailAddress)) {
                    member = emailAddress;
                }
                if (StringUtility.isItValid(member)) {
                    NVPair[] body = new NVPair[]{new NVPair(HTTPField.COMMAND.getFieldName(), HTTPFieldValue.ADD_MEMBER.getFieldValue()), new NVPair(HTTPField.MSGCLASS.getFieldName(), HTTPFieldValue.IPM_DISTLIST.getFieldValue()), new NVPair(HTTPField.MEMBER.getFieldName(), member)};
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestAsPostReturnAsXml(this.getDistListHREF(), body);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public abstract PimAddressEntryItem getPreviousAddressEntryItem() throws PimException;

    public abstract PimAddressEntryItem getLastAddressEntryItem() throws PimException;

    public abstract PimAddressEntryItem getNextAddressEntryItem() throws PimException;

    public abstract PimAddressEntryItem getFirstAddressEntryItem() throws PimException;

    public abstract void setOrderBy(PimFieldType[] var1) throws PimException;

    public abstract void addAddressEntryItem(PimAddressEntryItem var1) throws PimException;

    public abstract PimAddressEntryItem addAddressEntryItem() throws PimException;

    public abstract PimAddressEntryItem getAddressEntryItem(String var1) throws PimException;

    public abstract PimAddressEntryItem getAddressEntryItem(int var1) throws PimException;

    public abstract PimAddressEntryItemFilter getAddressEntryItemFilter() throws PimException;
}

