/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimDeleted;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimGeneralItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMailItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldMeetingItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldPersonalAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldTaskItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAddressEntryItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAppointmentItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFolderCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMailMessageItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTaskItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimDeletedItem;
import com.aligo.pim.interfaces.PimDeletedItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimDeletedItems
extends ExWebDavPimMessageItems
implements PimDeletedItems {
    private ExWebDavPimDeleted m_oPimDeleted;
    private boolean m_bIsInitializeCalled = false;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private ExWebDavPimMessageItemsCache m_oCache;

    public ExWebDavPimDeletedItems(ExWebDavPimDeleted pimDeleted, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimDeleted = pimDeleted;
        this.m_oCache = new ExWebDavPimMessageItemsCache(pimSession);
    }

    public PimDeletedItem addDeletedItem() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimMessageItemsCache getCache() {
        return this.m_oCache;
    }

    public ExWebDavPimDeleted getPimDeleted() {
        return this.m_oPimDeleted;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimDeleted().getFolderName();
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector selectVector = new Vector();
            String fromString = this.getFolderName();
            String whereString = "\"" + WebDavField.ISFOLDER.getActualNameSpaceWithProperty() + "\"" + ExWebDavPimFilterParam.EQUAL + "false";
            selectVector = this.fillFields(selectVector, ExWebDavPimAppointmentItemCacheHelper.getFieldsToCache());
            selectVector = this.fillFields(selectVector, ExWebDavPimAddressEntryItemCacheHelper.getFieldsToCache());
            selectVector = this.fillFields(selectVector, ExWebDavPimFolderCacheHelper.getFieldsToCache());
            selectVector = this.fillFields(selectVector, ExWebDavPimMailMessageItemCacheHelper.getFieldsToCache());
            selectVector = this.fillFields(selectVector, ExWebDavPimTaskItemCacheHelper.getFieldsToCache());
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private Vector fillFields(Vector selectVector, Vector fieldsToCache) {
        int size = fieldsToCache.size();
        int i = 0;
        while (i < size) {
            selectVector.add(new PropertyHolder((WebDavField)fieldsToCache.elementAt(i)));
            ++i;
        }
        return selectVector;
    }

    public int getCount() throws ExWebDavPimException {
        try {
            int cacheCount;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((cacheCount = this.getCache().getNumOfElements()) != -1) {
                return cacheCount;
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimMessageItem getDeletedItem(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            return this.returnPimItem(element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem getDeletedItem(String id) throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem getFirstDeletedItem() throws ExWebDavPimException {
        try {
            return this.getDeletedItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem getNextDeletedItem() throws ExWebDavPimException {
        try {
            return this.getDeletedItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem getLastDeletedItem() throws ExWebDavPimException {
        try {
            return this.getDeletedItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem getPreviousDeletedItem() throws ExWebDavPimException {
        try {
            return this.getDeletedItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void delete(String[] ids) throws ExWebDavPimException {
        try {
            int length = ids.length;
            int i = 0;
            while (i < length) {
                ExWebDavPimOldMailItem exchangePimMailItem = (ExWebDavPimOldMailItem)this.getDeletedItem(ids[i]);
                exchangePimMailItem.delete();
                ++i;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                this.m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws PimException {
        return null;
    }

    public PimMessageItem getMessageItem(int itemNumber) throws PimException {
        return this.getDeletedItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws PimException {
        return this.getDeletedItem(id);
    }

    public PimMessageItem addMessageItem() throws PimException {
        return this.addDeletedItem();
    }

    public PimMessageItem getFirstMessageItem() throws PimException {
        return this.getFirstDeletedItem();
    }

    public PimMessageItem getNextMessageItem() throws PimException {
        return this.getNextDeletedItem();
    }

    public PimMessageItem getLastMessageItem() throws PimException {
        return this.getLastDeletedItem();
    }

    public PimMessageItem getPreviousMessageItem() throws PimException {
        return this.getPreviousDeletedItem();
    }

    public PimItem getItem(int itemNumber) throws PimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws PimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws PimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws PimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws PimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws PimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws PimException {
        return this.getPreviousMessageItem();
    }

    private PimMessageItem returnPimItem(Element element) throws ExWebDavPimException {
        String classType = XMLUtilities.getValue(element, WebDavField.CLASSTYPE);
        if (classType.equals("IPM.Schedule.Meeting.Request") || classType.equals("IPM.Schedule.Meeting.Response") || classType.equals("IPM.Schedule.Meeting.Canceled")) {
            return new ExWebDavPimOldMeetingItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equals("IPM.Note")) {
            return new ExWebDavPimOldMailItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equals("IPM.Appointment")) {
            return new ExWebDavPimOldAppointmentItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equalsIgnoreCase("IPM.Contact") || classType.equals("IPM.DistList")) {
            return new ExWebDavPimOldPersonalAddressEntryItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equals("IPM.Task")) {
            return new ExWebDavPimOldTaskItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equals("IPM.Activity")) {
            return new ExWebDavPimGeneralItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        if (classType.equals("IPM.StickyNote")) {
            return new ExWebDavPimGeneralItem(this.getPimSession(), this.getPimDeleted(), element);
        }
        return new ExWebDavPimGeneralItem(this.getPimSession(), this.getPimDeleted(), element);
    }
}

