/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.ExWebDavPimUserInfo;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimUserInfo;

public class ExWebDavPimContainer
implements PimContainer {
    private ExWebDavPimUserInfo m_oPimUserInfo;
    private ExWebDavPimSession m_oPimSession;
    private boolean m_bLoggedOn;

    public PimUserInfo addUserInfo() {
        this.m_oPimUserInfo = new ExWebDavPimUserInfo();
        return this.m_oPimUserInfo;
    }

    public void logon() throws PimException {
        if (this.m_oPimUserInfo == null) {
            throw new ExWebDavPimException(2L);
        }
        if (this.m_bLoggedOn) {
            this.logoff();
        }
        this.m_oPimSession = new ExWebDavPimSession(this.m_oPimUserInfo);
        this.m_oPimSession.logon();
        this.m_bLoggedOn = true;
    }

    public void logoff() throws PimException {
        if (!this.m_bLoggedOn) {
            throw new ExWebDavPimException(9L);
        }
        this.m_oPimSession = null;
        this.m_bLoggedOn = false;
    }

    public PimFolder getFolder(PimFolderType folderType) throws PimException {
        return this.getFolder(folderType, null);
    }

    public ExWebDavPimSession getExWebDavPimSession() throws ExWebDavPimException {
        return this.m_oPimSession;
    }

    public PimFolder getFolder(PimFolderType folderType, String user) throws PimException {
        if (!this.m_bLoggedOn) {
            throw new ExWebDavPimException(9L);
        }
        if (PimFolderType.PERSONAL_ADDRESS_BOOK.equals(folderType)) {
            return this.getExWebDavPimSession().getContact(user);
        }
        if (PimFolderType.CALENDAR.equals(folderType)) {
            return this.getExWebDavPimSession().getCalendar(user);
        }
        if (PimFolderType.INBOX.equals(folderType)) {
            return this.getExWebDavPimSession().getInbox(user);
        }
        if (PimFolderType.OUTBOX.equals(folderType)) {
            return this.getExWebDavPimSession().getOutbox(user);
        }
        if (PimFolderType.GLOBAL_ADDRESS_BOOK.equals(folderType)) {
            return this.getExWebDavPimSession().getGlobalAddressBook(user);
        }
        if (PimFolderType.TASK.equals(folderType)) {
            return this.getExWebDavPimSession().getTask(user);
        }
        return null;
    }

    public PimFolder getFolder(String nameOfFolder) throws PimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getCurrentUser() throws PimException {
        if (!this.m_bLoggedOn) {
            throw new ExWebDavPimException(9L);
        }
        return this.m_oPimSession.getCurrentUser();
    }

    public void setTimeZone(PimTimeZoneType pimTimeZone) throws PimException {
        if (this.m_bLoggedOn) {
            this.m_oPimSession.setTimeZone(pimTimeZone);
        }
    }

    public PimFolder getRootFolder() throws PimException {
        return this.getExWebDavPimSession().getPrivateRootFolder();
    }

    public PimFolder getPublicRootFolder() throws PimException {
        return this.getExWebDavPimSession().getPublicRootFolder();
    }
}

