/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimFieldItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAttachmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.w3c.dom.Element;

public class ExWebDavPimAttachmentItem
extends ExWebDavPimItem
implements PimAttachmentItem {
    Element m_oElement;
    private ExWebDavPimFieldItems m_oPimFieldItems;

    public ExWebDavPimAttachmentItem(ExWebDavPimSession pimSession, Element element) {
        super(pimSession);
        this.m_oElement = element;
    }

    public void setElement(Element element) {
        this.m_oElement = element;
    }

    public Element getElement() {
        return this.m_oElement;
    }

    public String getURL() throws ExWebDavPimException {
        return this.getHref();
    }

    public String getMimeType() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.ATTACHMENTMIMETYPE);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private String getHref() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return new ExWebDavPimFieldItems(this.m_oElement);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getName() throws ExWebDavPimException {
        try {
            String name = XMLUtilities.getValue(this.m_oElement, WebDavField.ATTACHMENTFILENAME);
            if (name == null && (name = this.getHref()).indexOf("/") != -1) {
                int pos = name.lastIndexOf("/");
                name = name.substring(pos + 1);
            }
            return name;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setName(String name) throws ExWebDavPimException {
    }

    public void setSource(String source) throws ExWebDavPimException {
    }

    public InputStream getInputStream() throws ExWebDavPimException {
        try {
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("GET", this.getHref(), "");
            return response.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExWebDavPimException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToFile(String fileName) throws ExWebDavPimException {
        try {
            int c;
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            InputStream in = this.getInputStream();
            while ((c = in.read()) != -1) {
                void var4_5;
                fileOutputStream.write((int)var4_5);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void readFromFile(String fileName) throws ExWebDavPimException {
    }

    public void update() throws ExWebDavPimException {
    }

    public String getID() throws ExWebDavPimException {
        return XMLUtilities.getValue(this.m_oElement, WebDavField.HREF);
    }

    public long getSize() throws ExWebDavPimException {
        try {
            String contentLengthStr = XMLUtilities.getValue(this.m_oElement, WebDavField.ATTACHMENTSIZE);
            if (contentLengthStr != null) {
                Long contentLength = new Long(contentLengthStr);
                return contentLength;
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }
}

