/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimCalendar;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimAppointmentItemCacheHelper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimMessageItemsCache;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.StringUtility;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.WebDavMapiFieldHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimAppointmentItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimAppointmentItems
extends ExWebDavPimMessageItems
implements PimAppointmentItems {
    private ExWebDavPimCalendar m_oPimCalendar;
    private ExWebDavPimAppointmentItemFilter m_oPimAppointmentItemFilter;
    private boolean m_bIsInitializeCalled = false;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private boolean m_bIsAppointmentItemFilterCalled;

    public ExWebDavPimAppointmentItems(ExWebDavPimCalendar pimCalendar, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimCalendar = pimCalendar;
        this.m_oPimAppointmentItemFilter = new ExWebDavPimAppointmentItemFilter();
    }

    public PimAppointmentItem addAppointmentItem() throws ExWebDavPimException {
        return new ExWebDavPimNewAppointmentItem(this.getPimSession(), this.getPimCalendar());
    }

    public PimAppointmentItemFilter getAppointmentItemFilter() throws ExWebDavPimException {
        try {
            this.m_bIsAppointmentItemFilterCalled = true;
            return this.m_oPimAppointmentItemFilter;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimCalendar getPimCalendar() {
        return this.m_oPimCalendar;
    }

    public String getFolderName() throws ExWebDavPimException {
        return this.getPimCalendar().getFolderName();
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            ExWebDavPimMessageItemsCache cache = this.getCache();
            ExWebDavPimRequestResponse countreqres = new ExWebDavPimRequestResponse();
            countreqres.setRequestXml(this.getCountXmlString());
            countreqres.setRequestMethod("PROPFIND");
            countreqres.setRequestFolder(this.getFolderName());
            countreqres.setResponseField(WebDavField.VISIBLECOUNT);
            cache.setCountReqRes(countreqres);
            ExWebDavPimRequestResponse getAllItemsReqRes = new ExWebDavPimRequestResponse();
            getAllItemsReqRes.setRequestXml(this.getAllItemsXmlString());
            getAllItemsReqRes.setRequestMethod("SEARCH");
            getAllItemsReqRes.setRequestFolder(this.getFolderName());
            getAllItemsReqRes.setResponseField(WebDavField.RESPONSE);
            cache.setAllItemsReqRes(getAllItemsReqRes);
            cache.setPageSize(this.getRequestPageSize());
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getCountXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> countVector = new Vector<PropertyHolder>();
            countVector.add(new PropertyHolder(WebDavField.VISIBLECOUNT));
            String xmlstring = WebDavHelper.createPropFindXml(countVector);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getAllItemsXmlString() throws ExWebDavPimException {
        try {
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            String whereString = this.m_oPimAppointmentItemFilter.getWhereString();
            String orderByString = this.m_oPimAppointmentItemFilter.getOrderByString();
            Vector fieldsVector = ExWebDavPimAppointmentItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, orderByString, this.m_oPimSortType);
            return xmlstring;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            int cacheCount;
            if (this.m_bIsAppointmentItemFilterCalled && !this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if (this.m_bIsAppointmentItemFilterCalled) {
                this.getCache().setPageSize(-1);
            }
            if ((cacheCount = this.getCache().getNumOfElements()) != -1) {
                return cacheCount;
            }
            String xmlstring = this.getCountXmlString();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendPropFind(this.getFolderName(), xmlstring);
            String count = XMLUtilities.getValue(response.getText(), WebDavField.VISIBLECOUNT);
            return Integer.parseInt(count);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimAppointmentItem getAppointmentItem(int itemNumber) throws ExWebDavPimException {
        try {
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = this.getCache().getElement(itemNumber)) == null) {
                return null;
            }
            ExWebDavPimOldAppointmentItem pimOldAppointmentItem = new ExWebDavPimOldAppointmentItem(this.getPimSession(), this.getPimCalendar(), element);
            return pimOldAppointmentItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAppointmentItem getAppointmentItem(String id) throws ExWebDavPimException {
        try {
            if (id == null) {
                return null;
            }
            Vector<PropertyHolder> selectVector = new Vector<PropertyHolder>();
            String fromString = this.getFolderName();
            ExWebDavPimAppointmentItemFilter uidFilter = new ExWebDavPimAppointmentItemFilter();
            uidFilter.setID(id);
            String whereString = uidFilter.getWhereString();
            Vector fieldsVector = ExWebDavPimAppointmentItemCacheHelper.getFieldsToCache();
            int i = 0;
            while (i < fieldsVector.size()) {
                selectVector.add(new PropertyHolder((WebDavField)fieldsVector.elementAt(i)));
                ++i;
            }
            String xmlstring = WebDavHelper.createSearchRequestXml(selectVector, fromString, whereString, null, null);
            HTTPResponse response = this.getPimSession().getHttpConnector().sendSearch(this.getFolderName(), xmlstring);
            String text = StringUtility.getTextAfterEncoding(response);
            int numOfElements = XMLUtilities.getNumOfElements(this.replaceMapiFields(text), WebDavField.RESPONSE);
            Element element = null;
            int i2 = 0;
            while (i2 < numOfElements) {
                String retrievedId;
                element = XMLUtilities.getValueAsElement(this.replaceMapiFields(text), WebDavField.RESPONSE, i2);
                if (element != null && (retrievedId = XMLUtilities.getValue(element, WebDavField.UID)).equals(id)) break;
                ++i2;
            }
            if (element == null) {
                return null;
            }
            ExWebDavPimOldAppointmentItem pimOldAppointmentItem = new ExWebDavPimOldAppointmentItem(this.getPimSession(), this.getPimCalendar(), element);
            return pimOldAppointmentItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAppointmentItem getFirstAppointmentItem() throws ExWebDavPimException {
        try {
            return this.getAppointmentItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAppointmentItem getNextAppointmentItem() throws ExWebDavPimException {
        try {
            return this.getAppointmentItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAppointmentItem getLastAppointmentItem() throws ExWebDavPimException {
        try {
            return this.getAppointmentItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAppointmentItem getPreviousAppointmentItem() throws ExWebDavPimException {
        try {
            return this.getAppointmentItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                this.m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getAppointmentItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getAppointmentItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getAppointmentItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstAppointmentItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextAppointmentItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastAppointmentItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousAppointmentItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addAppointmentItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    private String replaceMapiFields(String response) {
        response = this.replaceMapiField(WebDavField.MAPI_RESPONSESTATUS, response);
        response = this.replaceMapiField(WebDavField.MAPI_APPOINTMENTSTATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_STATUS, response);
        response = this.replaceMapiField(WebDavField.TASK_PERCENTAGE_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_TEAM_TASK, response);
        response = this.replaceMapiField(WebDavField.TASK_START_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_END_DATE, response);
        response = this.replaceMapiField(WebDavField.TASK_DATE_COMPLETED, response);
        response = this.replaceMapiField(WebDavField.TASK_ACTUAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_TOTAL_WORK, response);
        response = this.replaceMapiField(WebDavField.TASK_STATE, response);
        response = this.replaceMapiField(WebDavField.TASK_COMPLETE, response);
        response = this.replaceMapiField(WebDavField.TASK_OWNER, response);
        response = this.replaceMapiField(WebDavField.TASK_IS_RECURRING, response);
        return response;
    }

    private String replaceMapiField(WebDavField webDavField, String response) {
        String lookingValue = webDavField.getPropertyName();
        String replaceValue = WebDavMapiFieldHelper.getReplceValue(webDavField);
        if (response.indexOf(lookingValue) != -1) {
            response = StringUtility.replace(response, lookingValue, replaceValue);
        }
        return response;
    }
}

