/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import com.aligo.pim.PimFilterOperandType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItemFilter;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFilterParam;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimFieldItems;
import java.util.Date;

public class ExWebDavPimAppointmentItemFilter
extends ExWebDavPimMessageItemFilter
implements PimAppointmentItemFilter {
    public ExWebDavPimAppointmentItemFilter() throws ExWebDavPimException {
        try {
            this.setOperand(PimFilterOperandType.OPEN);
            this.getFilterCriteria().add(WebDavField.OUTLOOKMESSAGECLASS, ExWebDavPimFilterParam.EQUAL, "IPM.Appointment");
            this.setOperand(PimFilterOperandType.OR);
            this.getFilterCriteria().add(WebDavField.CONTENTCLASS, ExWebDavPimFilterParam.EQUAL, "urn:content-classes:appointment");
            this.setOperand(PimFilterOperandType.CLOSE);
            this.setOperand(PimFilterOperandType.OPEN);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.INSTANCETYPE, ExWebDavPimFilterParam.NOTEQUAL_WITHOUT_QUOTES, "1");
            this.setOperand(PimFilterOperandType.CLOSE);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        return null;
    }

    public void setEndTime(Date date) throws ExWebDavPimException {
        if (date != null) {
            WebDavDate webDavDate = new WebDavDate(date);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.DTEND, ExWebDavPimFilterParam.LESSTHAN, webDavDate.getWebDavDateFormat());
        }
    }

    public void setImportance(PimImportanceType importance) throws ExWebDavPimException {
        if (importance != null) {
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.PRIORITY, ExWebDavPimFilterParam.EQUAL_WITHOUT_QUOTES, ExWebDavPimImportanceTypeMapper.getType(importance));
        }
    }

    public void setStartTime(Date date) throws ExWebDavPimException {
        if (date != null) {
            WebDavDate webDavDate = new WebDavDate(date);
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.DTSTART, ExWebDavPimFilterParam.GREATERTHAN, webDavDate.getWebDavDateFormat());
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        if (subject != null) {
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.SUBJECT, ExWebDavPimFilterParam.LIKE, subject);
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        if (text != null) {
            this.getFilterCriteria().addWithoutOrderBy(WebDavField.BODY, ExWebDavPimFilterParam.LIKE, text);
        }
    }

    public void setID(String uid) throws ExWebDavPimException {
        if (uid != null) {
            this.getFilterCriteria().add(WebDavField.UID, ExWebDavPimFilterParam.LIKE, uid);
        }
    }

    public void setDisplayName(String displayName) throws ExWebDavPimException {
        if (displayName != null) {
            this.getFilterCriteria().add(WebDavField.DISPLAYNAME, ExWebDavPimFilterParam.EQUAL, displayName);
        }
    }
}

