/*
 * Decompiled with CFR 0.152.
 */
package migration_is60.modules.srap.netfile;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import migration_is60.modules.srap.netfile.NetfileOrgData;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class NetfileMigrate {
    private String inputFile;
    private String outputFile;
    static final String SERVICE_NAME_DELIM = "ou=srapNetFileService,ou=services,";
    static final int SERVICE_NAME_DELIM_LEN = "ou=srapNetFileService,ou=services,".length();

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage : <input ldiff file> , <output xml file>");
            System.exit(0);
        }
        NetfileMigrate mig = new NetfileMigrate(args[0], args[1]);
        mig.migrate();
        System.exit(0);
    }

    public NetfileMigrate(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    void migrate() {
        int count = 0;
        try {
            LDIF l1 = new LDIF(this.inputFile);
            FileWriter outFile = new FileWriter(this.outputFile);
            LDIFRecord tmp = l1.nextRecord();
            NetfileMigrate.printHeader(outFile);
            while (tmp != null) {
                System.out.println("\n # Entry id:" + count);
                ++count;
                NetfileOrgData data = this.ConvertRecord(tmp);
                try {
                    this.OutputRecord(outFile, data);
                }
                catch (Exception e) {
                    System.out.println("Error writing to output file:" + this.outputFile);
                    e.printStackTrace();
                }
                tmp = l1.nextRecord();
            }
            outFile.write("\n</Requests>");
            outFile.close();
            System.out.println("Processed " + count + " entries");
            System.out.println("Output available in file " + this.outputFile);
        }
        catch (IOException e) {
            System.out.println("Error:" + e.toString());
            e.printStackTrace();
        }
    }

    NetfileOrgData ConvertRecord(LDIFRecord toConvert) {
        String org = NetfileMigrate.getOrgName(toConvert.getDN());
        LDIFAttributeContent con = (LDIFAttributeContent)toConvert.getContent();
        LDAPAttribute[] attrList = con.getAttributes();
        LDAPAttributeSet theAttrSet = new LDAPAttributeSet(attrList);
        NetfileOrgData data = new NetfileOrgData(org);
        for (int i = 0; i < attrList.length; ++i) {
            String attrName = attrList[i].getName();
            String[] allAttrs = theAttrSet.getAttribute(attrList[i].getName()).getStringValueArray();
            data.handleAttribute(attrName, allAttrs);
        }
        return data;
    }

    static String getOrgName(String dn) {
        int indx = dn.indexOf(SERVICE_NAME_DELIM);
        if (indx == -1) {
            System.out.println("Inavlid org name : " + dn);
            throw new RuntimeException("Inavlid org name : " + dn);
        }
        return dn.substring(indx + SERVICE_NAME_DELIM_LEN);
    }

    static void printHeader(FileWriter outFile) throws IOException {
        ResourceBundle ambundle = ResourceBundle.getBundle("AMConfig");
        String IDSAMEBaseDir = new String();
        if (ambundle.getObject("com.iplanet.am.installdir") != null) {
            IDSAMEBaseDir = (String)ambundle.getObject("com.iplanet.am.installdir");
            IDSAMEBaseDir = IDSAMEBaseDir.substring(0, IDSAMEBaseDir.indexOf("SUNWam"));
        }
        outFile.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        outFile.write("\n<!--  PROPRIETARY/CONFIDENTIAL/ Use of this product is subject");
        outFile.write("\n to license terms. Copyright 2001 Sun Microsystems Inc.");
        outFile.write("Some preexisting portions Copyright 2001 Netscape");
        outFile.write("Communications Corp. All rights reserved. -->");
        outFile.write("\n<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN \" ");
        outFile.write("\"file:" + IDSAMEBaseDir + "SUNWam/dtd/amAdmin.dtd\">");
        outFile.write("\n<Requests>");
    }

    void OutputRecord(FileWriter outFile, NetfileOrgData data) throws IOException {
        if (data.isNull()) {
            return;
        }
        if (data.tempDir != null) {
            outFile.write("\n<OrganizationRequests DN=\"" + data.org + "\">");
            outFile.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileTempDir\"/>");
            outFile.write("\n        <Value>" + data.tempDir);
            outFile.write("</Value>");
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyServiceTemplate>");
            outFile.write("\n</OrganizationRequests>");
        }
        if (data.osCharSet != null) {
            outFile.write("\n<OrganizationRequests DN=\"" + data.org + "\">");
            outFile.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileOSCharSet\"/>");
            outFile.write("\n        <Value>" + data.osCharSet);
            outFile.write("</Value>");
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyServiceTemplate>");
            outFile.write("\n</OrganizationRequests>");
        }
        if (data.mimetypesConfigFileLocation != null) {
            outFile.write("\n<OrganizationRequests DN=\"" + data.org + "\">");
            outFile.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileMimetypesConfigFileLocation\"/>");
            outFile.write("\n        <Value>" + data.mimetypesConfigFileLocation);
            outFile.write("</Value>");
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyServiceTemplate>");
            outFile.write("\n</OrganizationRequests>");
        }
    }
}

