/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.PBEPasswordContext;
import com.sun.portal.cli.cert.SRADecoder;
import com.sun.portal.cli.cert.SRADecoderContext;
import com.sun.portal.cli.cert.SRADecoderContextImpl;
import com.sun.portal.cli.cert.SRADecoderException;
import java.security.MessageDigest;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class SRAPBEImpl
extends SRADecoder
implements PBEPasswordContext {
    private String certdir;
    private static final String SECURE_PASS_DERIVATOR = "spd";

    public SRAPBEImpl(String certdir) {
        this.certdir = certdir;
    }

    public void init() throws SRADecoderException {
        this.decoderCntx = this.getDecoderContext();
        try {
            Security.insertProviderAt(this.decoderCntx.getDefaultProvider(), 1);
            Security.insertProviderAt(this.decoderCntx.getProvider(), 2);
            this.paramSpec = new PBEParameterSpec(this.decoderCntx.getSalt(), 20);
            PBEKeySpec keySpec = new PBEKeySpec(this.getPassword().toCharArray());
            SecretKeyFactory kf = SecretKeyFactory.getInstance(this.decoderCntx.getSecretKeyAlgorithm(), this.decoderCntx.getProvider().getName());
            this.secretKey = kf.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(this.decoderCntx.getEncAlgorithm(), this.decoderCntx.getProvider().getName());
            this.digest = MessageDigest.getInstance(this.decoderCntx.getDigestAlgorithm(), this.decoderCntx.getDefaultProvider().getName());
        }
        catch (Exception ex) {
            throw new SRADecoderException(ex.toString());
        }
    }

    protected SRADecoderContext getDecoderContext() {
        if (this.decoderCntx != null) {
            return this.decoderCntx;
        }
        return new SRADecoderContextImpl();
    }

    public String getPassword() {
        try {
            return this.getEncodedStr(this.getPasswd(this.certdir));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private native byte[] getPasswd(String var1) throws Exception;

    static {
        System.loadLibrary(SECURE_PASS_DERIVATOR);
    }
}

