/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.File;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class InstallCertificate
implements Command {
    public boolean execute(JSSContext cntx) {
        CertAdminHelpText.getCertHelpText();
        String certfile = CertAdminUtil.question(CertAdminLocale.getPFString("q15", "What is the name (including path) of file that contains the certificate ?"));
        File file = new File(certfile);
        if (!file.exists()) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m23", "Certificate file") + " " + certfile + " " + CertAdminLocale.getPFString("m231", "doesn't exist!"));
            return false;
        }
        String tmpnick = "server-cert";
        String nick = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + tmpnick + CertAdminLocale.getPFString("q1", "]"));
        if (nick.trim().equals("")) {
            nick = tmpnick;
        }
        while (JSSUtil.certExist(cntx, nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m26", "Certificate") + " " + nick + " " + CertAdminLocale.getPFString("m261", " already exist. Choose another nickname!"));
            nick = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + tmpnick + CertAdminLocale.getPFString("q1", "]"));
            if (!nick.trim().equals("")) continue;
            nick = tmpnick;
        }
        String token = CertAdminUtil.question(CertAdminLocale.getPFString("q16", "Enter the token name you used when creating CSR for this certificate []"));
        try {
            CertAdminPasswordCallback password;
            String passphrase = cntx.getPasswordContext().generatePassphrase(cntx);
            CryptoToken tok = null;
            if (token.trim().equals("")) {
                tok = cntx.getCryptoManager().getInternalKeyStorageToken();
                password = new CertAdminPasswordCallback(passphrase);
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            } else {
                tok = cntx.getCryptoManager().getTokenByName(token);
                password = new ConsolePasswordCallback();
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            }
            tok.login((PasswordCallback)password);
            X509Certificate cert = JSSUtil.addCertificate(cntx, file, nick, false);
            String nickfile = cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(nickfile) && !CertAdminUtil.delete(nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(nick, nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m27", "Certificate successfully installed"));
            CertAdminUtil.println(CertAdminLocale.getPFString("m28", "To use the new Certificate, you must (re)start the server"));
            return true;
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m29", "Could not install certificate!"));
            ex.printStackTrace();
            return false;
        }
    }
}

