/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portlet.impl.PortletsResources;
import com.sun.portal.portletappengine.LifecycleManager;
import com.sun.portal.portletappengine.PortletAppEngineConstants;
import com.sun.portal.portletappengine.PortletAppEngineUtils;
import com.sun.portal.portletappengine.RequestResponseFactory;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerErrorCode;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.portletcontainercommon.PreferencesValidatorSetter;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityConstraintDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowStateException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletAppEngineServlet
extends HttpServlet {
    private static final String GET = "get";
    private static final char DELIMETER = '|';
    private static final String JAVAX_PORTLET_ENTITY_ID = "javax.portlet.entityID";
    private static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    public static final String CONFIDENTIAL = "CONFIDENTIAL";
    public static final String INTEGRAL = "INTEGRAL";
    private LifecycleManager _lifecycleManager;
    private RequestResponseFactory _requestResponseFactory;
    private Logger _logger;
    private PortletAppDescriptor _descriptor;
    private ServletContext _context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._lifecycleManager = (LifecycleManager)config.getServletContext().getAttribute("lifecycle_manager");
        this._requestResponseFactory = (RequestResponseFactory)config.getServletContext().getAttribute("request_response_factory");
        this._logger = this._lifecycleManager.getLogger();
        this._descriptor = this._lifecycleManager.getDeploymentDescriptor();
        this._context = config.getServletContext();
        this._context.setAttribute("portlet_resources", (Object)new PortletsResources(this._descriptor, this._logger).getPortletResourceMap());
    }

    public void getTitle(HttpServletRequest req, HttpServletResponse resp) {
        String entityID = (String)req.getAttribute(JAVAX_PORTLET_ENTITY_ID);
        String portletName = entityID.substring(entityID.indexOf(124) + 1, entityID.lastIndexOf(124));
        PortletDescriptor pd = this.getPortletDescriptor(portletName);
        String rbName = pd.getResourceBundle();
        String title = null;
        if (rbName != null && rbName.length() > 0) {
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle(rbName, req.getLocale(), Thread.currentThread().getContextClassLoader());
                if (rb != null) {
                    title = rb.getString(JAVAX_PORTLET_TITLE);
                }
            }
            catch (Exception e) {
                this._logger.logp(Level.SEVERE, "PortletAppEngineSevlet", "getTitle()", "Exception.." + e);
            }
        }
        if (title != null && title.length() > 0) {
            req.setAttribute(JAVAX_PORTLET_TITLE, (Object)title);
        } else {
            req.removeAttribute(JAVAX_PORTLET_TITLE);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String portletTitle = (String)req.getAttribute(JAVAX_PORTLET_TITLE);
        if (portletTitle != null && portletTitle.length() > 0 && portletTitle.equalsIgnoreCase(GET)) {
            this.getTitle(req, res);
            return;
        }
        StringWriter writer = new StringWriter(PortletAppEngineConstants.INITIAL_BUFFER_SIZE);
        ByteArrayOutputStream output = new ByteArrayOutputStream(PortletAppEngineConstants.INITIAL_BUFFER_SIZE);
        ActionRequest aReq = null;
        RenderRequest rReq = null;
        ActionResponse aRes = null;
        RenderResponse rRes = null;
        PortletContainerRequest pContReq = (PortletContainerRequest)req.getAttribute("portlet_container_request");
        PortletContainerResponse pContRes = (PortletContainerResponse)req.getAttribute("portlet_container_response");
        String portletName = pContReq.getPortletName();
        PortletMode portletMode = PortletAppEngineUtils.getPortletMode(pContReq.getChannelMode());
        List actionList = pContReq.getActions();
        String entityID = pContReq.getEntityID();
        if (this._logger.isLoggable(Level.INFO)) {
            StringBuffer buf = new StringBuffer();
            buf.append("context path=").append(req.getContextPath()).append("///");
            buf.append("entityID=").append(entityID).append("///");
            buf.append("portletName=").append(portletName).append("///");
            buf.append("portletMode=").append(portletMode).append("///");
            buf.append("windowState=").append(pContReq.getWindowState()).append("///");
            buf.append("actionList=");
            for (int j = 0; j < actionList.size(); ++j) {
                buf.append((String)actionList.get(j)).append(" | ");
            }
            buf.append("///");
            this._logger.logp(Level.INFO, "PortletAppEngineServlet", "service()", buf.toString());
        }
        if (this.checkSecurityConstraint(req, portletName)) {
            PortletDescriptor portletDescriptor = this.getPortletDescriptor(portletName);
            PreferencesValidator validator = this._lifecycleManager.getPreferencesValidator(portletName);
            Portlet p = null;
            try {
                p = this._lifecycleManager.getPortlet(portletName);
                req.setAttribute("javax.portlet.config", (Object)this._lifecycleManager.getPortletConfig(portletName));
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.logp(Level.INFO, "PortletAppEngineServlet", "service", "got portlet for " + portletName);
                }
                boolean stop = false;
                for (int i = 0; i < actionList.size() && !stop; ++i) {
                    String action = (String)actionList.get(i);
                    req.setAttribute("javax.portlet.currentAction", (Object)action);
                    if (action.equals("ACTION")) {
                        PortletContainerActionRequest pContActionReq = (PortletContainerActionRequest)pContReq;
                        PortletContainerActionResponse pContActionRes = (PortletContainerActionResponse)pContRes;
                        aReq = this._requestResponseFactory.getActionRequest(req, res, pContActionReq, pContActionRes, this._lifecycleManager.getPortletContext(), this._lifecycleManager.getPortalContext(), portletDescriptor, writer);
                        aRes = this._requestResponseFactory.getActionResponse(req, res, aReq, pContActionReq, pContActionRes);
                        this.setValidator((PortletRequest)aReq, validator, false);
                        p.processAction(aReq, aRes);
                        if (pContActionRes.getRedirectURL() != null) {
                            stop = true;
                        }
                        this.setValidator((PortletRequest)aReq, validator, true);
                        continue;
                    }
                    if (!action.equals("RENDER")) continue;
                    PortletContainerRenderRequest pContRenderReq = (PortletContainerRenderRequest)pContReq;
                    PortletContainerRenderResponse pContRenderRes = (PortletContainerRenderResponse)pContRes;
                    this.setCacheParams(pContRenderRes, portletDescriptor);
                    rReq = this._requestResponseFactory.getRenderRequest(req, res, pContRenderReq, pContRenderRes, this._lifecycleManager.getPortletContext(), this._lifecycleManager.getPortalContext(), portletDescriptor);
                    rRes = this._requestResponseFactory.getRenderResponse(req, res, rReq, pContRenderReq, pContRenderRes, writer, output, portletDescriptor);
                    this.setValidator((PortletRequest)rReq, validator, false);
                    String title = (String)req.getAttribute("com.sun.portal.portlet." + entityID + ".DPTITLE");
                    if (title != null && title.length() > 0) {
                        rReq.setAttribute("com.sun.portal.portlet.DPTITLE", (Object)title);
                    }
                    PortletDescriptor pdesc = this.getPortletDescriptor(portletName);
                    String rbundleName = pdesc.getResourceBundle();
                    String rtitle = null;
                    if (rbundleName != null && rbundleName.length() > 0) {
                        ResourceBundle rb = null;
                        try {
                            rb = ResourceBundle.getBundle(rbundleName, req.getLocale(), Thread.currentThread().getContextClassLoader());
                            if (rb != null) {
                                rtitle = rb.getString(JAVAX_PORTLET_TITLE);
                            }
                        }
                        catch (Exception e1) {
                            this._logger.logp(Level.SEVERE, "PortletAppEngineSevlet", "getTitle()", "Exception.." + e1);
                        }
                    }
                    if (rtitle != null && rtitle.length() > 0) {
                        rReq.setAttribute("com.sun.portal.portlet.RBTITLE", (Object)rtitle);
                    }
                    p.render(rReq, rRes);
                    StringBuffer buff = writer.getBuffer();
                    String outString = output.toString(res.getCharacterEncoding());
                    if (buff.length() > 0) {
                        pContRenderRes.setMarkup(writer.getBuffer());
                    } else if (outString.length() > 0) {
                        pContRenderRes.setMarkup(new StringBuffer(outString));
                    } else {
                        pContRenderRes.setMarkup(new StringBuffer(""));
                    }
                    this.setValidator((PortletRequest)rReq, validator, true);
                }
            }
            catch (UnavailableException ue) {
                if (p != null) {
                    p.destroy();
                    this._lifecycleManager.removePortlet(portletName);
                    this._lifecycleManager.removePortletConfig(portletName);
                }
                pContRes.setErrorCode(PortletContainerErrorCode.PORTLET_UNAVAILABLE);
                this.handleError(ue, null);
            }
            catch (PortletSecurityException se) {
                pContRes.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
                this.handleError(se, null);
            }
            catch (PortletException pe) {
                Throwable cause = pe.getCause();
                if (pe instanceof PortletModeException || cause instanceof PortletModeException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_MODE);
                } else if (pe instanceof ReadOnlyException || cause instanceof ReadOnlyException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.READONLY_ERROR);
                } else if (pe instanceof WindowStateException || cause instanceof WindowStateException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_STATE);
                } else {
                    pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                }
                this.handleError(pe, null);
            }
            catch (IOException ie) {
                pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                this.handleError(ie, null);
            }
            catch (RuntimeException re) {
                pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                this.handleError(re, null);
            }
            if (aReq != null) {
                this._requestResponseFactory.releaseActionRequest(aReq);
            }
            if (rReq != null) {
                this._requestResponseFactory.releaseRenderRequest(rReq);
            }
            if (aRes != null) {
                this._requestResponseFactory.releaseActionResponse(aRes);
            }
            if (rRes != null) {
                this._requestResponseFactory.releaseRenderResponse(rRes);
            }
        } else {
            pContRes.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
            this.handleError(null, "Transport scheme is not secured");
        }
    }

    private PortletDescriptor getPortletDescriptor(String portletName) {
        PortletDescriptor portletDescriptor = null;
        if (this._descriptor != null && this._descriptor.getPortletsDescriptor() != null) {
            portletDescriptor = this._descriptor.getPortletsDescriptor().getPortletDescriptor(portletName);
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.logp(Level.INFO, "PortletAppEngineServlet", "getPortletDescriptor()", "session-enabled: " + portletDescriptor.sessionEnabled());
            }
        }
        return portletDescriptor;
    }

    private void setValidator(PortletRequest pReq, PreferencesValidator validator, boolean cleanup) {
        PreferencesValidatorSetter setter = (PreferencesValidatorSetter)pReq.getPreferences();
        if (setter != null && cleanup) {
            setter.setPreferencesValidator(null);
        }
        if (setter != null && validator != null) {
            setter.setPreferencesValidator(validator);
        }
    }

    private void setCacheParams(PortletContainerRenderResponse pContRes, PortletDescriptor portletDescriptor) {
        int expiration = -999;
        if (portletDescriptor != null) {
            expiration = portletDescriptor.getCacheExpiration();
        }
        pContRes.setExpiration(expiration);
    }

    private void handleError(Throwable t, String msg) throws IOException, ServletException {
        if (this._logger.isLoggable(Level.SEVERE)) {
            if (t != null) {
                this._logger.logp(Level.SEVERE, "PortletAppEngineServlet", "HandleError()", "Error: " + msg, t);
            } else {
                this._logger.logp(Level.SEVERE, "PortletAppEngineServlet", "HandleError()", "Error: " + msg);
            }
        }
    }

    private boolean checkSecurityConstraint(HttpServletRequest req, String portletName) {
        String consType;
        boolean isValid = true;
        SecurityConstraintDescriptor secConsDescriptor = this._descriptor.getSecurityConstraintDescriptor();
        if (secConsDescriptor != null && ((consType = secConsDescriptor.getTransportGuaranteeType()).equals(CONFIDENTIAL) || consType.equals(INTEGRAL))) {
            List portlets = secConsDescriptor.getConstrainedPortlets();
            boolean stop = false;
            Iterator i = portlets.iterator();
            while (i.hasNext() && !stop) {
                String nextP = (String)i.next();
                if (!portletName.equals(nextP)) continue;
                stop = true;
            }
            if (stop && req.isSecure()) {
                isValid = false;
            }
        }
        return isValid;
    }
}

