/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class NetletRule {
    public static String NETLET_SERVICE = "srapNetletService";
    public static String NETLET_RULE = "sunPortalNetletRules";
    public static String NETLET_DEFAULT_PORT = "sunPortalNetletClientLoopbackPort";
    private static AMTemplate template = null;

    private NetletRule() {
    }

    public static NetletRule get() {
        return new NetletRule();
    }

    public static void add(String adminDN, String password, String orgDN, String rule) throws SSOException, AMException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken token = manager.createSSOToken((Principal)new MyPrincipal(adminDN), password);
        AMStoreConnection amConn = new AMStoreConnection(token);
        AMOrganization org = amConn.getOrganization(orgDN);
        template = org.getTemplate(NETLET_SERVICE, 301);
        HashMap<String, Set> newNetletRule = new HashMap<String, Set>();
        Set rules = template.getAttribute(NETLET_RULE);
        rules.add(rule);
        newNetletRule.put(NETLET_RULE, rules);
        if (template != null) {
            template.setAttributes(newNetletRule);
            template.store();
        }
    }

    public static void delete(String adminDN, String password, String orgDN, String ruleName) throws SSOException, AMException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken token = manager.createSSOToken((Principal)new MyPrincipal(adminDN), password);
        AMStoreConnection amConn = new AMStoreConnection(token);
        AMOrganization org = amConn.getOrganization(orgDN);
        template = org.getTemplate(NETLET_SERVICE, 301);
        HashMap<String, Set> newNetletRule = new HashMap<String, Set>();
        Set rules = template.getAttribute(NETLET_RULE);
        String strRule = null;
        boolean found = false;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            strRule = (String)i.next();
            StringTokenizer st = new StringTokenizer(strRule, "|");
            if (!st.hasMoreTokens() || st.nextToken().compareTo(ruleName) != 0) continue;
            found = true;
            break;
        }
        if (strRule != null && found) {
            rules.remove(strRule);
        }
        newNetletRule.put(NETLET_RULE, rules);
        if (template != null) {
            template.setAttributes(newNetletRule);
            template.store();
        }
    }

    public static void usage() {
        System.out.println(" add|delete AdminDN password orgDN rule|ruleName");
    }

    public static void main(String[] args) {
        try {
            String bindDN = AdminUtils.getAdminDN();
            String password = new String(AdminUtils.getAdminPassword());
            if (args[0].compareToIgnoreCase("add") == 0) {
                NetletRule.add(bindDN, password, args[1], args[2]);
                System.out.println("Netlet rule added.");
            } else if (args[0].compareToIgnoreCase("delete") == 0) {
                NetletRule.delete(bindDN, password, args[1], args[2]);
                System.out.println("Netlet rule deleted.");
            } else if (args[0].compareToIgnoreCase("getcred") == 0) {
                System.out.println("ADMIN_DN=\"" + bindDN + "\"");
                System.out.println("PASSPHRASE=\"" + password + "\"");
            } else {
                NetletRule.usage();
            }
            System.exit(0);
        }
        catch (SSOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (AMException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class MyPrincipal
    implements Principal {
        protected String name;

        public MyPrincipal(String name) {
            this.name = new String(name);
        }

        public String getName() {
            return this.name;
        }
    }
}

