/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.taglib.portlet;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.DecryptAction;
import com.sun.im.portal.taglib.IMTaglibException;
import com.sun.im.portal.util.NetletRule;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.TagSupport;

public class BaseIMTagSupport
extends TagSupport {
    private static final String VARIABLE_PREFIX = "$";
    private static final String SECURE_MODE = "secureMode";
    private static final String SECURE_DOWNLOAD_PORT = "secureDownloadPort";
    private static final String SECURE_PORT = "securePort";
    protected String mId = null;
    protected int mScope = 1;
    public static final String SESSION_FACTORY = "com.iplanet.im.client.api.iIMUnidirectionalSessionFactory";
    private static CollaborationSessionFactory factory;

    public void setId(String id) {
        if (id != null && id.length() > 0) {
            this.mId = id;
        }
    }

    public void setScope(String scope) {
        if (scope != null) {
            if (scope.equalsIgnoreCase("request")) {
                this.mScope = 2;
            } else if (scope.equalsIgnoreCase("session")) {
                this.mScope = 3;
            } else if (scope.equalsIgnoreCase("application")) {
                this.mScope = 4;
            }
        }
    }

    protected void processResult(Object result) throws IMTaglibException {
        if (this.mId != null) {
            if (result != null) {
                this.pageContext.setAttribute(this.mId, result, this.mScope);
            } else {
                this.pageContext.removeAttribute(this.mId, this.mScope);
            }
        } else {
            try {
                this.pageContext.getOut().print(result);
            }
            catch (IOException e) {
                throw new IMTaglibException(e);
            }
        }
    }

    protected boolean isContextVariable(String parameter) {
        if (parameter != null) {
            return parameter.startsWith(VARIABLE_PREFIX);
        }
        return false;
    }

    protected Object resolveParameter(String parameter) throws IMTaglibException {
        if (this.isContextVariable(parameter)) {
            String var = parameter.substring(VARIABLE_PREFIX.length());
            Object obj = this.pageContext.findAttribute(var);
            if (obj == null) {
                throw new IMTaglibException(3, var);
            }
            return obj;
        }
        return parameter;
    }

    protected String getVariable(String parameter) {
        if (this.isContextVariable(parameter)) {
            return parameter.substring(VARIABLE_PREFIX.length());
        }
        return parameter;
    }

    protected PortletPreferences getPortletPrefs() {
        Object pagePref = this.pageContext.getAttribute("portletPreferences", 2);
        if (pagePref != null) {
            return (PortletPreferences)pagePref;
        }
        RenderRequest pReq = this.getRenderRequest();
        return pReq.getPreferences();
    }

    protected RenderRequest getRenderRequest() {
        RenderRequest pReq = (RenderRequest)this.pageContext.getAttribute("renderRequest");
        return pReq;
    }

    protected RenderResponse getRenderResponse() {
        RenderResponse pRes = (RenderResponse)this.pageContext.getAttribute("renderResponse");
        return pRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollaborationSession getCollaborationSession() throws CollaborationException, IMTaglibException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (factory == null) {
                System.setProperty("com.sun.im.service.CollaborationSessionFactory", SESSION_FACTORY);
                try {
                    factory = new CollaborationSessionFactory();
                }
                catch (Exception e) {
                    throw new IMTaglibException(e);
                }
            }
        }
        PortletPreferences pref = this.getPortletPrefs();
        StringBuffer host = new StringBuffer();
        host.append(pref.getValue("server", "badserver")).append(":").append(pref.getValue("port", "badport"));
        String username = this.getUsername();
        String password = this.getToken();
        return factory.getSession(host.toString(), username, password, null);
    }

    public String getUsername() throws IMTaglibException {
        String username = null;
        PortletPreferences pref = this.getPortletPrefs();
        String authMethod = pref.getValue("authMethod", "");
        if (authMethod.equals("idsvr")) {
            HttpSession session = this.pageContext.getSession();
            username = (String)session.getAttribute("username");
        } else if (authMethod.equals("ldap")) {
            username = pref.getValue("username", "");
        } else {
            throw new IMTaglibException("invalid authMethod: " + authMethod);
        }
        return username;
    }

    /*
     * WARNING - void declaration
     */
    public String getToken() throws IMTaglibException {
        void var1_6;
        String token;
        PortletPreferences pref = this.getPortletPrefs();
        String authMethod = pref.getValue("authMethod", "");
        if (authMethod.equals("idsvr")) {
            HttpSession session = this.pageContext.getSession();
            SSOToken ssotoken = (SSOToken)session.getAttribute("ssotoken");
            if (ssotoken == null) {
                throw new IMTaglibException("Unable to access SSOToken from RenderRequest");
            }
            token = ssotoken.getTokenID().toString();
        } else if (authMethod.equals("ldap")) {
            String pw = pref.getValue("password", "");
            token = pw.length() > 0 ? (String)AccessController.doPrivileged(new DecryptAction(pw)) : pw;
        } else {
            throw new IMTaglibException("invalid authMethod: " + authMethod);
        }
        return var1_6;
    }

    public String getDummyPassword() {
        PortletPreferences pref = this.getPortletPrefs();
        StringBuffer dummy = new StringBuffer();
        int len = ((String)AccessController.doPrivileged(new DecryptAction(pref.getValue("password", "")))).length();
        for (int i = 0; i < len; ++i) {
            dummy.append("*");
        }
        return dummy.toString();
    }

    protected boolean getSecureMode() throws IMTaglibException {
        Object sm = this.pageContext.getAttribute(SECURE_MODE);
        if (sm != null) {
            return (Boolean)sm;
        }
        try {
            ServletRequest request = this.pageContext.getRequest();
            String secure = request.getParameter("secure");
            if (secure != null && secure.equals("yes")) {
                this.pageContext.setAttribute(SECURE_MODE, (Object)Boolean.TRUE);
                return true;
            }
            this.pageContext.setAttribute(SECURE_MODE, (Object)Boolean.FALSE);
            return false;
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    protected String getSecureDownloadPort() throws IMTaglibException {
        Object v = this.pageContext.getAttribute(SECURE_DOWNLOAD_PORT);
        if (v != null) {
            return (String)v;
        }
        this.getIMNetletRule();
        return (String)this.pageContext.getAttribute(SECURE_DOWNLOAD_PORT);
    }

    protected String getSecureIMPort() throws IMTaglibException {
        Object v = this.pageContext.getAttribute(SECURE_PORT);
        if (v != null) {
            return (String)v;
        }
        this.getIMNetletRule();
        return (String)this.pageContext.getAttribute(SECURE_PORT);
    }

    private void getIMNetletRule() throws IMTaglibException {
        try {
            String secureIMPort = "";
            String secureDownloadPort = "";
            SSOToken token = SSOTokenManager.getInstance().createSSOToken((HttpServletRequest)this.pageContext.getRequest());
            AMStoreConnection connection = new AMStoreConnection(token);
            AMUser user = connection.getUser(token.getPrincipal().getName());
            Set rules = user.getAttribute(NetletRule.NETLET_RULE);
            PortletPreferences prefs = this.getPortletPrefs();
            String ruleName = prefs.getValue("netletRule", "");
            String rulePrefix = ruleName + "|";
            String strRule = "";
            boolean found = false;
            Iterator i = rules.iterator();
            while (i.hasNext()) {
                strRule = (String)i.next();
                if (!strRule.startsWith(rulePrefix)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IMTaglibException("Undefined netletRule (" + ruleName + ") in channel " + "TBD");
            }
            StringTokenizer st = new StringTokenizer(strRule, "|");
            st.nextToken();
            st.nextToken();
            String downloadinfo = st.nextToken();
            if (downloadinfo.equals("true")) {
                secureDownloadPort = user.getStringAttribute(NetletRule.NETLET_DEFAULT_PORT);
            } else {
                StringTokenizer st1 = new StringTokenizer(downloadinfo, ":");
                secureDownloadPort = st1.nextToken();
            }
            String ruleinfo = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(ruleinfo, ":");
            secureIMPort = st2.nextToken();
            this.pageContext.setAttribute(SECURE_PORT, (Object)secureIMPort);
            this.pageContext.setAttribute(SECURE_DOWNLOAD_PORT, (Object)secureDownloadPort);
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    public String getDomain() throws IMTaglibException {
        try {
            SSOToken token = SSOTokenManager.getInstance().createSSOToken((HttpServletRequest)this.pageContext.getRequest());
            AMStoreConnection connection = new AMStoreConnection(token);
            AMUser user = connection.getUser(token.getPrincipal().getName());
            String orgDN = user.getOrganizationDN();
            AMOrganization org = connection.getOrganization(orgDN);
            Set domainSet = org.getAttribute("sunPreferredDomain");
            if (domainSet == null || domainSet.size() != 1) {
                throw new IMTaglibException("Invalid value of sunPreferredDomain");
            }
            String domain = (String)domainSet.iterator().next();
            return domain;
        }
        catch (Exception e) {
            throw new IMTaglibException(e);
        }
    }

    public String getChannelname() throws IMTaglibException {
        RenderResponse rRes = this.getRenderResponse();
        String text = rRes.getNamespace();
        StringBuffer escaped = new StringBuffer();
        block3: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    escaped.append("_");
                    continue block3;
                }
                default: {
                    escaped.append(c);
                    continue block3;
                }
            }
        }
        return escaped.toString();
    }

    public String getLocaleString() throws IMTaglibException {
        ServletRequest request = this.pageContext.getRequest();
        String localeString = request.getLocale().toString();
        return localeString;
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }
}

