/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

class SendFile {
    private static Debug d_debug = null;
    private String s_empty_string = "";

    SendFile() {
        if (d_debug == null) {
            d_debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    String encode(String s_to_be_encoded, String character_set) throws Exception {
        if (character_set != null && !character_set.equals(this.s_empty_string)) {
            s_to_be_encoded = MimeUtility.encodeText((String)s_to_be_encoded, (String)character_set, (String)"B");
        }
        return s_to_be_encoded;
    }

    String sendAttachedFile(String to, String from, String replyto, String cc, String bcc, String host, String subject, String message, Map filetosendList, String dbgval, String charSet, NetFileResource nfr_user_locale_i18n_bucket, String displayFileName) throws NetFileException {
        try {
            if (host.trim().equals(this.s_empty_string)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "mail_server_not_configured");
            }
            d_debug.message("Charset=" + charSet);
            if (charSet.equals(this.s_empty_string)) {
                charSet = "UTF8";
            }
            charSet = MimeUtility.mimeCharset((String)charSet);
            boolean debug = Boolean.valueOf(dbgval);
            InternetAddress[] toaddress = null;
            InternetAddress[] ccaddress = null;
            InternetAddress[] bccaddress = null;
            Properties props = System.getProperties();
            props.put("mail.smtp.host", host);
            Session session = Session.getDefaultInstance((Properties)props, null);
            session.setDebug(debug);
            if (!charSet.equals(this.s_empty_string)) {
                String firstFrom = this.s_empty_string;
                String restFrom = this.s_empty_string;
                int leftAnglendx = from.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstFrom = from.substring(0, leftAnglendx);
                    restFrom = from.substring(leftAnglendx);
                    firstFrom = this.encode(firstFrom, charSet);
                    from = firstFrom + restFrom;
                }
                String firstTo = this.s_empty_string;
                String restTo = this.s_empty_string;
                leftAnglendx = to.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstTo = to.substring(0, leftAnglendx);
                    restTo = to.substring(leftAnglendx);
                    firstTo = this.encode(firstTo, charSet);
                    to = firstTo + restTo;
                }
                String firstReply = this.s_empty_string;
                String restReply = this.s_empty_string;
                leftAnglendx = replyto.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstReply = replyto.substring(0, leftAnglendx);
                    restReply = replyto.substring(leftAnglendx);
                    firstReply = this.encode(firstReply, charSet);
                    replyto = firstReply + restReply;
                }
                String firstCC = this.s_empty_string;
                String restCC = this.s_empty_string;
                leftAnglendx = cc.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstCC = cc.substring(0, leftAnglendx);
                    restCC = cc.substring(leftAnglendx);
                    firstCC = this.encode(firstCC, charSet);
                    cc = firstCC + restCC;
                }
                String firstBCC = this.s_empty_string;
                String restBCC = this.s_empty_string;
                leftAnglendx = bcc.indexOf("<");
                if (leftAnglendx >= 0) {
                    firstBCC = bcc.substring(0, leftAnglendx);
                    restBCC = bcc.substring(leftAnglendx);
                    firstBCC = this.encode(firstBCC, charSet);
                    bcc = firstBCC + restBCC;
                }
            }
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            try {
                toaddress = this.parseAddress(to, charSet);
            }
            catch (AddressException ae) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_parse_address");
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])toaddress);
            if (replyto == null || replyto.equals(this.s_empty_string)) {
                replyto = from;
            }
            InternetAddress[] replytoaddress = new InternetAddress[]{new InternetAddress(replyto)};
            msg.setReplyTo((Address[])replytoaddress);
            if (!cc.equals(this.s_empty_string) && cc != null) {
                try {
                    ccaddress = this.parseAddress(cc, charSet);
                }
                catch (AddressException ae) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_parse_address");
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccaddress);
            }
            if (!bcc.equals(this.s_empty_string) && bcc != null) {
                try {
                    bccaddress = this.parseAddress(bcc, charSet);
                }
                catch (AddressException ae) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_parse_address");
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bccaddress);
            }
            msg.setSubject(this.encode(subject, charSet));
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(message, charSet);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            Iterator it = filetosendList.keySet().iterator();
            while (it.hasNext()) {
                Object theFileName = it.next();
                String thefile = filetosendList.get(theFileName).toString();
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(theFileName.toString());
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(this.encode(thefile, charSet));
                mbp2.setHeader("Content-Type", "application/octet-stream; charset=" + charSet);
                mbp2.setHeader("Content-Transfer-Encoding", "base64");
                mp.addBodyPart((BodyPart)mbp2);
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.processException(e, host);
        }
        d_debug.message("Did not throw exception properly");
        return nfr_user_locale_i18n_bucket.getString("info8");
    }

    private void processException(Exception e, String host) throws NetFileException {
        d_debug.error("Exception is sending the message", (Throwable)e);
        if (e instanceof MessagingException) {
            Exception mex;
            MessagingException me = (MessagingException)e;
            while ((mex = me.getNextException()) != null) {
                if (mex instanceof UnknownHostException) {
                    throw new NetFileException(new String[]{host, NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", NetFileException.KEY_IDENTIFIER_PREFIX + "mail_server_unknown"});
                }
                if (mex instanceof AuthenticationFailedException) {
                    throw new NetFileException(new String[]{host, NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", NetFileException.KEY_IDENTIFIER_PREFIX + "mail_server_auth_failed"});
                }
                if (mex instanceof SendFailedException) {
                    throw new NetFileException(new String[]{host, NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", NetFileException.KEY_IDENTIFIER_PREFIX + "invalid_address"});
                }
                if (!(mex instanceof MessagingException)) continue;
                me = (MessagingException)mex;
            }
            throw new NetFileException(new String[]{host, NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", NetFileException.KEY_IDENTIFIER_PREFIX + "mail_not_sent"});
        }
        if (e instanceof UnsupportedEncodingException) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unsupported_encoding");
        }
        d_debug.message("Throwing generic exception");
        throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error26");
    }

    InternetAddress[] parseAddress(String s, String charset) throws AddressException {
        InternetAddress[] addrs = InternetAddress.parse((String)s);
        if (charset != null) {
            for (int i = 0; i < addrs.length; ++i) {
                String personal = addrs[i].getPersonal();
                if (personal == null) continue;
                try {
                    personal = this.encode(personal, charset);
                    addrs[i].setPersonal(personal);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return addrs;
    }

    InternetAddress[] parseAddress(String s) throws AddressException {
        InternetAddress[] addrs = null;
        InternetAddress addr = null;
        ArrayList<InternetAddress> addrsList = new ArrayList<InternetAddress>();
        StringTokenizer parsedAddrs = new StringTokenizer(s, ",");
        while (parsedAddrs.hasMoreTokens()) {
            addr = new InternetAddress(parsedAddrs.nextToken());
            addrsList.add(addr);
        }
        addrs = new InternetAddress[addrsList.size()];
        addrsList.toArray(addrs);
        return addrs;
    }
}

