/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.sun.nfs.XFileExtensionAccessor;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class NfsFile {
    private static Debug debug;
    public static boolean SHOULD_HAVE_READ_PERMISSION;
    public static boolean SHOULD_NOT_HAVE_READ_PERMISSION;
    public static final String encoding = "UTF8";
    private static final int[] ia_unable_to_login;
    private String s_machine_encoding;
    private XFileInputStream instream = null;
    private XFileOutputStream outstream = null;
    protected int i_number_of_directories_traversed;
    private NetFileLogManager logMgr;

    private native boolean doNativeAuth(String var1, String var2) throws Exception;

    public native int[] getUserInfo(String var1) throws Exception;

    NfsFile(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.i_number_of_directories_traversed = 0;
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    NfsFile(NetFileLogManager log_Mgr, String s_machine_encoding, int authPort) {
        this(log_Mgr, s_machine_encoding);
    }

    int[] getUserIDs(String user_name, String password) throws NetFileException {
        int[] i_ids = ia_unable_to_login;
        try {
            i_ids = this.getUserInfo(new String(user_name.getBytes(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unsupported_character_encoding");
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        if (i_ids[0] == -1) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error44");
        }
        return i_ids;
    }

    String mkdir(String machine, String share, String user_name, String password, String target_dir, String directory_to_create, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (!this.doAuthenticate(user_name, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        try {
            int[] i_ids = this.getUserIDs(user_name, password);
            XFile xf_parent_dir = this.getXFile(share, machine, target_dir, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_dir.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", xf_parent_dir.getPath()});
            }
            XFile xfile = this.getXFile(share, machine, target_dir + "/" + directory_to_create, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
            if (!xfile.mkdir()) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
            }
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
        }
        return nfr_user_locale_i18n_bucket.getString("warning52");
    }

    String[] getNFSDir(String username, String password, String VMSnam, String machname, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (!this.doAuthenticate(username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xfile = this.getXFile(VMSnam, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        String[] sa_files_list = xfile.list();
        String[] sa_listing = null;
        if (sa_files_list == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        sa_listing = new String[sa_files_list.length * 4];
        int j = 0;
        for (int i = 0; i < sa_files_list.length; ++i) {
            XFile xf_curr_file = new XFile(xfile, sa_files_list[i]);
            sa_listing[j] = xf_curr_file.isFile() ? "-" : "d";
            sa_listing[++j] = xf_curr_file.getName();
            sa_listing[++j] = new Long(xf_curr_file.length()).toString();
            Date d = new Date(xf_curr_file.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
            sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
            sa_listing[++j] = sdf.format(d);
            ++j;
        }
        if (sa_listing == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        return sa_listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String getNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        String string;
        File temp_file;
        block10: {
            temp_file = null;
            byte[] buffer = new byte[8192];
            if (!this.doAuthenticate(username, password)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
            }
            int[] i_ids = this.getUserIDs(username, password);
            XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            XFileInputStream xfis_file = new XFileInputStream(xfile);
            Long time = new Long(System.currentTimeMillis());
            String s_temp_file = tmpdir + "/" + time.toString() + username.toUpperCase() + mainfilename;
            temp_file = new File(s_temp_file);
            temp_file.createNewFile();
            FileOutputStream fops_tmp = new FileOutputStream(temp_file);
            int c = 0;
            while ((c = xfis_file.read(buffer)) > -1) {
                fops_tmp.write(buffer, 0, c);
            }
            fops_tmp.close();
            xfis_file.close();
            fops_tmp = null;
            xfis_file = null;
            xfile = null;
            time = null;
            temp_file = null;
            string = s_temp_file;
            Object var20_21 = null;
            if (temp_file == null) break block10;
            try {
                temp_file.delete();
            }
            catch (Exception e2) {
                // empty catch block
            }
            temp_file = null;
        }
        return string;
        catch (Exception e) {
            String string2;
            block12: {
                try {
                    debug.error("Error in putting NFS File", (Throwable)e);
                    string2 = "ERROR:" + e.getMessage();
                    Object var20_22 = null;
                    if (temp_file == null) break block12;
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var20_23 = null;
                        if (temp_file == null) break block14;
                        try {
                            temp_file.delete();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        temp_file = null;
                    }
                    throw throwable;
                }
                try {
                    temp_file.delete();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                temp_file = null;
            }
            return string2;
        }
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        return this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir, nfr_user_locale_i18n_bucket);
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir, NetFileResource nfRes) throws NetFileException {
        if (!this.doAuthenticate(usernam, passwrd)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        int[] i_ids = this.getUserIDs(usernam, passwrd);
        XFile xfile = this.getXFile(VMSnam, machnam, dir_nam, true, false, i_ids);
        String s_prefix = "nfs://" + machnam;
        int i_prefix_length = s_prefix.length();
        if (xfile.isFile()) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "cannot_search_a_file");
        }
        ArrayList v_search_results = new ArrayList();
        this.search(xfile, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            String[] searchResults = new String[v_search_results.size() + 1];
            searchResults[0] = "EXCEED:" + nfRes.getString("maxSearch");
            for (int j = 1; j < searchResults.length; ++j) {
                searchResults[j] = (String)v_search_results.get(j - 1);
            }
            return searchResults;
        }
        String[] sa_resulsts = new String[v_search_results.size()];
        for (int i = 0; i < v_search_results.size(); ++i) {
            sa_resulsts[i] = (String)v_search_results.get(i);
        }
        return sa_resulsts;
    }

    void search(XFile xfile, int maxsrchdir, int i_prefix_length, ArrayList v_search_results, String pattern, int[] i_ids) throws NetFileException {
        ++this.i_number_of_directories_traversed;
        debug.message(this + ":Directory number being searched=" + this.i_number_of_directories_traversed);
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            return;
        }
        if (xfile.isFile()) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "cannot_search_a_file");
        }
        String[] sa_contents = xfile.list();
        String s_path = xfile.toString();
        if (sa_contents == null) {
            v_search_results.add("Permission denied :" + s_path.substring(i_prefix_length, s_path.length()));
        } else {
            for (int i = 0; i < sa_contents.length && this.i_number_of_directories_traversed <= maxsrchdir; ++i) {
                String s_current_path = s_path + "/" + sa_contents[i];
                XFile x_file = null;
                try {
                    x_file = this.getXFile(s_current_path, true, false, i_ids);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sa_contents[i].indexOf(pattern) > -1) {
                    String path = x_file.toString().substring(i_prefix_length, x_file.toString().length());
                    if (x_file.isDirectory()) {
                        path = path + "/";
                    }
                    v_search_results.add(path);
                }
                if (!x_file.isDirectory()) continue;
                if (x_file.canRead()) {
                    this.search(x_file, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
                    continue;
                }
                v_search_results.add("Permission denied :" + x_file.toString().substring(i_prefix_length, x_file.toString().length()));
            }
        }
    }

    String delNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (!this.doAuthenticate(username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        try {
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent"});
            }
            XFile xf_file = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission"});
            }
            xf_file.delete();
        }
        catch (Exception e) {
            debug.error("Error in putting NFS File", (Throwable)e);
            return "ERROR:" + e.getMessage();
        }
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    private String getFileURL(String VMSnam, String machname, String dir_nam) {
        StringBuffer sb_file_pointer = new StringBuffer("nfs://");
        sb_file_pointer.append(machname);
        sb_file_pointer.append(VMSnam);
        sb_file_pointer.append(dir_nam);
        return sb_file_pointer.toString();
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam) throws NetFileException {
        return this.getNFSOutputStream(username, password, machname, VMSname, remotefil_arg, dir_nam, false);
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam, boolean append) throws NetFileException {
        if (!this.doAuthenticate(username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        try {
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_dir.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + " : " + xf_parent_dir.getPath()});
            }
            XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
            this.outstream = append ? new XFileOutputStream(xfile, append) : new XFileOutputStream(xfile);
            return this.outstream;
        }
        catch (Exception e) {
            debug.error("Error in getting output stream for NFS File", (Throwable)e);
            if (e instanceof NetFileException) {
                throw (NetFileException)e;
            }
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + e.getMessage());
        }
    }

    public XFileInputStream getNFSInputStream(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam) throws Exception, NetFileException {
        if (!this.doAuthenticate(username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        this.instream = new XFileInputStream(xfile);
        return this.instream;
    }

    public void closeNfsFile() throws IOException {
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
        this.instream = null;
        this.outstream = null;
    }

    private XFile getXFile(String s_nfs_url, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        XFile xfile = new XFile(s_nfs_url);
        XFileExtensionAccessor nfsx = new XFileExtensionAccessor(xfile);
        int i_uid = i_ids[0];
        int i_gid = i_ids[1];
        int[] i_gids = new int[]{i_gid};
        nfsx.loginUGID(i_uid, i_gid, i_gids);
        if (b_file_should_exist && !xfile.exists()) {
            throw new NetFileException(new String[]{xfile.getPath(), " ", NetFileException.KEY_IDENTIFIER_PREFIX + "not_found"});
        }
        if (b_is_read_allowed && !xfile.canRead()) {
            throw new NetFileException(new String[]{xfile.getPath(), " ", NetFileException.KEY_IDENTIFIER_PREFIX + "no_read_permission"});
        }
        return xfile;
    }

    private XFile getXFile(String VMSName, String machname, String file, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        if (!VMSName.startsWith("/")) {
            VMSName = "/" + VMSName;
        }
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        String s_nfs_url = this.getFileURL(VMSName, machname, file);
        return this.getXFile(s_nfs_url, b_file_should_exist, b_is_read_allowed, i_ids);
    }

    void rename(String username, String password, String machine, String share, String directory, String old_file_name, String new_file_name) throws NetFileException {
        if (!this.doAuthenticate(username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "nf.2");
        }
        try {
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(share, machine, directory, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_parent_directory.getPath()});
            }
            XFile xf_file = this.getXFile(share, machine, directory + "/" + old_file_name, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_file.getPath()});
            }
            XFile xf_renamed_file = new XFile(xf_parent_directory, new_file_name);
            if (xf_renamed_file.exists() && !xf_renamed_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_renamed_file.getPath()});
            }
            xf_file.renameTo(xf_renamed_file);
        }
        catch (Exception e) {
            debug.error("Error in putting NFS File", (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "problem_rename_file");
        }
    }

    boolean doAuthenticate(String username, String passwd) throws NetFileException {
        try {
            String osname = System.getProperty("os.name");
            if (debug.messageEnabled()) {
                debug.message("OS detected is:" + osname);
            }
            if (osname.indexOf("Linux") != -1 || osname.indexOf("SunOS") != -1) {
                if (debug.messageEnabled()) {
                    debug.message("Trying to do Native UNIX Auth");
                }
                boolean ret = false;
                ret = this.doNativeAuth(username, passwd);
                if (debug.messageEnabled()) {
                    debug.message("Native Auth code returned: " + ret);
                }
                return ret;
            }
            if (debug.messageEnabled()) {
                debug.message("Not UNIX OS, so not authenticating");
            }
            return true;
        }
        catch (Exception e) {
            debug.error("NfsFile, Exception while authenticating, ", (Throwable)e);
            return false;
        }
    }

    static {
        SHOULD_HAVE_READ_PERMISSION = true;
        SHOULD_NOT_HAVE_READ_PERMISSION = false;
        ia_unable_to_login = new int[]{-1, -1};
        if (System.getProperty("os.name").indexOf("indows") == -1) {
            System.loadLibrary("getpwnam");
        }
    }
}

