/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.sun.portal.netfile.servlet.java1.FtpFile;
import com.sun.portal.netfile.servlet.java1.FullFtpClient;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

class NetWareFile
extends FtpFile {
    private String s_empty_string = "";
    private char c_eol = (char)10;
    private final int MAX_COLUMNS = 8;

    NetWareFile(NetFileLogManager log_Mgr, String s_machine_encoding) {
        super(log_Mgr, s_machine_encoding);
    }

    String[] getFTPDir(String username, String password, String machname, String VMSname, String dirS, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        debug.message("Expanding Netware directory");
        String textouting = this.s_empty_string;
        int txt = 0;
        StringBuffer buftxt = new StringBuffer(400);
        String prwrkd = this.s_empty_string;
        String col_type = this.s_empty_string;
        String col_junk1 = this.s_empty_string;
        String col_size = this.s_empty_string;
        String col_month = this.s_empty_string;
        String col_day = this.s_empty_string;
        String col_time = this.s_empty_string;
        String type = this.s_empty_string;
        String date = this.s_empty_string;
        try {
            String theLine;
            FullFtpClient ffc = new FullFtpClient(machname, this.s_machine_encoding);
            try {
                ffc.login(username, password);
            }
            catch (IOException ioe) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error12");
            }
            ffc.cd(VMSname + dirS);
            prwrkd = ffc.pwd();
            ffc.setMachineToAccess(machname);
            BufferedReader theList = new BufferedReader(new InputStreamReader((InputStream)ffc.list(), this.s_machine_encoding));
            while ((theLine = theList.readLine()) != null) {
                buftxt.append(theLine).append(this.c_eol);
            }
            textouting = buftxt.toString();
            theList.close();
            ffc.closeServer();
        }
        catch (IOException ex) {
            debug.message("Exception in getting the netware file listing", (Throwable)ex);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error20");
        }
        if (textouting.indexOf("Permission denied") > 0) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error6");
        }
        ArrayList<String> cache = new ArrayList<String>();
        cache.clear();
        StringTokenizer pars = new StringTokenizer(textouting, "\n");
        String tmp = this.s_empty_string;
        while (pars.hasMoreElements()) {
            tmp = (String)pars.nextElement();
            if (pars.countTokens() == 0) {
                return new String[0];
            }
            while (tmp.startsWith(nfr_user_locale_i18n_bucket.getString("total"))) {
                while (pars.hasMoreTokens()) {
                    tmp = pars.nextToken();
                    cache.add(tmp);
                }
            }
        }
        Object[] rowdata = new Object[300];
        int i_number_of_files = cache.size();
        if (i_number_of_files == 0) {
            return new String[0];
        }
        String[] sa_file_listing = new String[i_number_of_files * 4];
        if (debug.messageEnabled()) {
            debug.message("netware file listing size=" + i_number_of_files);
        }
        int i_index = 0;
        if (cache.size() > 0) {
            for (int row = 0; row < cache.size(); ++row) {
                String str_cache = (String)cache.get(row);
                StringTokenizer parsnew = new StringTokenizer(str_cache, " ");
                String col_name = this.s_empty_string;
                int parscntnew = parsnew.countTokens();
                for (int j = 0; j < parscntnew; ++j) {
                    rowdata[j] = parsnew.nextToken();
                }
                col_type = rowdata[0].toString();
                col_junk1 = rowdata[1].toString();
                col_size = rowdata[3].toString();
                col_month = rowdata[4].toString();
                col_day = rowdata[5].toString();
                col_time = rowdata[6].toString();
                if (parscntnew > 7) {
                    for (int l = 7; l < parscntnew; ++l) {
                        col_name = col_name + rowdata[l].toString() + " ";
                    }
                } else {
                    col_name = col_name + rowdata[7].toString();
                }
                if ((col_name = col_name.trim()).equals(".") || col_name.equals("..")) continue;
                type = col_type.substring(0, 1);
                date = this.getModifiedDateFormat(col_month, col_day, col_time);
                sa_file_listing[i_index++] = type;
                sa_file_listing[i_index++] = col_name;
                sa_file_listing[i_index++] = col_size;
                sa_file_listing[i_index++] = date;
                debug.message("type=" + type);
                debug.message("name=" + col_name);
                debug.message("size=" + col_size);
                debug.message("date=" + date);
                ++txt;
            }
        }
        debug.message("returning from expanding netware directory");
        return sa_file_listing;
    }

    private String getModifiedDateFormat(String month, String date, String time) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        calendar.set(2, this.getMonthCode(month));
        calendar.set(5, Integer.parseInt(date));
        if (time.indexOf(":") != -1) {
            int colonIndex = time.indexOf(":");
            String hourStr = time.substring(0, colonIndex);
            String minuteStr = time.substring(colonIndex + 1).trim();
            calendar.set(11, Integer.parseInt(hourStr));
            calendar.set(12, Integer.parseInt(minuteStr));
        } else {
            calendar.set(1, Integer.parseInt(time.trim()));
        }
        Date d = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yy, hh:mm a");
        sdf.setCalendar(new GregorianCalendar(TimeZone.getDefault()));
        return sdf.format(d);
    }

    boolean getFTPType(String machname) {
        String novellResponse = "NetWare";
        boolean novellServer = false;
        try {
            FullFtpClient fc = new FullFtpClient(machname, this.s_machine_encoding);
            String ftpResponse = fc.getResponseString();
            fc.closeServer();
            novellServer = ftpResponse.indexOf(novellResponse) != -1;
        }
        catch (Exception e) {
            debug.message("getFTPType: Exception: " + e);
        }
        return novellServer;
    }
}

