/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.java1.FileOption;
import com.sun.portal.netfile.servlet.java1.FtpFile;
import com.sun.portal.netfile.servlet.java1.NetFileContext;
import com.sun.portal.netfile.servlet.java1.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.NetFileServlet;
import com.sun.portal.netfile.servlet.java1.NetFileURLDecoder;
import com.sun.portal.netfile.servlet.java1.NetWareFile;
import com.sun.portal.netfile.servlet.java1.NfsFile;
import com.sun.portal.netfile.servlet.java1.WinFile;
import com.sun.portal.netfile.servlet.java1.XFileFactory;
import com.sun.portal.netfile.servlet.java1.XFileInterface;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class NetFileUploadServlet
extends HttpServlet {
    private Debug debug = null;
    private static HashMap uploadCache = null;
    String tokenID = "";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        uploadCache = new HashMap();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequest(request, response);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        String queryString = request.getQueryString();
        Hashtable queryData = HttpUtils.parseQueryString((String)queryString);
        String[] id = (String[])queryData.get("id");
        FileUploadHandler ufh = (FileUploadHandler)uploadCache.get(id[0]);
        this.tokenID = id[0];
        if (ufh == null) {
            ufh = new FileUploadHandler(id[0]);
            uploadCache.put(id[0], ufh);
        }
        ufh.handleUpload(request, response);
    }

    class FileUploadHandler {
        private String uploadIdentifier = "";
        private HashMap storedMetaData = null;
        byte[] buffer = new byte[8192];
        private OutputStream uploadStream = null;
        private Object fileObject = null;
        NetFileResource resourceBundle = null;
        NetFileLogManager logManager = null;
        private static final String RESP_STR = "OK.";
        private static final String SNO_STR = "SNo";

        public FileUploadHandler(String id) {
            NetFileUploadServlet.this.tokenID = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleUpload(HttpServletRequest request, HttpServletResponse response) {
            block23: {
                block22: {
                    block21: {
                        manager = null;
                        ssoToken = null;
                        nfContext = null;
                        inputStream = null;
                        outputStream = null;
                        output = "";
                        try {
                            try {
                                manager = SSOTokenManager.getInstance();
                                ssoToken = manager.createSSOToken(this.extractSession(request));
                                nfContext = new NetFileContextImpl(ssoToken);
                                inputStream = request.getInputStream();
                                outputStream = this.getOutputStream(response);
                                if (!this.validateSession(request, response, ssoToken, nfContext)) {
                                    var14_9 = null;
                                    break block21;
                                }
                                if (this.logManager == null) {
                                    this.logManager = this.createLogManager(ssoToken);
                                }
                                this.readUploadIdentifier(inputStream);
                                getData = this.readMetaData(inputStream);
                                sequenceNo = new Integer((String)getData.get("SNo"));
                                if (sequenceNo == 1) {
                                    this.storedMetaData = getData;
                                    locale = (String)this.storedMetaData.get("locale");
                                    machineEncoding = (String)this.storedMetaData.get("machine_encoding");
                                    this.resourceBundle = this.getUserLocaleBundle(locale, machineEncoding);
                                } else {
                                    if (sequenceNo == -888) {
                                        this.writeOutputMessage(outputStream, "OK.");
                                        this.doClose(sequenceNo);
                                        break block22;
                                    }
                                    this.storedMetaData.remove("SNo");
                                    this.storedMetaData.put("SNo", getData.get("SNo"));
                                }
                                output = this.uploadFile(this.storedMetaData, inputStream, this.resourceBundle, ssoToken);
                                this.writeOutputMessage(outputStream, output);
                                break block23;
                            }
                            catch (Exception e) {
                                this.writeErrorDebug("Exception while uploading file - ", e);
                                output = e instanceof NetFileException != false ? ((NetFileException)e).getMessage(this.resourceBundle) : "ERROR: " + this.resourceBundle.getString("error18");
                                this.writeOutputMessage(outputStream, output);
                                var14_12 = null;
                                try {
                                    if (outputStream != null) {
                                        outputStream.close();
                                    }
                                    if (inputStream == null) return;
                                    inputStream.close();
                                    return;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                        catch (Throwable var13_24) {
                            block24: {
                                var14_13 = null;
                                ** try [egrp 2[TRYBLOCK] [8 : 357->380)] { 
lbl60:
                                // 1 sources

                                if (outputStream != null) {
                                    outputStream.close();
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                break block24;
lbl65:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                            inputStream = null;
                            outputStream = null;
                            throw var13_24;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [8 : 357->380)] { 
lbl73:
                    // 1 sources

                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (inputStream == null) return;
                    inputStream.close();
                    return;
lbl78:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                var14_10 = null;
                ** try [egrp 2[TRYBLOCK] [8 : 357->380)] { 
lbl84:
                // 1 sources

                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream == null) return;
                inputStream.close();
                return;
lbl89:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var14_11 = null;
            ** try [egrp 2[TRYBLOCK] [8 : 357->380)] { 
lbl95:
            // 1 sources

            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream == null) return;
            inputStream.close();
            return;
lbl100:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
        }

        private OutputStream getOutputStream(HttpServletResponse response) throws IOException {
            response.setContentType("application/octet-stream");
            return response.getOutputStream();
        }

        private void writeOutputMessage(OutputStream outputStream, String output) {
            try {
                ObjectOutputStream ois = new ObjectOutputStream(outputStream);
                ois.writeObject(output);
                ois.flush();
                ois.close();
            }
            catch (Exception e) {
                this.writeErrorDebug("Exception while writing status to client, ", e);
            }
        }

        private void readUploadIdentifier(InputStream inputStream) throws IOException {
            byte[] uploadIdBytes = new byte[128];
            inputStream.read(uploadIdBytes);
            this.uploadIdentifier = new String(uploadIdBytes);
        }

        private HashMap readMetaData(InputStream inputStream) throws IOException {
            int metaDataSizeStart = this.uploadIdentifier.indexOf("NFUP") + "NFUP".length();
            int metaDataSizeEnd = this.uploadIdentifier.indexOf("END");
            String metaDataSizeString = this.uploadIdentifier.substring(metaDataSizeStart, metaDataSizeEnd);
            int metaDataSize = Integer.parseInt(metaDataSizeString);
            HashMap<String, String> metaDataHashMap = new HashMap<String, String>();
            byte[] metaDataBytes = new byte[metaDataSize + 1];
            inputStream.read(metaDataBytes);
            String metaDataString = new String(metaDataBytes, "UTF-8");
            StringTokenizer stok = new StringTokenizer(metaDataString, "\n");
            NetFileURLDecoder decoder = new NetFileURLDecoder();
            String token = "";
            String name = "";
            String value = "";
            while (stok.hasMoreTokens()) {
                token = stok.nextToken();
                int index = token.indexOf("=");
                if (index == -1) continue;
                name = token.substring(0, index);
                value = token.substring(index + 1);
                value = decoder.decode(value, "UTF8");
                metaDataHashMap.put(name, value);
            }
            return metaDataHashMap;
        }

        String uploadFile(HashMap metaData, InputStream inputStream, NetFileResource nfRes, SSOToken ssoToken) throws NetFileException {
            String returnStr = "";
            Integer seqNo = new Integer((String)metaData.get(SNO_STR));
            OutputStream streamToServer = null;
            try {
                streamToServer = this.getOutputStream(metaData, nfRes, ssoToken);
                this.readWriteBytes(inputStream, streamToServer);
                returnStr = RESP_STR;
                if (seqNo == -999) {
                    this.doLog(nfRes.getString("successLog.4"));
                    this.writeDebug("Upload file result = " + returnStr);
                }
                this.doClose(seqNo);
            }
            catch (Exception e) {
                returnStr = e instanceof NetFileException ? "ERROR:" + ((NetFileException)e).getMessage(nfRes) : "ERROR:" + nfRes.getString("error18");
                this.writeErrorDebug("Error uploading file - ", e);
                this.doLog(nfRes.getString("failureLog.4"));
                this.doClose(-777);
                throw new NetFileException(returnStr);
            }
            return returnStr;
        }

        private OutputStream getOutputStream(HashMap metaData, NetFileResource nfRes, SSOToken ssoToken) throws NetFileException {
            String machineType = (String)metaData.get("type");
            if (machineType.equals("FTP") || machineType.equals("NETWARE")) {
                return this.createOutputStream(metaData, nfRes, ssoToken);
            }
            if (this.uploadStream == null) {
                this.writeDebug("Stream not available in cache.");
                this.uploadStream = this.createOutputStream(metaData, nfRes, ssoToken);
            }
            return this.uploadStream;
        }

        private OutputStream createOutputStream(HashMap metaData, NetFileResource nfRes, SSOToken ssoToken) throws NetFileException {
            String remoteFileName = (String)metaData.get("filename");
            String userName = (String)metaData.get("username");
            String share = (String)metaData.get("VMS");
            String password = (String)metaData.get("pass");
            String machine = (String)metaData.get("machine");
            String machineType = (String)metaData.get("type");
            String domain = (String)metaData.get("domain");
            String directory = (String)metaData.get("dir");
            String machineEncoding = (String)metaData.get("machine_encoding");
            Integer seqNo = new Integer((String)metaData.get(SNO_STR));
            OutputStream outputStream = null;
            if (machineType.indexOf("WIN", 0) >= 0 || machineType.indexOf("NT", 0) >= 0) {
                XFileInterface winFileInterface = null;
                if (this.fileObject == null) {
                    winFileInterface = XFileFactory.getInstance().newXFileInstance(this.logManager, machineEncoding, ssoToken);
                    this.fileObject = winFileInterface;
                } else {
                    winFileInterface = (XFileInterface)this.fileObject;
                }
                if (seqNo != 1) {
                    this.writeDebug("Creating the output stream in append mode.");
                    outputStream = winFileInterface.getOutputStream(userName, password, domain, machine, share, directory, remoteFileName, nfRes);
                } else {
                    this.writeDebug("Creating the output stream.");
                    outputStream = winFileInterface.getOutputStream(userName, password, domain, machine, share, directory, remoteFileName, nfRes);
                }
            } else if (machineType.indexOf("FTP", 0) >= 0 || machineType.indexOf("NETWARE", 0) >= 0) {
                FtpFile ftpFile = new FtpFile(this.logManager, machineEncoding);
                this.fileObject = ftpFile;
                if (seqNo != 1) {
                    this.writeDebug("Creating the output stream in append mode.");
                    outputStream = ftpFile.getOutputFTPStream(userName, password, machine, share, remoteFileName, directory, true);
                } else {
                    this.writeDebug("Creating the output stream.");
                    outputStream = ftpFile.getOutputFTPStream(userName, password, machine, share, remoteFileName, directory);
                }
            } else if (machineType.indexOf("NFS", 0) >= 0) {
                NfsFile nfsFile = null;
                if (this.fileObject == null) {
                    nfsFile = new NfsFile(this.logManager, machineEncoding);
                    this.fileObject = nfsFile;
                } else {
                    nfsFile = (NfsFile)this.fileObject;
                }
                if (seqNo != 1) {
                    this.writeDebug("Creating the output stream in append mode.");
                    outputStream = nfsFile.getNFSOutputStream(userName, password, machine, share, remoteFileName, directory, true);
                } else {
                    this.writeDebug("Creating the output stream.");
                    outputStream = nfsFile.getNFSOutputStream(userName, password, machine, share, remoteFileName, directory);
                }
            }
            return outputStream;
        }

        private void doClose(int sequenceNo) {
            Object obj;
            if (this.fileObject instanceof FtpFile || this.fileObject instanceof NetWareFile) {
                try {
                    if (this.uploadStream != null) {
                        BufferedOutputStream outStream = (BufferedOutputStream)this.uploadStream;
                        outStream.flush();
                        outStream.close();
                    }
                    FtpFile ftpFile = (FtpFile)this.fileObject;
                    ftpFile.ffc.closeDataConnection();
                    ftpFile.ffc.quit();
                    this.fileObject = null;
                    this.writeDebug("Output stream closed to server.");
                }
                catch (IOException ioe) {
                    this.writeErrorDebug("Exception in closing stream to server on sequence " + sequenceNo, ioe);
                }
            }
            if ((sequenceNo == -777 || sequenceNo == -888 || sequenceNo == -999) && this.fileObject != null && (this.fileObject instanceof WinFile || this.fileObject instanceof NfsFile)) {
                try {
                    if (this.uploadStream != null) {
                        this.uploadStream.flush();
                        this.uploadStream.close();
                    }
                    this.writeDebug("Output stream closed to server.");
                }
                catch (Exception ex) {
                    this.writeErrorDebug("Exception deleting file ", ex);
                }
            }
            if ((sequenceNo == -888 || sequenceNo == -777) && (obj = this.storedMetaData.get("filename")) != null) {
                this.deleteFile();
            }
            if (sequenceNo == -777 || sequenceNo == -888 || sequenceNo == -999) {
                uploadCache.remove(NetFileUploadServlet.this.tokenID);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readWriteBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
            int len = 0;
            try {
                while ((len = inputStream.read(this.buffer)) != -1) {
                    outputStream.write(this.buffer, 0, len);
                }
                outputStream.flush();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioe) {}
            if (inputStream == null) return;
            inputStream.close();
            return;
        }

        private void deleteFile() {
            String fileName = (String)this.storedMetaData.get("filename");
            String userName = (String)this.storedMetaData.get("username");
            String share = (String)this.storedMetaData.get("VMS");
            String password = (String)this.storedMetaData.get("pass");
            String machine = (String)this.storedMetaData.get("machine");
            String machineType = (String)this.storedMetaData.get("type");
            String domain = (String)this.storedMetaData.get("domain");
            String directory = (String)this.storedMetaData.get("dir");
            String machineEncoding = (String)this.storedMetaData.get("machine_encoding");
            try {
                if (machineType.equals("FTP") || machineType.equals("NETWARE")) {
                    FtpFile ftpFile = new FtpFile(this.logManager, machineEncoding);
                    ftpFile.delFTPFile(userName, password, machine, share, fileName, directory, this.resourceBundle);
                } else if (machineType.equals("NFS")) {
                    NfsFile nfsFile = (NfsFile)this.fileObject;
                    nfsFile.delNFSFile(userName, password, share, machine, fileName, directory, "", this.resourceBundle);
                } else if (machineType.equals("WIN") || machineType.equals("NT")) {
                    XFileInterface fileInterface = (XFileInterface)this.fileObject;
                    fileInterface.doDeleteFile(userName, password, machine, share, fileName, directory, domain, this.resourceBundle);
                }
            }
            catch (NetFileException e) {
                this.writeErrorDebug("Exception while deleting File. ", e);
            }
        }

        private NetFileResource getUserLocaleBundle(String locale, String machineEncoding) throws Exception {
            NetFileResource resourceBundle = null;
            if (locale == null) {
                FileOption file_option = new FileOption(this.logManager, machineEncoding);
                resourceBundle = file_option.getPlatformLocalisedBundle();
            } else {
                resourceBundle = NetFileResource.getInstance("srapNetFileAppletJava1", locale);
            }
            return resourceBundle;
        }

        private boolean validateSession(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken, NetFileContext nfContext) {
            try {
                return nfContext.isSessionValid(ssoToken) && nfContext.isExecutable(ssoToken);
            }
            catch (Exception e) {
                NetFileUploadServlet.this.debug.error("General Exception in NetFileUploadServlet", (Throwable)e);
                return false;
            }
        }

        private String extractSession(HttpServletRequest req) {
            String session = null;
            session = req.getHeader("iPSsessionID");
            Cookie[] cookie = req.getCookies();
            if (cookie != null) {
                for (int i = 0; i < cookie.length; ++i) {
                    if (!cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) continue;
                    session = cookie[i].getValue();
                    if (!NetFileServlet.isEncoded) continue;
                    session = URLDecoder.decode(session);
                }
            }
            return session;
        }

        protected void writeDebug(String szMsg) {
            this.writeDebug(szMsg, null);
        }

        protected void writeDebug(String szMsg, Exception e) {
            if (NetFileUploadServlet.this.debug != null && NetFileUploadServlet.this.debug.messageEnabled()) {
                if (e != null) {
                    NetFileUploadServlet.this.debug.message(szMsg, (Throwable)e);
                } else {
                    NetFileUploadServlet.this.debug.message(szMsg);
                }
            }
        }

        protected void writeErrorDebug(String szError, Exception e) {
            if (NetFileUploadServlet.this.debug != null) {
                if (e != null) {
                    NetFileUploadServlet.this.debug.error(szError, (Throwable)e);
                } else {
                    NetFileUploadServlet.this.debug.error(szError);
                }
            }
        }

        private NetFileLogManager createLogManager(SSOToken ssoToken) {
            String tokenId = ssoToken.getTokenID().toString();
            try {
                Object obj = NetFileServlet.logManagerCache.get(tokenId);
                if (obj == null) {
                    NetFileLogManager logMgr = new NetFileLogManager(ssoToken);
                    NetFileServlet.logManagerCache.put(tokenId, logMgr);
                    return logMgr;
                }
                return (NetFileLogManager)obj;
            }
            catch (Exception e) {
                NetFileUploadServlet.this.debug.error("Unable to create LogManager for ssoToken - " + tokenId);
                return null;
            }
        }

        private void doLog(String msg) {
            if (this.logManager == null) {
                return;
            }
            String functionName = this.resourceBundle.getString("uploadFileLog");
            String remoteFileName = (String)this.storedMetaData.get("filename");
            String userName = (String)this.storedMetaData.get("username");
            String share = (String)this.storedMetaData.get("VMS");
            String machine = (String)this.storedMetaData.get("machine");
            String directory = (String)this.storedMetaData.get("dir");
            Object[] obj = new Object[]{functionName, remoteFileName, userName, machine, share, directory};
            this.logManager.doLog(msg + "  " + this.resourceBundle.getString("successLog.5", obj));
        }
    }
}

