/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet.java1;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.netfile.servlet.java1.FileOption;
import com.sun.portal.netfile.servlet.java1.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.java1.NetFileContextImpl;
import com.sun.portal.netfile.servlet.java1.NetFileException;
import com.sun.portal.netfile.servlet.java1.NetFileHostDataProcessor;
import com.sun.portal.netfile.servlet.java1.NetFileLogManager;
import com.sun.portal.netfile.servlet.java1.NetFileResource;
import com.sun.portal.netfile.servlet.java1.NetFileServlet;
import com.sun.portal.netfile.servlet.java1.SessionTempDirCounter;
import java.io.File;
import java.security.Principal;
import java.util.Map;

public class NetFileSessionInitializer {
    public NetFileLogManager logMgr;
    private Debug debug;
    private static boolean is_first_request = true;
    private char c_eol = (char)10;
    private String s_empty_string = "";
    private static final String DEFAULT_TEMPORARY_DIRECTORY = "/tmp";

    public NetFileSessionInitializer(NetFileLogManager logManager) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.logMgr = logManager;
    }

    void reInitialiseUserSession(SSOToken ssoToken, NetFileServlet nfs_token_listener) throws Throwable {
        try {
            ssoToken.addSSOTokenListener((SSOTokenListener)nfs_token_listener);
            NetFileContextImpl nfContext = new NetFileContextImpl(ssoToken);
            Map[] prefs = nfContext.getPreferences();
            NetFileAttributeExtractor nfAttrs = new NetFileAttributeExtractor(prefs[0]);
            this.createTemporaryDirectory(ssoToken, nfAttrs);
        }
        catch (Exception e) {
            this.debug.error("Exception while reinitialising user session", (Throwable)e);
        }
    }

    String initialiseNewUserSession(SSOToken ssoToken, NetFileResource nfr_user_locale_i18n_bucket, NetFileServlet nfs_token_listener, String htmlCharset) throws Throwable {
        String genExcepStr = this.s_empty_string;
        String winsize = this.s_empty_string;
        String winloc = this.s_empty_string;
        String ntdomain = this.s_empty_string;
        String szDefaultDomain = this.s_empty_string;
        boolean allowdelprival = true;
        boolean chguidprival = true;
        boolean chgdomprival = true;
        StringBuffer returnbufstr = new StringBuffer(1000);
        try {
            ssoToken.addSSOTokenListener((SSOTokenListener)nfs_token_listener);
            Principal princi = ssoToken.getPrincipal();
            String userIdentity = princi.getName();
            int startIndex = userIdentity.indexOf(61, 0);
            int endIndex = userIdentity.indexOf(44, 0);
            returnbufstr.append("userid=" + userIdentity.substring(startIndex + 1, endIndex)).append(this.c_eol);
            NetFileContextImpl nfContext = new NetFileContextImpl(ssoToken);
            Map[] prefs = nfContext.getPreferences();
            NetFileAttributeExtractor nfAttrs = new NetFileAttributeExtractor(prefs[0]);
            returnbufstr.append(nfContext.getMailPreferences());
            returnbufstr.append("sunPortalNetFileNTDomain=").append(nfAttrs.getString("sunPortalNetFileNTDomain", this.s_empty_string)).append(this.c_eol);
            szDefaultDomain = nfAttrs.getString("sunPortalNetFileDefaultDomain", "");
            returnbufstr.append("sunPortalNetFileDefaultDomain=").append(szDefaultDomain);
            returnbufstr.append("sunPortalNetFileWindowLocation=").append(nfAttrs.getString("sunPortalNetFileWindowLocation", "100|50")).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileWindowSize=").append(nfAttrs.getString("sunPortalNetFileWindowSize", "700|400")).append(this.c_eol);
            returnbufstr.append("iplanet-am-user-preferredlocale=").append(nfContext.getUserLocale()).append(this.c_eol);
            returnbufstr.append("htmlCharset=").append(htmlCharset).append(this.c_eol);
            NetFileHostDataProcessor nfhdp = new NetFileHostDataProcessor(this.logMgr, ssoToken, nfr_user_locale_i18n_bucket);
            nfhdp.setDefaultDomain(szDefaultDomain);
            returnbufstr = nfhdp.processHostsData(returnbufstr, nfContext, nfAttrs, nfr_user_locale_i18n_bucket);
            returnbufstr.append("sunPortalNetFileMaxSearchDir=").append(nfAttrs.getInt("sunPortalNetFileMaxSearchDir", 100)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAccessWin=").append(nfAttrs.getBoolean("sunPortalNetFileAccessWin", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAccessNFS=").append(nfAttrs.getBoolean("sunPortalNetFileAccessNFS", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAccessFTP=").append(nfAttrs.getBoolean("sunPortalNetFileAccessFTP", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAccessNetware=").append(nfAttrs.getBoolean("sunPortalNetFileAccessNetware", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowDelete=").append(nfAttrs.getBoolean("sunPortalNetFileAllowDelete", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowRename=").append(nfAttrs.getBoolean("sunPortalNetFileAllowRename", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowMail=").append(nfAttrs.getBoolean("sunPortalNetFileAllowMail", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowSearch=").append(nfAttrs.getBoolean("sunPortalNetFileAllowSearch", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowCompression=").append(nfAttrs.getBoolean("sunPortalNetFileAllowCompression", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowUpload=").append(nfAttrs.getBoolean("sunPortalNetFileAllowUpload", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowDownload=").append(nfAttrs.getBoolean("sunPortalNetFileAllowDownload", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowChangeUserId=").append(nfAttrs.getBoolean("sunPortalNetFileAllowChangeUserId", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileAllowChangeDomain=").append(nfAttrs.getBoolean("sunPortalNetFileAllowChangeDomain", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileFileUploadLimit=").append(nfAttrs.getInt("sunPortalNetFileFileUploadLimit", 5)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileExecute=").append(nfAttrs.getBoolean("sunPortalNetFileExecute", true)).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileOSCharSet=").append(nfAttrs.getString("sunPortalNetFileOSCharSet", "Unicode(UTF-8)")).append(this.c_eol);
            returnbufstr.append("iplanet-srap-netfile-application-tempdir=").append(this.createTemporaryDirectory(ssoToken, nfAttrs)).append(this.c_eol);
            this.logSessionStartTime(this.logMgr, ssoToken);
            nfAttrs.setUserAttributesMap(prefs[1]);
            returnbufstr.append("sunPortalNetFileApplicationName=").append(nfAttrs.getString("sunPortalNetFileApplicationName", "Sun JavaTM System Portal Server")).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileApplicationRelease=").append(nfAttrs.getString("sunPortalNetFileApplicationRelease", "6")).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileApplicationReleaseDate=").append(nfAttrs.getString("sunPortalNetFileApplicationReleaseDate", "2004Q2")).append(this.c_eol);
            returnbufstr.append("sunPortalNetFileCompanyName=").append(nfAttrs.getString("sunPortalNetFileCompanyName", "Sun Microsystems Inc.")).append(this.c_eol);
        }
        catch (Exception e) {
            returnbufstr.append("Exception " + e.getMessage()).append(this.c_eol);
            genExcepStr = e.getMessage();
            this.debug.error("Exception getting attributes data", (Throwable)e);
        }
        return returnbufstr.toString();
    }

    private void logSessionStartTime(NetFileLogManager logMgr, SSOToken ssoToken) {
        try {
            FileOption file_option = new FileOption(logMgr, "UTF8", ssoToken);
            if (is_first_request) {
                file_option.doLog(file_option.getPlatformLocalisedString("netfile_starts"));
                is_first_request = false;
            } else {
                file_option.doLog(file_option.getPlatformLocalisedString("session_starts"));
            }
        }
        catch (Exception e) {
            this.debug.error("Could not log session start time in iwtPlatformLocale ", (Throwable)e);
        }
    }

    String createTemporaryDirectory(SSOToken ssoToken, NetFileAttributeExtractor nfAttrs) throws NetFileException {
        String tmpdir = DEFAULT_TEMPORARY_DIRECTORY;
        try {
            tmpdir = nfAttrs.getString("sunPortalNetFileTempDir", DEFAULT_TEMPORARY_DIRECTORY);
        }
        catch (Exception e) {
            throw new NetFileException("Could not obtain temporary directory from profile");
        }
        if (tmpdir == null || tmpdir.equals(this.s_empty_string)) {
            tmpdir = DEFAULT_TEMPORARY_DIRECTORY;
        }
        tmpdir = this.getTemporaryDirectory(ssoToken, tmpdir);
        try {
            File temporary_directory = new File(tmpdir);
            if (!temporary_directory.exists()) {
                temporary_directory.mkdirs();
            }
            if (!temporary_directory.exists()) {
                throw new Exception("Temporary directory " + tmpdir + " could not be created");
            }
            if (!temporary_directory.canRead()) {
                throw new Exception("No read permission for " + tmpdir);
            }
            if (!temporary_directory.canWrite()) {
                throw new Exception("No write permission for " + tmpdir);
            }
        }
        catch (Exception e) {
            this.debug.message("Could not create temporary directory :" + tmpdir, (Throwable)e);
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_create_temp_directory_or_permission_denied", tmpdir});
        }
        return tmpdir;
    }

    String getTemporaryDirectory(SSOToken ssoToken, String s_temporary_directory) {
        s_temporary_directory = this.createTemporaryDirectoryName(ssoToken, s_temporary_directory);
        NetFileServlet.putTemporaryDirectoryForSSOToken(ssoToken, s_temporary_directory);
        NetFileServlet.putTempDirCount(ssoToken, new SessionTempDirCounter());
        this.debug.message("Temp directory is " + s_temporary_directory);
        return s_temporary_directory;
    }

    String createTemporaryDirectoryName(SSOToken ssoToken, String s_temporary_directory) {
        this.debug.message("Original tmp directory is " + s_temporary_directory);
        String s_sso_token = ssoToken.getTokenID().toString();
        int i_index = s_sso_token.indexOf(64);
        int i_length = s_sso_token.length();
        for (int i = 0; i < i_length; ++i) {
            if (Character.isJavaIdentifierPart(s_sso_token.charAt(i))) continue;
            if (i <= 1) break;
            i_index = i;
            break;
        }
        return s_temporary_directory + "/" + s_sso_token.substring(0, i_index);
    }
}

